/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.CapacityReservationSpecification;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceCapacityReservationAttributesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceCapacityReservationAttributesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceCapacityReservationAttributesRequest.getter(ModifyInstanceCapacityReservationAttributesRequest::instanceId)).setter(ModifyInstanceCapacityReservationAttributesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<CapacityReservationSpecification> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(ModifyInstanceCapacityReservationAttributesRequest.getter(ModifyInstanceCapacityReservationAttributesRequest::capacityReservationSpecification)).setter(ModifyInstanceCapacityReservationAttributesRequest.setter(Builder::capacityReservationSpecification)).constructor(CapacityReservationSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("CapacityReservationSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD));
    private final String instanceId;
    private final CapacityReservationSpecification capacityReservationSpecification;

    private ModifyInstanceCapacityReservationAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final CapacityReservationSpecification capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceCapacityReservationAttributesRequest)) {
            return false;
        }
        ModifyInstanceCapacityReservationAttributesRequest other = (ModifyInstanceCapacityReservationAttributesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyInstanceCapacityReservationAttributesRequest").add("InstanceId", (Object)this.instanceId()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceCapacityReservationAttributesRequest, T> g) {
        return obj -> g.apply((ModifyInstanceCapacityReservationAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private CapacityReservationSpecification capacityReservationSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceCapacityReservationAttributesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final CapacityReservationSpecification.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(CapacityReservationSpecification capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(CapacityReservationSpecification.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceCapacityReservationAttributesRequest build() {
            return new ModifyInstanceCapacityReservationAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceCapacityReservationAttributesRequest> {
        public Builder instanceId(String var1);

        public Builder capacityReservationSpecification(CapacityReservationSpecification var1);

        default public Builder capacityReservationSpecification(Consumer<CapacityReservationSpecification.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((CapacityReservationSpecification)((CapacityReservationSpecification.Builder)CapacityReservationSpecification.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

