/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AssociationStatus;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateClientVpnTargetNetworkResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, AssociateClientVpnTargetNetworkResponse> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(AssociateClientVpnTargetNetworkResponse.getter(AssociateClientVpnTargetNetworkResponse::associationId)).setter(AssociateClientVpnTargetNetworkResponse.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<AssociationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(AssociateClientVpnTargetNetworkResponse.getter(AssociateClientVpnTargetNetworkResponse::status)).setter(AssociateClientVpnTargetNetworkResponse.setter(Builder::status)).constructor(AssociationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, STATUS_FIELD));
    private final String associationId;
    private final AssociationStatus status;

    private AssociateClientVpnTargetNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.status = builder.status;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final AssociationStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateClientVpnTargetNetworkResponse)) {
            return false;
        }
        AssociateClientVpnTargetNetworkResponse other = (AssociateClientVpnTargetNetworkResponse)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateClientVpnTargetNetworkResponse").add("AssociationId", (Object)this.associationId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateClientVpnTargetNetworkResponse, T> g) {
        return obj -> g.apply((AssociateClientVpnTargetNetworkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String associationId;
        private AssociationStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateClientVpnTargetNetworkResponse model) {
            super(model);
            this.associationId(model.associationId);
            this.status(model.status);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final AssociationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public AssociateClientVpnTargetNetworkResponse build() {
            return new AssociateClientVpnTargetNetworkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateClientVpnTargetNetworkResponse> {
        public Builder associationId(String var1);

        public Builder status(AssociationStatus var1);

        default public Builder status(Consumer<AssociationStatus.Builder> status) {
            return this.status((AssociationStatus)((AssociationStatus.Builder)AssociationStatus.builder().applyMutation(status)).build());
        }
    }
}

