/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ExportTaskS3Location;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportImageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ExportImageResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ExportImageResponse.getter(ExportImageResponse::description)).setter(ExportImageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskImageFormat").getter(ExportImageResponse.getter(ExportImageResponse::diskImageFormatAsString)).setter(ExportImageResponse.setter(Builder::diskImageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat").unmarshallLocationName("diskImageFormat").build()}).build();
    private static final SdkField<String> EXPORT_IMAGE_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportImageTaskId").getter(ExportImageResponse.getter(ExportImageResponse::exportImageTaskId)).setter(ExportImageResponse.setter(Builder::exportImageTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportImageTaskId").unmarshallLocationName("exportImageTaskId").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ExportImageResponse.getter(ExportImageResponse::imageId)).setter(ExportImageResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleName").getter(ExportImageResponse.getter(ExportImageResponse::roleName)).setter(ExportImageResponse.setter(Builder::roleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").unmarshallLocationName("roleName").build()}).build();
    private static final SdkField<String> PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Progress").getter(ExportImageResponse.getter(ExportImageResponse::progress)).setter(ExportImageResponse.setter(Builder::progress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").unmarshallLocationName("progress").build()}).build();
    private static final SdkField<ExportTaskS3Location> S3_EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ExportLocation").getter(ExportImageResponse.getter(ExportImageResponse::s3ExportLocation)).setter(ExportImageResponse.setter(Builder::s3ExportLocation)).constructor(ExportTaskS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ExportLocation").unmarshallLocationName("s3ExportLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ExportImageResponse.getter(ExportImageResponse::status)).setter(ExportImageResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ExportImageResponse.getter(ExportImageResponse::statusMessage)).setter(ExportImageResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ExportImageResponse.getter(ExportImageResponse::tags)).setter(ExportImageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DISK_IMAGE_FORMAT_FIELD, EXPORT_IMAGE_TASK_ID_FIELD, IMAGE_ID_FIELD, ROLE_NAME_FIELD, PROGRESS_FIELD, S3_EXPORT_LOCATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));
    private final String description;
    private final String diskImageFormat;
    private final String exportImageTaskId;
    private final String imageId;
    private final String roleName;
    private final String progress;
    private final ExportTaskS3Location s3ExportLocation;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;

    private ExportImageResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.diskImageFormat = builder.diskImageFormat;
        this.exportImageTaskId = builder.exportImageTaskId;
        this.imageId = builder.imageId;
        this.roleName = builder.roleName;
        this.progress = builder.progress;
        this.s3ExportLocation = builder.s3ExportLocation;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public final String diskImageFormatAsString() {
        return this.diskImageFormat;
    }

    public final String exportImageTaskId() {
        return this.exportImageTaskId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String roleName() {
        return this.roleName;
    }

    public final String progress() {
        return this.progress;
    }

    public final ExportTaskS3Location s3ExportLocation() {
        return this.s3ExportLocation;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportImageTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageResponse)) {
            return false;
        }
        ExportImageResponse other = (ExportImageResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.diskImageFormatAsString(), other.diskImageFormatAsString()) && Objects.equals(this.exportImageTaskId(), other.exportImageTaskId()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.roleName(), other.roleName()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.s3ExportLocation(), other.s3ExportLocation()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ExportImageResponse").add("Description", (Object)this.description()).add("DiskImageFormat", (Object)this.diskImageFormatAsString()).add("ExportImageTaskId", (Object)this.exportImageTaskId()).add("ImageId", (Object)this.imageId()).add("RoleName", (Object)this.roleName()).add("Progress", (Object)this.progress()).add("S3ExportLocation", (Object)this.s3ExportLocation()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskImageFormat": {
                return Optional.ofNullable(clazz.cast(this.diskImageFormatAsString()));
            }
            case "ExportImageTaskId": {
                return Optional.ofNullable(clazz.cast(this.exportImageTaskId()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
            case "Progress": {
                return Optional.ofNullable(clazz.cast(this.progress()));
            }
            case "S3ExportLocation": {
                return Optional.ofNullable(clazz.cast(this.s3ExportLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportImageResponse, T> g) {
        return obj -> g.apply((ExportImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String description;
        private String diskImageFormat;
        private String exportImageTaskId;
        private String imageId;
        private String roleName;
        private String progress;
        private ExportTaskS3Location s3ExportLocation;
        private String status;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportImageResponse model) {
            super(model);
            this.description(model.description);
            this.diskImageFormat(model.diskImageFormat);
            this.exportImageTaskId(model.exportImageTaskId);
            this.imageId(model.imageId);
            this.roleName(model.roleName);
            this.progress(model.progress);
            this.s3ExportLocation(model.s3ExportLocation);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        @Override
        @Transient
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final String getExportImageTaskId() {
            return this.exportImageTaskId;
        }

        public final void setExportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
        }

        @Override
        @Transient
        public final Builder exportImageTaskId(String exportImageTaskId) {
            this.exportImageTaskId = exportImageTaskId;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final String getProgress() {
            return this.progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        @Transient
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final ExportTaskS3Location.Builder getS3ExportLocation() {
            return this.s3ExportLocation != null ? this.s3ExportLocation.toBuilder() : null;
        }

        public final void setS3ExportLocation(ExportTaskS3Location.BuilderImpl s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation != null ? s3ExportLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder s3ExportLocation(ExportTaskS3Location s3ExportLocation) {
            this.s3ExportLocation = s3ExportLocation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        @Transient
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExportImageResponse build() {
            return new ExportImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportImageResponse> {
        public Builder description(String var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder exportImageTaskId(String var1);

        public Builder imageId(String var1);

        public Builder roleName(String var1);

        public Builder progress(String var1);

        public Builder s3ExportLocation(ExportTaskS3Location var1);

        default public Builder s3ExportLocation(Consumer<ExportTaskS3Location.Builder> s3ExportLocation) {
            return this.s3ExportLocation((ExportTaskS3Location)((ExportTaskS3Location.Builder)ExportTaskS3Location.builder().applyMutation(s3ExportLocation)).build());
        }

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

