/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.AnalysisComponent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisLoadBalancerTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisLoadBalancerTarget> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(AnalysisLoadBalancerTarget.getter(AnalysisLoadBalancerTarget::address)).setter(AnalysisLoadBalancerTarget.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").unmarshallLocationName("address").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(AnalysisLoadBalancerTarget.getter(AnalysisLoadBalancerTarget::availabilityZone)).setter(AnalysisLoadBalancerTarget.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<AnalysisComponent> INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Instance").getter(AnalysisLoadBalancerTarget.getter(AnalysisLoadBalancerTarget::instance)).setter(AnalysisLoadBalancerTarget.setter(Builder::instance)).constructor(AnalysisComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").unmarshallLocationName("instance").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AnalysisLoadBalancerTarget.getter(AnalysisLoadBalancerTarget::port)).setter(AnalysisLoadBalancerTarget.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").unmarshallLocationName("port").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_FIELD, PORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String address;
    private final String availabilityZone;
    private final AnalysisComponent instance;
    private final Integer port;

    private AnalysisLoadBalancerTarget(BuilderImpl builder) {
        this.address = builder.address;
        this.availabilityZone = builder.availabilityZone;
        this.instance = builder.instance;
        this.port = builder.port;
    }

    public final String address() {
        return this.address;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final AnalysisComponent instance() {
        return this.instance;
    }

    public final Integer port() {
        return this.port;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisLoadBalancerTarget)) {
            return false;
        }
        AnalysisLoadBalancerTarget other = (AnalysisLoadBalancerTarget)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instance(), other.instance()) && Objects.equals(this.port(), other.port());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisLoadBalancerTarget").add("Address", (Object)this.address()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Instance", (Object)this.instance()).add("Port", (Object)this.port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Instance": {
                return Optional.ofNullable(clazz.cast(this.instance()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisLoadBalancerTarget, T> g) {
        return obj -> g.apply((AnalysisLoadBalancerTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private String availabilityZone;
        private AnalysisComponent instance;
        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisLoadBalancerTarget model) {
            this.address(model.address);
            this.availabilityZone(model.availabilityZone);
            this.instance(model.instance);
            this.port(model.port);
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        @Transient
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final AnalysisComponent.Builder getInstance() {
            return this.instance != null ? this.instance.toBuilder() : null;
        }

        public final void setInstance(AnalysisComponent.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        @Override
        @Transient
        public final Builder instance(AnalysisComponent instance) {
            this.instance = instance;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public AnalysisLoadBalancerTarget build() {
            return new AnalysisLoadBalancerTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisLoadBalancerTarget> {
        public Builder address(String var1);

        public Builder availabilityZone(String var1);

        public Builder instance(AnalysisComponent var1);

        default public Builder instance(Consumer<AnalysisComponent.Builder> instance) {
            return this.instance((AnalysisComponent)((AnalysisComponent.Builder)AnalysisComponent.builder().applyMutation(instance)).build());
        }

        public Builder port(Integer var1);
    }
}

