/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceType {
    CLIENT_VPN_ENDPOINT("client-vpn-endpoint"),
    CUSTOMER_GATEWAY("customer-gateway"),
    DEDICATED_HOST("dedicated-host"),
    DHCP_OPTIONS("dhcp-options"),
    EGRESS_ONLY_INTERNET_GATEWAY("egress-only-internet-gateway"),
    ELASTIC_IP("elastic-ip"),
    ELASTIC_GPU("elastic-gpu"),
    EXPORT_IMAGE_TASK("export-image-task"),
    EXPORT_INSTANCE_TASK("export-instance-task"),
    FLEET("fleet"),
    FPGA_IMAGE("fpga-image"),
    HOST_RESERVATION("host-reservation"),
    IMAGE("image"),
    IMPORT_IMAGE_TASK("import-image-task"),
    IMPORT_SNAPSHOT_TASK("import-snapshot-task"),
    INSTANCE("instance"),
    INTERNET_GATEWAY("internet-gateway"),
    KEY_PAIR("key-pair"),
    LAUNCH_TEMPLATE("launch-template"),
    LOCAL_GATEWAY_ROUTE_TABLE_VPC_ASSOCIATION("local-gateway-route-table-vpc-association"),
    NATGATEWAY("natgateway"),
    NETWORK_ACL("network-acl"),
    NETWORK_INTERFACE("network-interface"),
    NETWORK_INSIGHTS_ANALYSIS("network-insights-analysis"),
    NETWORK_INSIGHTS_PATH("network-insights-path"),
    PLACEMENT_GROUP("placement-group"),
    RESERVED_INSTANCES("reserved-instances"),
    ROUTE_TABLE("route-table"),
    SECURITY_GROUP("security-group"),
    SECURITY_GROUP_RULE("security-group-rule"),
    SNAPSHOT("snapshot"),
    SPOT_FLEET_REQUEST("spot-fleet-request"),
    SPOT_INSTANCES_REQUEST("spot-instances-request"),
    SUBNET("subnet"),
    TRAFFIC_MIRROR_FILTER("traffic-mirror-filter"),
    TRAFFIC_MIRROR_SESSION("traffic-mirror-session"),
    TRAFFIC_MIRROR_TARGET("traffic-mirror-target"),
    TRANSIT_GATEWAY("transit-gateway"),
    TRANSIT_GATEWAY_ATTACHMENT("transit-gateway-attachment"),
    TRANSIT_GATEWAY_CONNECT_PEER("transit-gateway-connect-peer"),
    TRANSIT_GATEWAY_MULTICAST_DOMAIN("transit-gateway-multicast-domain"),
    TRANSIT_GATEWAY_ROUTE_TABLE("transit-gateway-route-table"),
    VOLUME("volume"),
    VPC("vpc"),
    VPC_PEERING_CONNECTION("vpc-peering-connection"),
    VPN_CONNECTION("vpn-connection"),
    VPN_GATEWAY("vpn-gateway"),
    VPC_FLOW_LOG("vpc-flow-log"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        return Stream.of(ResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

