/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceUsage> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(InstanceUsage.getter(InstanceUsage::accountId)).setter(InstanceUsage.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").unmarshallLocationName("accountId").build()}).build();
    private static final SdkField<Integer> USED_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UsedInstanceCount").getter(InstanceUsage.getter(InstanceUsage::usedInstanceCount)).setter(InstanceUsage.setter(Builder::usedInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedInstanceCount").unmarshallLocationName("usedInstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USED_INSTANCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Integer usedInstanceCount;

    private InstanceUsage(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.usedInstanceCount = builder.usedInstanceCount;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Integer usedInstanceCount() {
        return this.usedInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usedInstanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceUsage)) {
            return false;
        }
        InstanceUsage other = (InstanceUsage)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.usedInstanceCount(), other.usedInstanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceUsage").add("AccountId", (Object)this.accountId()).add("UsedInstanceCount", (Object)this.usedInstanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "UsedInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.usedInstanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceUsage, T> g) {
        return obj -> g.apply((InstanceUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Integer usedInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceUsage model) {
            this.accountId(model.accountId);
            this.usedInstanceCount(model.usedInstanceCount);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final Integer getUsedInstanceCount() {
            return this.usedInstanceCount;
        }

        @Override
        public final Builder usedInstanceCount(Integer usedInstanceCount) {
            this.usedInstanceCount = usedInstanceCount;
            return this;
        }

        public final void setUsedInstanceCount(Integer usedInstanceCount) {
            this.usedInstanceCount = usedInstanceCount;
        }

        public InstanceUsage build() {
            return new InstanceUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceUsage> {
        public Builder accountId(String var1);

        public Builder usedInstanceCount(Integer var1);
    }
}

