/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterface;
import software.amazon.awssdk.services.ec2.model.LocalGatewayVirtualInterfaceSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLocalGatewayVirtualInterfacesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeLocalGatewayVirtualInterfacesResponse> {
    private static final SdkField<List<LocalGatewayVirtualInterface>> LOCAL_GATEWAY_VIRTUAL_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalGatewayVirtualInterfaces").getter(DescribeLocalGatewayVirtualInterfacesResponse.getter(DescribeLocalGatewayVirtualInterfacesResponse::localGatewayVirtualInterfaces)).setter(DescribeLocalGatewayVirtualInterfacesResponse.setter(Builder::localGatewayVirtualInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayVirtualInterfaceSet").unmarshallLocationName("localGatewayVirtualInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalGatewayVirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLocalGatewayVirtualInterfacesResponse.getter(DescribeLocalGatewayVirtualInterfacesResponse::nextToken)).setter(DescribeLocalGatewayVirtualInterfacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_GATEWAY_VIRTUAL_INTERFACES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces;
    private final String nextToken;

    private DescribeLocalGatewayVirtualInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayVirtualInterfaces = builder.localGatewayVirtualInterfaces;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLocalGatewayVirtualInterfaces() {
        return this.localGatewayVirtualInterfaces != null && !(this.localGatewayVirtualInterfaces instanceof SdkAutoConstructList);
    }

    public final List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces() {
        return this.localGatewayVirtualInterfaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalGatewayVirtualInterfaces() ? this.localGatewayVirtualInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayVirtualInterfacesResponse)) {
            return false;
        }
        DescribeLocalGatewayVirtualInterfacesResponse other = (DescribeLocalGatewayVirtualInterfacesResponse)((Object)obj);
        return this.hasLocalGatewayVirtualInterfaces() == other.hasLocalGatewayVirtualInterfaces() && Objects.equals(this.localGatewayVirtualInterfaces(), other.localGatewayVirtualInterfaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLocalGatewayVirtualInterfacesResponse").add("LocalGatewayVirtualInterfaces", this.hasLocalGatewayVirtualInterfaces() ? this.localGatewayVirtualInterfaces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalGatewayVirtualInterfaces": {
                return Optional.ofNullable(clazz.cast(this.localGatewayVirtualInterfaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayVirtualInterfacesResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayVirtualInterfacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayVirtualInterfacesResponse model) {
            super(model);
            this.localGatewayVirtualInterfaces(model.localGatewayVirtualInterfaces);
            this.nextToken(model.nextToken);
        }

        public final List<LocalGatewayVirtualInterface.Builder> getLocalGatewayVirtualInterfaces() {
            List<LocalGatewayVirtualInterface.Builder> result = LocalGatewayVirtualInterfaceSetCopier.copyToBuilder(this.localGatewayVirtualInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder localGatewayVirtualInterfaces(Collection<LocalGatewayVirtualInterface> localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces = LocalGatewayVirtualInterfaceSetCopier.copy(localGatewayVirtualInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaces(LocalGatewayVirtualInterface ... localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces(Arrays.asList(localGatewayVirtualInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayVirtualInterfaces(Consumer<LocalGatewayVirtualInterface.Builder> ... localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces(Stream.of(localGatewayVirtualInterfaces).map(c -> (LocalGatewayVirtualInterface)((LocalGatewayVirtualInterface.Builder)LocalGatewayVirtualInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayVirtualInterfaces(Collection<LocalGatewayVirtualInterface.BuilderImpl> localGatewayVirtualInterfaces) {
            this.localGatewayVirtualInterfaces = LocalGatewayVirtualInterfaceSetCopier.copyFromBuilder(localGatewayVirtualInterfaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayVirtualInterfacesResponse build() {
            return new DescribeLocalGatewayVirtualInterfacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLocalGatewayVirtualInterfacesResponse> {
        public Builder localGatewayVirtualInterfaces(Collection<LocalGatewayVirtualInterface> var1);

        public Builder localGatewayVirtualInterfaces(LocalGatewayVirtualInterface ... var1);

        public Builder localGatewayVirtualInterfaces(Consumer<LocalGatewayVirtualInterface.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

