/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;

public class DescribeSecurityGroupsIterable
implements SdkIterable<DescribeSecurityGroupsResponse> {
    private final Ec2Client client;
    private final DescribeSecurityGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSecurityGroupsIterable(Ec2Client client, DescribeSecurityGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSecurityGroupsResponseFetcher();
    }

    public Iterator<DescribeSecurityGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityGroup> securityGroups() {
        Function<DescribeSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityGroups() != null) {
                return response.securityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSecurityGroupsResponseFetcher
    implements SyncPageFetcher<DescribeSecurityGroupsResponse> {
        private DescribeSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSecurityGroupsResponse nextPage(DescribeSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSecurityGroupsIterable.this.client.describeSecurityGroups(DescribeSecurityGroupsIterable.this.firstRequest);
            }
            return DescribeSecurityGroupsIterable.this.client.describeSecurityGroups((DescribeSecurityGroupsRequest)((Object)DescribeSecurityGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

