/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VpcClassicLink;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcClassicLinkResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
    private static final SdkField<List<VpcClassicLink>> VPCS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Vpcs").getter(DescribeVpcClassicLinkResponse.getter(DescribeVpcClassicLinkResponse::vpcs)).setter(DescribeVpcClassicLinkResponse.setter(Builder::vpcs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSet").unmarshallLocationName("vpcSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcClassicLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPCS_FIELD));
    private final List<VpcClassicLink> vpcs;

    private DescribeVpcClassicLinkResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
    }

    public final boolean hasVpcs() {
        return this.vpcs != null && !(this.vpcs instanceof SdkAutoConstructList);
    }

    public final List<VpcClassicLink> vpcs() {
        return this.vpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcs() ? this.vpcs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkResponse)) {
            return false;
        }
        DescribeVpcClassicLinkResponse other = (DescribeVpcClassicLinkResponse)((Object)obj);
        return this.hasVpcs() == other.hasVpcs() && Objects.equals(this.vpcs(), other.vpcs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVpcClassicLinkResponse").add("Vpcs", this.hasVpcs() ? this.vpcs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpcs": {
                return Optional.ofNullable(clazz.cast(this.vpcs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcClassicLinkResponse, T> g) {
        return obj -> g.apply((DescribeVpcClassicLinkResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VpcClassicLink> vpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkResponse model) {
            super(model);
            this.vpcs(model.vpcs);
        }

        public final List<VpcClassicLink.Builder> getVpcs() {
            List<VpcClassicLink.Builder> result = VpcClassicLinkListCopier.copyToBuilder(this.vpcs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vpcs(Collection<VpcClassicLink> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(VpcClassicLink ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Consumer<VpcClassicLink.Builder> ... vpcs) {
            this.vpcs(Stream.of(vpcs).map(c -> (VpcClassicLink)((VpcClassicLink.Builder)VpcClassicLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcs(Collection<VpcClassicLink.BuilderImpl> vpcs) {
            this.vpcs = VpcClassicLinkListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public DescribeVpcClassicLinkResponse build() {
            return new DescribeVpcClassicLinkResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVpcClassicLinkResponse> {
        public Builder vpcs(Collection<VpcClassicLink> var1);

        public Builder vpcs(VpcClassicLink ... var1);

        public Builder vpcs(Consumer<VpcClassicLink.Builder> ... var1);
    }
}

