/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventType {
    INSTANCE_CHANGE("instanceChange"),
    FLEET_REQUEST_CHANGE("fleetRequestChange"),
    ERROR("error"),
    INFORMATION("information"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        return Stream.of(EventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

