/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisAclRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisAclRule> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(AnalysisAclRule.getter(AnalysisAclRule::cidr)).setter(AnalysisAclRule.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("cidr").build()}).build();
    private static final SdkField<Boolean> EGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Egress").getter(AnalysisAclRule.getter(AnalysisAclRule::egress)).setter(AnalysisAclRule.setter(Builder::egress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress").unmarshallLocationName("egress").build()}).build();
    private static final SdkField<PortRange> PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortRange").getter(AnalysisAclRule.getter(AnalysisAclRule::portRange)).setter(AnalysisAclRule.setter(Builder::portRange)).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRange").unmarshallLocationName("portRange").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(AnalysisAclRule.getter(AnalysisAclRule::protocol)).setter(AnalysisAclRule.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<String> RULE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleAction").getter(AnalysisAclRule.getter(AnalysisAclRule::ruleAction)).setter(AnalysisAclRule.setter(Builder::ruleAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleAction").unmarshallLocationName("ruleAction").build()}).build();
    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleNumber").getter(AnalysisAclRule.getter(AnalysisAclRule::ruleNumber)).setter(AnalysisAclRule.setter(Builder::ruleNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber").unmarshallLocationName("ruleNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, EGRESS_FIELD, PORT_RANGE_FIELD, PROTOCOL_FIELD, RULE_ACTION_FIELD, RULE_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final Boolean egress;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private AnalysisAclRule(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.egress = builder.egress;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final Boolean egress() {
        return this.egress;
    }

    public final PortRange portRange() {
        return this.portRange;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final String ruleAction() {
        return this.ruleAction;
    }

    public final Integer ruleNumber() {
        return this.ruleNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.egress());
        hashCode = 31 * hashCode + Objects.hashCode(this.portRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisAclRule)) {
            return false;
        }
        AnalysisAclRule other = (AnalysisAclRule)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.egress(), other.egress()) && Objects.equals(this.portRange(), other.portRange()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.ruleAction(), other.ruleAction()) && Objects.equals(this.ruleNumber(), other.ruleNumber());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisAclRule").add("Cidr", (Object)this.cidr()).add("Egress", (Object)this.egress()).add("PortRange", (Object)this.portRange()).add("Protocol", (Object)this.protocol()).add("RuleAction", (Object)this.ruleAction()).add("RuleNumber", (Object)this.ruleNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "Egress": {
                return Optional.ofNullable(clazz.cast(this.egress()));
            }
            case "PortRange": {
                return Optional.ofNullable(clazz.cast(this.portRange()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "RuleAction": {
                return Optional.ofNullable(clazz.cast(this.ruleAction()));
            }
            case "RuleNumber": {
                return Optional.ofNullable(clazz.cast(this.ruleNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisAclRule, T> g) {
        return obj -> g.apply((AnalysisAclRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private Boolean egress;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisAclRule model) {
            this.cidr(model.cidr);
            this.egress(model.egress);
            this.portRange(model.portRange);
            this.protocol(model.protocol);
            this.ruleAction(model.ruleAction);
            this.ruleNumber(model.ruleNumber);
        }

        public final String getCidr() {
            return this.cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final PortRange.Builder getPortRange() {
            return this.portRange != null ? this.portRange.toBuilder() : null;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange.BuilderImpl portRange) {
            this.portRange = portRange != null ? portRange.build() : null;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public AnalysisAclRule build() {
            return new AnalysisAclRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisAclRule> {
        public Builder cidr(String var1);

        public Builder egress(Boolean var1);

        public Builder portRange(PortRange var1);

        default public Builder portRange(Consumer<PortRange.Builder> portRange) {
            return this.portRange((PortRange)((PortRange.Builder)PortRange.builder().applyMutation(portRange)).build());
        }

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleNumber(Integer var1);
    }
}

