/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsPath;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInsightsPathsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeNetworkInsightsPathsResponse> {
    private static final SdkField<List<NetworkInsightsPath>> NETWORK_INSIGHTS_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInsightsPaths").getter(DescribeNetworkInsightsPathsResponse.getter(DescribeNetworkInsightsPathsResponse::networkInsightsPaths)).setter(DescribeNetworkInsightsPathsResponse.setter(Builder::networkInsightsPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathSet").unmarshallLocationName("networkInsightsPathSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInsightsPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInsightsPathsResponse.getter(DescribeNetworkInsightsPathsResponse::nextToken)).setter(DescribeNetworkInsightsPathsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_PATHS_FIELD, NEXT_TOKEN_FIELD));
    private final List<NetworkInsightsPath> networkInsightsPaths;
    private final String nextToken;

    private DescribeNetworkInsightsPathsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInsightsPaths = builder.networkInsightsPaths;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInsightsPaths() {
        return this.networkInsightsPaths != null && !(this.networkInsightsPaths instanceof SdkAutoConstructList);
    }

    public final List<NetworkInsightsPath> networkInsightsPaths() {
        return this.networkInsightsPaths;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInsightsPaths() ? this.networkInsightsPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsPathsResponse)) {
            return false;
        }
        DescribeNetworkInsightsPathsResponse other = (DescribeNetworkInsightsPathsResponse)((Object)obj);
        return this.hasNetworkInsightsPaths() == other.hasNetworkInsightsPaths() && Objects.equals(this.networkInsightsPaths(), other.networkInsightsPaths()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInsightsPathsResponse").add("NetworkInsightsPaths", this.hasNetworkInsightsPaths() ? this.networkInsightsPaths() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsPaths": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsPaths()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsPathsResponse, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsPathsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<NetworkInsightsPath> networkInsightsPaths = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsPathsResponse model) {
            super(model);
            this.networkInsightsPaths(model.networkInsightsPaths);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkInsightsPath.Builder> getNetworkInsightsPaths() {
            List<NetworkInsightsPath.Builder> result = NetworkInsightsPathListCopier.copyToBuilder(this.networkInsightsPaths);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder networkInsightsPaths(Collection<NetworkInsightsPath> networkInsightsPaths) {
            this.networkInsightsPaths = NetworkInsightsPathListCopier.copy(networkInsightsPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsPaths(NetworkInsightsPath ... networkInsightsPaths) {
            this.networkInsightsPaths(Arrays.asList(networkInsightsPaths));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsPaths(Consumer<NetworkInsightsPath.Builder> ... networkInsightsPaths) {
            this.networkInsightsPaths(Stream.of(networkInsightsPaths).map(c -> (NetworkInsightsPath)((NetworkInsightsPath.Builder)NetworkInsightsPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInsightsPaths(Collection<NetworkInsightsPath.BuilderImpl> networkInsightsPaths) {
            this.networkInsightsPaths = NetworkInsightsPathListCopier.copyFromBuilder(networkInsightsPaths);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNetworkInsightsPathsResponse build() {
            return new DescribeNetworkInsightsPathsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInsightsPathsResponse> {
        public Builder networkInsightsPaths(Collection<NetworkInsightsPath> var1);

        public Builder networkInsightsPaths(NetworkInsightsPath ... var1);

        public Builder networkInsightsPaths(Consumer<NetworkInsightsPath.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

