/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.IpRangeListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.Ipv6RangeListCopier;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.PrefixListIdListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpPermission> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FromPort").getter(IpPermission.getter(IpPermission::fromPort)).setter(IpPermission.setter(Builder::fromPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").unmarshallLocationName("fromPort").build()}).build();
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpProtocol").getter(IpPermission.getter(IpPermission::ipProtocol)).setter(IpPermission.setter(Builder::ipProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").unmarshallLocationName("ipProtocol").build()}).build();
    private static final SdkField<List<IpRange>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpRanges").getter(IpPermission.getter(IpPermission::ipRanges)).setter(IpPermission.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").unmarshallLocationName("ipRanges").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<Ipv6Range>> IPV6_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Ranges").getter(IpPermission.getter(IpPermission::ipv6Ranges)).setter(IpPermission.setter(Builder::ipv6Ranges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Ranges").unmarshallLocationName("ipv6Ranges").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6Range::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PrefixListId>> PREFIX_LIST_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrefixListIds").getter(IpPermission.getter(IpPermission::prefixListIds)).setter(IpPermission.setter(Builder::prefixListIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").unmarshallLocationName("prefixListIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrefixListId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ToPort").getter(IpPermission.getter(IpPermission::toPort)).setter(IpPermission.setter(Builder::toPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").unmarshallLocationName("toPort").build()}).build();
    private static final SdkField<List<UserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdGroupPairs").getter(IpPermission.getter(IpPermission::userIdGroupPairs)).setter(IpPermission.setter(Builder::userIdGroupPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").unmarshallLocationName("groups").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserIdGroupPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD, IP_PROTOCOL_FIELD, IP_RANGES_FIELD, IPV6_RANGES_FIELD, PREFIX_LIST_IDS_FIELD, TO_PORT_FIELD, USER_ID_GROUP_PAIRS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer fromPort;
    private final String ipProtocol;
    private final List<IpRange> ipRanges;
    private final List<Ipv6Range> ipv6Ranges;
    private final List<PrefixListId> prefixListIds;
    private final Integer toPort;
    private final List<UserIdGroupPair> userIdGroupPairs;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    public final Integer fromPort() {
        return this.fromPort;
    }

    public final String ipProtocol() {
        return this.ipProtocol;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<IpRange> ipRanges() {
        return this.ipRanges;
    }

    public final boolean hasIpv6Ranges() {
        return this.ipv6Ranges != null && !(this.ipv6Ranges instanceof SdkAutoConstructList);
    }

    public final List<Ipv6Range> ipv6Ranges() {
        return this.ipv6Ranges;
    }

    public final boolean hasPrefixListIds() {
        return this.prefixListIds != null && !(this.prefixListIds instanceof SdkAutoConstructList);
    }

    public final List<PrefixListId> prefixListIds() {
        return this.prefixListIds;
    }

    public final Integer toPort() {
        return this.toPort;
    }

    public final boolean hasUserIdGroupPairs() {
        return this.userIdGroupPairs != null && !(this.userIdGroupPairs instanceof SdkAutoConstructList);
    }

    public final List<UserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Ranges() ? this.ipv6Ranges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrefixListIds() ? this.prefixListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdGroupPairs() ? this.userIdGroupPairs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && this.hasIpv6Ranges() == other.hasIpv6Ranges() && Objects.equals(this.ipv6Ranges(), other.ipv6Ranges()) && this.hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(this.prefixListIds(), other.prefixListIds()) && Objects.equals(this.toPort(), other.toPort()) && this.hasUserIdGroupPairs() == other.hasUserIdGroupPairs() && Objects.equals(this.userIdGroupPairs(), other.userIdGroupPairs());
    }

    public final String toString() {
        return ToString.builder((String)"IpPermission").add("FromPort", (Object)this.fromPort()).add("IpProtocol", (Object)this.ipProtocol()).add("IpRanges", this.hasIpRanges() ? this.ipRanges() : null).add("Ipv6Ranges", this.hasIpv6Ranges() ? this.ipv6Ranges() : null).add("PrefixListIds", this.hasPrefixListIds() ? this.prefixListIds() : null).add("ToPort", (Object)this.toPort()).add("UserIdGroupPairs", this.hasUserIdGroupPairs() ? this.userIdGroupPairs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "Ipv6Ranges": {
                return Optional.ofNullable(clazz.cast(this.ipv6Ranges()));
            }
            case "PrefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "UserIdGroupPairs": {
                return Optional.ofNullable(clazz.cast(this.userIdGroupPairs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpPermission, T> g) {
        return obj -> g.apply((IpPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private String ipProtocol;
        private List<IpRange> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<Ipv6Range> ipv6Ranges = DefaultSdkAutoConstructList.getInstance();
        private List<PrefixListId> prefixListIds = DefaultSdkAutoConstructList.getInstance();
        private Integer toPort;
        private List<UserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            this.fromPort(model.fromPort);
            this.ipProtocol(model.ipProtocol);
            this.ipRanges(model.ipRanges);
            this.ipv6Ranges(model.ipv6Ranges);
            this.prefixListIds(model.prefixListIds);
            this.toPort(model.toPort);
            this.userIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final List<IpRange.Builder> getIpRanges() {
            List<IpRange.Builder> result = IpRangeListCopier.copyToBuilder(this.ipRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipRanges(Collection<IpRange> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IpRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<IpRange.Builder> ... ipRanges) {
            this.ipRanges(Stream.of(ipRanges).map(c -> (IpRange)((IpRange.Builder)IpRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<IpRange.BuilderImpl> ipRanges) {
            this.ipRanges = IpRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final List<Ipv6Range.Builder> getIpv6Ranges() {
            List<Ipv6Range.Builder> result = Ipv6RangeListCopier.copyToBuilder(this.ipv6Ranges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range ... ipv6Ranges) {
            this.ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Consumer<Ipv6Range.Builder> ... ipv6Ranges) {
            this.ipv6Ranges(Stream.of(ipv6Ranges).map(c -> (Ipv6Range)((Ipv6Range.Builder)Ipv6Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final List<PrefixListId.Builder> getPrefixListIds() {
            List<PrefixListId.Builder> result = PrefixListIdListCopier.copyToBuilder(this.prefixListIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(Consumer<PrefixListId.Builder> ... prefixListIds) {
            this.prefixListIds(Stream.of(prefixListIds).map(c -> (PrefixListId)((PrefixListId.Builder)PrefixListId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final List<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            List<UserIdGroupPair.Builder> result = UserIdGroupPairListCopier.copyToBuilder(this.userIdGroupPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... userIdGroupPairs) {
            this.userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> (UserIdGroupPair)((UserIdGroupPair.Builder)UserIdGroupPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        public IpPermission build() {
            return new IpPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpPermission> {
        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder ipRanges(Collection<IpRange> var1);

        public Builder ipRanges(IpRange ... var1);

        public Builder ipRanges(Consumer<IpRange.Builder> ... var1);

        public Builder ipv6Ranges(Collection<Ipv6Range> var1);

        public Builder ipv6Ranges(Ipv6Range ... var1);

        public Builder ipv6Ranges(Consumer<Ipv6Range.Builder> ... var1);

        public Builder prefixListIds(Collection<PrefixListId> var1);

        public Builder prefixListIds(PrefixListId ... var1);

        public Builder prefixListIds(Consumer<PrefixListId.Builder> ... var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<UserIdGroupPair> var1);

        public Builder userIdGroupPairs(UserIdGroupPair ... var1);

        public Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... var1);
    }
}

