/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.ContainerFormat;
import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportToS3Task
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportToS3Task> {
    private static final SdkField<String> CONTAINER_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerFormat").getter(ExportToS3Task.getter(ExportToS3Task::containerFormatAsString)).setter(ExportToS3Task.setter(Builder::containerFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFormat").unmarshallLocationName("containerFormat").build()}).build();
    private static final SdkField<String> DISK_IMAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskImageFormat").getter(ExportToS3Task.getter(ExportToS3Task::diskImageFormatAsString)).setter(ExportToS3Task.setter(Builder::diskImageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskImageFormat").unmarshallLocationName("diskImageFormat").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(ExportToS3Task.getter(ExportToS3Task::s3Bucket)).setter(ExportToS3Task.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").unmarshallLocationName("s3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(ExportToS3Task.getter(ExportToS3Task::s3Key)).setter(ExportToS3Task.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").unmarshallLocationName("s3Key").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FORMAT_FIELD, DISK_IMAGE_FORMAT_FIELD, S3_BUCKET_FIELD, S3_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerFormat;
    private final String diskImageFormat;
    private final String s3Bucket;
    private final String s3Key;

    private ExportToS3Task(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    public final ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(this.containerFormat);
    }

    public final String containerFormatAsString() {
        return this.containerFormat;
    }

    public final DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(this.diskImageFormat);
    }

    public final String diskImageFormatAsString() {
        return this.diskImageFormat;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3Task)) {
            return false;
        }
        ExportToS3Task other = (ExportToS3Task)obj;
        return Objects.equals(this.containerFormatAsString(), other.containerFormatAsString()) && Objects.equals(this.diskImageFormatAsString(), other.diskImageFormatAsString()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key());
    }

    public final String toString() {
        return ToString.builder((String)"ExportToS3Task").add("ContainerFormat", (Object)this.containerFormatAsString()).add("DiskImageFormat", (Object)this.diskImageFormatAsString()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerFormat": {
                return Optional.ofNullable(clazz.cast(this.containerFormatAsString()));
            }
            case "DiskImageFormat": {
                return Optional.ofNullable(clazz.cast(this.diskImageFormatAsString()));
            }
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportToS3Task, T> g) {
        return obj -> g.apply((ExportToS3Task)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerFormat;
        private String diskImageFormat;
        private String s3Bucket;
        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3Task model) {
            this.containerFormat(model.containerFormat);
            this.diskImageFormat(model.diskImageFormat);
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat == null ? null : containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final String getDiskImageFormat() {
            return this.diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat == null ? null : diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        public ExportToS3Task build() {
            return new ExportToS3Task(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportToS3Task> {
        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder diskImageFormat(String var1);

        public Builder diskImageFormat(DiskImageFormat var1);

        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);
    }
}

