/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.ProductCodeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotAttributeResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
    private static final SdkField<List<CreateVolumePermission>> CREATE_VOLUME_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreateVolumePermissions").getter(DescribeSnapshotAttributeResponse.getter(DescribeSnapshotAttributeResponse::createVolumePermissions)).setter(DescribeSnapshotAttributeResponse.setter(Builder::createVolumePermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateVolumePermission").unmarshallLocationName("createVolumePermission").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateVolumePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ProductCode>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(DescribeSnapshotAttributeResponse.getter(DescribeSnapshotAttributeResponse::productCodes)).setter(DescribeSnapshotAttributeResponse.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").unmarshallLocationName("productCodes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(DescribeSnapshotAttributeResponse.getter(DescribeSnapshotAttributeResponse::snapshotId)).setter(DescribeSnapshotAttributeResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_VOLUME_PERMISSIONS_FIELD, PRODUCT_CODES_FIELD, SNAPSHOT_ID_FIELD));
    private final List<CreateVolumePermission> createVolumePermissions;
    private final List<ProductCode> productCodes;
    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    public final boolean hasCreateVolumePermissions() {
        return this.createVolumePermissions != null && !(this.createVolumePermissions instanceof SdkAutoConstructList);
    }

    public final List<CreateVolumePermission> createVolumePermissions() {
        return this.createVolumePermissions;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCode> productCodes() {
        return this.productCodes;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreateVolumePermissions() ? this.createVolumePermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse)((Object)obj);
        return this.hasCreateVolumePermissions() == other.hasCreateVolumePermissions() && Objects.equals(this.createVolumePermissions(), other.createVolumePermissions()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.snapshotId(), other.snapshotId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotAttributeResponse").add("CreateVolumePermissions", this.hasCreateVolumePermissions() ? this.createVolumePermissions() : null).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).add("SnapshotId", (Object)this.snapshotId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateVolumePermissions": {
                return Optional.ofNullable(clazz.cast(this.createVolumePermissions()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotAttributeResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotAttributeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CreateVolumePermission> createVolumePermissions = DefaultSdkAutoConstructList.getInstance();
        private List<ProductCode> productCodes = DefaultSdkAutoConstructList.getInstance();
        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            super(model);
            this.createVolumePermissions(model.createVolumePermissions);
            this.productCodes(model.productCodes);
            this.snapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission.Builder> getCreateVolumePermissions() {
            if (this.createVolumePermissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.createVolumePermissions != null ? (Collection)this.createVolumePermissions.stream().map(CreateVolumePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission ... createVolumePermissions) {
            this.createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder> ... createVolumePermissions) {
            this.createVolumePermissions(Stream.of(createVolumePermissions).map(c -> (CreateVolumePermission)((CreateVolumePermission.Builder)CreateVolumePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission.BuilderImpl> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copyFromBuilder(createVolumePermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            if (this.productCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productCodes != null ? (Collection)this.productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCode)((ProductCode.Builder)ProductCode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        public Builder createVolumePermissions(Collection<CreateVolumePermission> var1);

        public Builder createVolumePermissions(CreateVolumePermission ... var1);

        public Builder createVolumePermissions(Consumer<CreateVolumePermission.Builder> ... var1);

        public Builder productCodes(Collection<ProductCode> var1);

        public Builder productCodes(ProductCode ... var1);

        public Builder productCodes(Consumer<ProductCode.Builder> ... var1);

        public Builder snapshotId(String var1);
    }
}

