/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeClientVpnIngressRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AuthorizeClientVpnIngressRequest> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::clientVpnEndpointId)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> TARGET_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetNetworkCidr").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::targetNetworkCidr)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::targetNetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNetworkCidr").unmarshallLocationName("TargetNetworkCidr").build()}).build();
    private static final SdkField<String> ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGroupId").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::accessGroupId)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::accessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGroupId").unmarshallLocationName("AccessGroupId").build()}).build();
    private static final SdkField<Boolean> AUTHORIZE_ALL_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AuthorizeAllGroups").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::authorizeAllGroups)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::authorizeAllGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizeAllGroups").unmarshallLocationName("AuthorizeAllGroups").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::description)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AuthorizeClientVpnIngressRequest.getter(AuthorizeClientVpnIngressRequest::clientToken)).setter(AuthorizeClientVpnIngressRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, TARGET_NETWORK_CIDR_FIELD, ACCESS_GROUP_ID_FIELD, AUTHORIZE_ALL_GROUPS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String clientVpnEndpointId;
    private final String targetNetworkCidr;
    private final String accessGroupId;
    private final Boolean authorizeAllGroups;
    private final String description;
    private final String clientToken;

    private AuthorizeClientVpnIngressRequest(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.targetNetworkCidr = builder.targetNetworkCidr;
        this.accessGroupId = builder.accessGroupId;
        this.authorizeAllGroups = builder.authorizeAllGroups;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String targetNetworkCidr() {
        return this.targetNetworkCidr;
    }

    public final String accessGroupId() {
        return this.accessGroupId;
    }

    public final Boolean authorizeAllGroups() {
        return this.authorizeAllGroups;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizeAllGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeClientVpnIngressRequest)) {
            return false;
        }
        AuthorizeClientVpnIngressRequest other = (AuthorizeClientVpnIngressRequest)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.targetNetworkCidr(), other.targetNetworkCidr()) && Objects.equals(this.accessGroupId(), other.accessGroupId()) && Objects.equals(this.authorizeAllGroups(), other.authorizeAllGroups()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeClientVpnIngressRequest").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("TargetNetworkCidr", (Object)this.targetNetworkCidr()).add("AccessGroupId", (Object)this.accessGroupId()).add("AuthorizeAllGroups", (Object)this.authorizeAllGroups()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "TargetNetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.targetNetworkCidr()));
            }
            case "AccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.accessGroupId()));
            }
            case "AuthorizeAllGroups": {
                return Optional.ofNullable(clazz.cast(this.authorizeAllGroups()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeClientVpnIngressRequest, T> g) {
        return obj -> g.apply((AuthorizeClientVpnIngressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String targetNetworkCidr;
        private String accessGroupId;
        private Boolean authorizeAllGroups;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeClientVpnIngressRequest model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.targetNetworkCidr(model.targetNetworkCidr);
            this.accessGroupId(model.accessGroupId);
            this.authorizeAllGroups(model.authorizeAllGroups);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getTargetNetworkCidr() {
            return this.targetNetworkCidr;
        }

        @Override
        public final Builder targetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
            return this;
        }

        public final void setTargetNetworkCidr(String targetNetworkCidr) {
            this.targetNetworkCidr = targetNetworkCidr;
        }

        public final String getAccessGroupId() {
            return this.accessGroupId;
        }

        @Override
        public final Builder accessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
            return this;
        }

        public final void setAccessGroupId(String accessGroupId) {
            this.accessGroupId = accessGroupId;
        }

        public final Boolean getAuthorizeAllGroups() {
            return this.authorizeAllGroups;
        }

        @Override
        public final Builder authorizeAllGroups(Boolean authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
            return this;
        }

        public final void setAuthorizeAllGroups(Boolean authorizeAllGroups) {
            this.authorizeAllGroups = authorizeAllGroups;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeClientVpnIngressRequest build() {
            return new AuthorizeClientVpnIngressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeClientVpnIngressRequest> {
        public Builder clientVpnEndpointId(String var1);

        public Builder targetNetworkCidr(String var1);

        public Builder accessGroupId(String var1);

        public Builder authorizeAllGroups(Boolean var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

