/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.PortRangeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisPacketHeader
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisPacketHeader> {
    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationAddresses").getter(AnalysisPacketHeader.getter(AnalysisPacketHeader::destinationAddresses)).setter(AnalysisPacketHeader.setter(Builder::destinationAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddressSet").unmarshallLocationName("destinationAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> DESTINATION_PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationPortRanges").getter(AnalysisPacketHeader.getter(AnalysisPacketHeader::destinationPortRanges)).setter(AnalysisPacketHeader.setter(Builder::destinationPortRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRangeSet").unmarshallLocationName("destinationPortRangeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(AnalysisPacketHeader.getter(AnalysisPacketHeader::protocol)).setter(AnalysisPacketHeader.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("protocol").build()}).build();
    private static final SdkField<List<String>> SOURCE_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAddresses").getter(AnalysisPacketHeader.getter(AnalysisPacketHeader::sourceAddresses)).setter(AnalysisPacketHeader.setter(Builder::sourceAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddressSet").unmarshallLocationName("sourceAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PortRange>> SOURCE_PORT_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourcePortRanges").getter(AnalysisPacketHeader.getter(AnalysisPacketHeader::sourcePortRanges)).setter(AnalysisPacketHeader.setter(Builder::sourcePortRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRangeSet").unmarshallLocationName("sourcePortRangeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ADDRESSES_FIELD, DESTINATION_PORT_RANGES_FIELD, PROTOCOL_FIELD, SOURCE_ADDRESSES_FIELD, SOURCE_PORT_RANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> destinationAddresses;
    private final List<PortRange> destinationPortRanges;
    private final String protocol;
    private final List<String> sourceAddresses;
    private final List<PortRange> sourcePortRanges;

    private AnalysisPacketHeader(BuilderImpl builder) {
        this.destinationAddresses = builder.destinationAddresses;
        this.destinationPortRanges = builder.destinationPortRanges;
        this.protocol = builder.protocol;
        this.sourceAddresses = builder.sourceAddresses;
        this.sourcePortRanges = builder.sourcePortRanges;
    }

    public final boolean hasDestinationAddresses() {
        return this.destinationAddresses != null && !(this.destinationAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> destinationAddresses() {
        return this.destinationAddresses;
    }

    public final boolean hasDestinationPortRanges() {
        return this.destinationPortRanges != null && !(this.destinationPortRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final boolean hasSourceAddresses() {
        return this.sourceAddresses != null && !(this.sourceAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> sourceAddresses() {
        return this.sourceAddresses;
    }

    public final boolean hasSourcePortRanges() {
        return this.sourcePortRanges != null && !(this.sourcePortRanges instanceof SdkAutoConstructList);
    }

    public final List<PortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationAddresses() ? this.destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationPortRanges() ? this.destinationPortRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAddresses() ? this.sourceAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourcePortRanges() ? this.sourcePortRanges() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisPacketHeader)) {
            return false;
        }
        AnalysisPacketHeader other = (AnalysisPacketHeader)obj;
        return this.hasDestinationAddresses() == other.hasDestinationAddresses() && Objects.equals(this.destinationAddresses(), other.destinationAddresses()) && this.hasDestinationPortRanges() == other.hasDestinationPortRanges() && Objects.equals(this.destinationPortRanges(), other.destinationPortRanges()) && Objects.equals(this.protocol(), other.protocol()) && this.hasSourceAddresses() == other.hasSourceAddresses() && Objects.equals(this.sourceAddresses(), other.sourceAddresses()) && this.hasSourcePortRanges() == other.hasSourcePortRanges() && Objects.equals(this.sourcePortRanges(), other.sourcePortRanges());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisPacketHeader").add("DestinationAddresses", this.hasDestinationAddresses() ? this.destinationAddresses() : null).add("DestinationPortRanges", this.hasDestinationPortRanges() ? this.destinationPortRanges() : null).add("Protocol", (Object)this.protocol()).add("SourceAddresses", this.hasSourceAddresses() ? this.sourceAddresses() : null).add("SourcePortRanges", this.hasSourcePortRanges() ? this.sourcePortRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationAddresses": {
                return Optional.ofNullable(clazz.cast(this.destinationAddresses()));
            }
            case "DestinationPortRanges": {
                return Optional.ofNullable(clazz.cast(this.destinationPortRanges()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "SourceAddresses": {
                return Optional.ofNullable(clazz.cast(this.sourceAddresses()));
            }
            case "SourcePortRanges": {
                return Optional.ofNullable(clazz.cast(this.sourcePortRanges()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisPacketHeader, T> g) {
        return obj -> g.apply((AnalysisPacketHeader)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> destinationPortRanges = DefaultSdkAutoConstructList.getInstance();
        private String protocol;
        private List<String> sourceAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<PortRange> sourcePortRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisPacketHeader model) {
            this.destinationAddresses(model.destinationAddresses);
            this.destinationPortRanges(model.destinationPortRanges);
            this.protocol(model.protocol);
            this.sourceAddresses(model.sourceAddresses);
            this.sourcePortRanges(model.sourcePortRanges);
        }

        public final Collection<String> getDestinationAddresses() {
            if (this.destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationAddresses;
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = IpAddressListCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String ... destinationAddresses) {
            this.destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = IpAddressListCopier.copy(destinationAddresses);
        }

        public final Collection<PortRange.Builder> getDestinationPortRanges() {
            if (this.destinationPortRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.destinationPortRanges != null ? (Collection)this.destinationPortRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationPortRanges(Collection<PortRange> destinationPortRanges) {
            this.destinationPortRanges = PortRangeListCopier.copy(destinationPortRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortRanges(PortRange ... destinationPortRanges) {
            this.destinationPortRanges(Arrays.asList(destinationPortRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortRanges(Consumer<PortRange.Builder> ... destinationPortRanges) {
            this.destinationPortRanges(Stream.of(destinationPortRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationPortRanges(Collection<PortRange.BuilderImpl> destinationPortRanges) {
            this.destinationPortRanges = PortRangeListCopier.copyFromBuilder(destinationPortRanges);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Collection<String> getSourceAddresses() {
            if (this.sourceAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceAddresses;
        }

        @Override
        public final Builder sourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = IpAddressListCopier.copy(sourceAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAddresses(String ... sourceAddresses) {
            this.sourceAddresses(Arrays.asList(sourceAddresses));
            return this;
        }

        public final void setSourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = IpAddressListCopier.copy(sourceAddresses);
        }

        public final Collection<PortRange.Builder> getSourcePortRanges() {
            if (this.sourcePortRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourcePortRanges != null ? (Collection)this.sourcePortRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sourcePortRanges(Collection<PortRange> sourcePortRanges) {
            this.sourcePortRanges = PortRangeListCopier.copy(sourcePortRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePortRanges(PortRange ... sourcePortRanges) {
            this.sourcePortRanges(Arrays.asList(sourcePortRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePortRanges(Consumer<PortRange.Builder> ... sourcePortRanges) {
            this.sourcePortRanges(Stream.of(sourcePortRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourcePortRanges(Collection<PortRange.BuilderImpl> sourcePortRanges) {
            this.sourcePortRanges = PortRangeListCopier.copyFromBuilder(sourcePortRanges);
        }

        public AnalysisPacketHeader build() {
            return new AnalysisPacketHeader(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisPacketHeader> {
        public Builder destinationAddresses(Collection<String> var1);

        public Builder destinationAddresses(String ... var1);

        public Builder destinationPortRanges(Collection<PortRange> var1);

        public Builder destinationPortRanges(PortRange ... var1);

        public Builder destinationPortRanges(Consumer<PortRange.Builder> ... var1);

        public Builder protocol(String var1);

        public Builder sourceAddresses(Collection<String> var1);

        public Builder sourceAddresses(String ... var1);

        public Builder sourcePortRanges(Collection<PortRange> var1);

        public Builder sourcePortRanges(PortRange ... var1);

        public Builder sourcePortRanges(Consumer<PortRange.Builder> ... var1);
    }
}

