/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ClientVpnRoute;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnRoutesResponse;

public class DescribeClientVpnRoutesIterable
implements SdkIterable<DescribeClientVpnRoutesResponse> {
    private final Ec2Client client;
    private final DescribeClientVpnRoutesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientVpnRoutesIterable(Ec2Client client, DescribeClientVpnRoutesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClientVpnRoutesResponseFetcher();
    }

    public Iterator<DescribeClientVpnRoutesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientVpnRoute> routes() {
        Function<DescribeClientVpnRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routes() != null) {
                return response.routes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientVpnRoutesResponseFetcher
    implements SyncPageFetcher<DescribeClientVpnRoutesResponse> {
        private DescribeClientVpnRoutesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientVpnRoutesResponse nextPage(DescribeClientVpnRoutesResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnRoutesIterable.this.client.describeClientVpnRoutes(DescribeClientVpnRoutesIterable.this.firstRequest);
            }
            return DescribeClientVpnRoutesIterable.this.client.describeClientVpnRoutes((DescribeClientVpnRoutesRequest)((Object)DescribeClientVpnRoutesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

