/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoreSuccessItem;
import software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoreSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFastSnapshotRestoresResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFastSnapshotRestoresResponse> {
    private static final SdkField<List<DescribeFastSnapshotRestoreSuccessItem>> FAST_SNAPSHOT_RESTORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FastSnapshotRestores").getter(DescribeFastSnapshotRestoresResponse.getter(DescribeFastSnapshotRestoresResponse::fastSnapshotRestores)).setter(DescribeFastSnapshotRestoresResponse.setter(Builder::fastSnapshotRestores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FastSnapshotRestoreSet").unmarshallLocationName("fastSnapshotRestoreSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DescribeFastSnapshotRestoreSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFastSnapshotRestoresResponse.getter(DescribeFastSnapshotRestoresResponse::nextToken)).setter(DescribeFastSnapshotRestoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAST_SNAPSHOT_RESTORES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores;
    private final String nextToken;

    private DescribeFastSnapshotRestoresResponse(BuilderImpl builder) {
        super(builder);
        this.fastSnapshotRestores = builder.fastSnapshotRestores;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFastSnapshotRestores() {
        return this.fastSnapshotRestores != null && !(this.fastSnapshotRestores instanceof SdkAutoConstructList);
    }

    public final List<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores() {
        return this.fastSnapshotRestores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFastSnapshotRestores() ? this.fastSnapshotRestores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFastSnapshotRestoresResponse)) {
            return false;
        }
        DescribeFastSnapshotRestoresResponse other = (DescribeFastSnapshotRestoresResponse)((Object)obj);
        return this.hasFastSnapshotRestores() == other.hasFastSnapshotRestores() && Objects.equals(this.fastSnapshotRestores(), other.fastSnapshotRestores()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFastSnapshotRestoresResponse").add("FastSnapshotRestores", this.hasFastSnapshotRestores() ? this.fastSnapshotRestores() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FastSnapshotRestores": {
                return Optional.ofNullable(clazz.cast(this.fastSnapshotRestores()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFastSnapshotRestoresResponse, T> g) {
        return obj -> g.apply((DescribeFastSnapshotRestoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFastSnapshotRestoresResponse model) {
            super(model);
            this.fastSnapshotRestores(model.fastSnapshotRestores);
            this.nextToken(model.nextToken);
        }

        public final Collection<DescribeFastSnapshotRestoreSuccessItem.Builder> getFastSnapshotRestores() {
            if (this.fastSnapshotRestores instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fastSnapshotRestores != null ? (Collection)this.fastSnapshotRestores.stream().map(DescribeFastSnapshotRestoreSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fastSnapshotRestores(Collection<DescribeFastSnapshotRestoreSuccessItem> fastSnapshotRestores) {
            this.fastSnapshotRestores = DescribeFastSnapshotRestoreSuccessSetCopier.copy(fastSnapshotRestores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestores(DescribeFastSnapshotRestoreSuccessItem ... fastSnapshotRestores) {
            this.fastSnapshotRestores(Arrays.asList(fastSnapshotRestores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fastSnapshotRestores(Consumer<DescribeFastSnapshotRestoreSuccessItem.Builder> ... fastSnapshotRestores) {
            this.fastSnapshotRestores(Stream.of(fastSnapshotRestores).map(c -> (DescribeFastSnapshotRestoreSuccessItem)((DescribeFastSnapshotRestoreSuccessItem.Builder)DescribeFastSnapshotRestoreSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFastSnapshotRestores(Collection<DescribeFastSnapshotRestoreSuccessItem.BuilderImpl> fastSnapshotRestores) {
            this.fastSnapshotRestores = DescribeFastSnapshotRestoreSuccessSetCopier.copyFromBuilder(fastSnapshotRestores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFastSnapshotRestoresResponse build() {
            return new DescribeFastSnapshotRestoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFastSnapshotRestoresResponse> {
        public Builder fastSnapshotRestores(Collection<DescribeFastSnapshotRestoreSuccessItem> var1);

        public Builder fastSnapshotRestores(DescribeFastSnapshotRestoreSuccessItem ... var1);

        public Builder fastSnapshotRestores(Consumer<DescribeFastSnapshotRestoreSuccessItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

