/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportInstanceStatusRequest extends Ec2Request implements
        ToCopyableBuilder<ReportInstanceStatusRequest.Builder, ReportInstanceStatusRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ReportInstanceStatusRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("description").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime")
            .getter(getter(ReportInstanceStatusRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime")
                    .unmarshallLocationName("endTime").build()).build();

    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(ReportInstanceStatusRequest::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstanceId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstanceId").unmarshallLocationName("InstanceId").build())
                                            .build()).build()).build();

    private static final SdkField<List<String>> REASON_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReasonCodes")
            .getter(getter(ReportInstanceStatusRequest::reasonCodesAsStrings))
            .setter(setter(Builder::reasonCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonCode")
                    .unmarshallLocationName("reasonCode").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime")
            .getter(getter(ReportInstanceStatusRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime")
                    .unmarshallLocationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(ReportInstanceStatusRequest::statusAsString))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            END_TIME_FIELD, INSTANCES_FIELD, REASON_CODES_FIELD, START_TIME_FIELD, STATUS_FIELD));

    private final String description;

    private final Instant endTime;

    private final List<String> instances;

    private final List<String> reasonCodes;

    private final Instant startTime;

    private final String status;

    private ReportInstanceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.endTime = builder.endTime;
        this.instances = builder.instances;
        this.reasonCodes = builder.reasonCodes;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * Descriptive text about the health state of your instance.
     * </p>
     * 
     * @return Descriptive text about the health state of your instance.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the reported instance health state ended.
     * </p>
     * 
     * @return The time at which the reported instance health state ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The instances.
     */
    public final List<String> instances() {
        return instances;
    }

    /**
     * <p>
     * The reason codes that describe the health state of your instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unresponsive</code>: My instance is unresponsive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>password-not-available</code>: A password is not available for my instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
     * related.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
     * related to the instance stores.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are related
     * to an EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-other</code>: My instance is experiencing performance problems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>other</code>: [explain using the description parameter]
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReasonCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The reason codes that describe the health state of your instance.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unresponsive</code>: My instance is unresponsive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>password-not-available</code>: A password is not available for my instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-network</code>: My instance is experiencing performance problems that I believe are
     *         network related.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe
     *         are related to the instance stores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
     *         related to an EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-other</code>: My instance is experiencing performance problems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>other</code>: [explain using the description parameter]
     *         </p>
     *         </li>
     */
    public final List<ReportInstanceReasonCodes> reasonCodes() {
        return ReasonCodesListCopier.copyStringToEnum(reasonCodes);
    }

    /**
     * Returns true if the ReasonCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReasonCodes() {
        return reasonCodes != null && !(reasonCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reason codes that describe the health state of your instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unresponsive</code>: My instance is unresponsive.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>password-not-available</code>: A password is not available for my instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
     * related.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
     * related to the instance stores.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are related
     * to an EBS volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>performance-other</code>: My instance is experiencing performance problems.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>other</code>: [explain using the description parameter]
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReasonCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The reason codes that describe the health state of your instance.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>instance-stuck-in-state</code>: My instance is stuck in a state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unresponsive</code>: My instance is unresponsive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>password-not-available</code>: A password is not available for my instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-network</code>: My instance is experiencing performance problems that I believe are
     *         network related.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe
     *         are related to the instance stores.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
     *         related to an EBS volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>performance-other</code>: My instance is experiencing performance problems.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>other</code>: [explain using the description parameter]
     *         </p>
     *         </li>
     */
    public final List<String> reasonCodesAsStrings() {
        return reasonCodes;
    }

    /**
     * <p>
     * The time at which the reported instance health state began.
     * </p>
     * 
     * @return The time at which the reported instance health state began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The status of all instances listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of all instances listed.
     * @see ReportStatusType
     */
    public final ReportStatusType status() {
        return ReportStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of all instances listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of all instances listed.
     * @see ReportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReasonCodes() ? reasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportInstanceStatusRequest)) {
            return false;
        }
        ReportInstanceStatusRequest other = (ReportInstanceStatusRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(endTime(), other.endTime())
                && hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && hasReasonCodes() == other.hasReasonCodes()
                && Objects.equals(reasonCodesAsStrings(), other.reasonCodesAsStrings())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportInstanceStatusRequest").add("Description", description()).add("EndTime", endTime())
                .add("Instances", hasInstances() ? instances() : null)
                .add("ReasonCodes", hasReasonCodes() ? reasonCodesAsStrings() : null).add("StartTime", startTime())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "ReasonCodes":
            return Optional.ofNullable(clazz.cast(reasonCodesAsStrings()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportInstanceStatusRequest, T> g) {
        return obj -> g.apply((ReportInstanceStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ReportInstanceStatusRequest> {
        /**
         * <p>
         * Descriptive text about the health state of your instance.
         * </p>
         * 
         * @param description
         *        Descriptive text about the health state of your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the reported instance health state ended.
         * </p>
         * 
         * @param endTime
         *        The time at which the reported instance health state ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param instances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param instances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p>
         * The reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        The reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodesWithStrings(Collection<String> reasonCodes);

        /**
         * <p>
         * The reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        The reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodesWithStrings(String... reasonCodes);

        /**
         * <p>
         * The reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        The reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodes(Collection<ReportInstanceReasonCodes> reasonCodes);

        /**
         * <p>
         * The reason codes that describe the health state of your instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unresponsive</code>: My instance is unresponsive.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>password-not-available</code>: A password is not available for my instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-network</code>: My instance is experiencing performance problems that I believe are network
         * related.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-instance-store</code>: My instance is experiencing performance problems that I believe are
         * related to the instance stores.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe are
         * related to an EBS volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>performance-other</code>: My instance is experiencing performance problems.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>other</code>: [explain using the description parameter]
         * </p>
         * </li>
         * </ul>
         * 
         * @param reasonCodes
         *        The reason codes that describe the health state of your instance.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>instance-stuck-in-state</code>: My instance is stuck in a state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unresponsive</code>: My instance is unresponsive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>not-accepting-credentials</code>: My instance is not accepting my credentials.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>password-not-available</code>: A password is not available for my instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-network</code>: My instance is experiencing performance problems that I believe are
         *        network related.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-instance-store</code>: My instance is experiencing performance problems that I
         *        believe are related to the instance stores.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-ebs-volume</code>: My instance is experiencing performance problems that I believe
         *        are related to an EBS volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>performance-other</code>: My instance is experiencing performance problems.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>other</code>: [explain using the description parameter]
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCodes(ReportInstanceReasonCodes... reasonCodes);

        /**
         * <p>
         * The time at which the reported instance health state began.
         * </p>
         * 
         * @param startTime
         *        The time at which the reported instance health state began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of all instances listed.
         * </p>
         * 
         * @param status
         *        The status of all instances listed.
         * @see ReportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportStatusType
         */
        Builder status(ReportStatusType status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String description;

        private Instant endTime;

        private List<String> instances = DefaultSdkAutoConstructList.getInstance();

        private List<String> reasonCodes = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportInstanceStatusRequest model) {
            super(model);
            description(model.description);
            endTime(model.endTime);
            instances(model.instances);
            reasonCodesWithStrings(model.reasonCodes);
            startTime(model.startTime);
            status(model.status);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Collection<String> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances;
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdStringListCopier.copy(instances);
        }

        public final Collection<String> getReasonCodes() {
            if (reasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return reasonCodes;
        }

        @Override
        public final Builder reasonCodesWithStrings(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodesWithStrings(String... reasonCodes) {
            reasonCodesWithStrings(Arrays.asList(reasonCodes));
            return this;
        }

        @Override
        public final Builder reasonCodes(Collection<ReportInstanceReasonCodes> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copyEnumToString(reasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reasonCodes(ReportInstanceReasonCodes... reasonCodes) {
            reasonCodes(Arrays.asList(reasonCodes));
            return this;
        }

        public final void setReasonCodes(Collection<String> reasonCodes) {
            this.reasonCodes = ReasonCodesListCopier.copy(reasonCodes);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReportInstanceStatusRequest build() {
            return new ReportInstanceStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
