/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PricingDetail implements SdkPojo, Serializable, ToCopyableBuilder<PricingDetail.Builder, PricingDetail> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(PricingDetail::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<Double> PRICE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Price")
            .getter(getter(PricingDetail::price))
            .setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price")
                    .unmarshallLocationName("price").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final Double price;

    private PricingDetail(BuilderImpl builder) {
        this.count = builder.count;
        this.price = builder.price;
    }

    /**
     * <p>
     * The number of reservations available for the price.
     * </p>
     * 
     * @return The number of reservations available for the price.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The price per instance.
     * </p>
     * 
     * @return The price per instance.
     */
    public final Double price() {
        return price;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingDetail)) {
            return false;
        }
        PricingDetail other = (PricingDetail) obj;
        return Objects.equals(count(), other.count()) && Objects.equals(price(), other.price());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PricingDetail").add("Count", count()).add("Price", price()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Price":
            return Optional.ofNullable(clazz.cast(price()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PricingDetail, T> g) {
        return obj -> g.apply((PricingDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PricingDetail> {
        /**
         * <p>
         * The number of reservations available for the price.
         * </p>
         * 
         * @param count
         *        The number of reservations available for the price.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The price per instance.
         * </p>
         * 
         * @param price
         *        The price per instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(Double price);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(PricingDetail model) {
            count(model.count);
            price(model.price);
        }

        public final Integer getCount() {
            return count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Double getPrice() {
            return price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        public PricingDetail build() {
            return new PricingDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
