/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Phase2IntegrityAlgorithmsRequestListCopier {
    static List<Phase2IntegrityAlgorithmsRequestListValue> copy(
            Collection<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithmsRequestListParam) {
        if (phase2IntegrityAlgorithmsRequestListParam == null
                || phase2IntegrityAlgorithmsRequestListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<Phase2IntegrityAlgorithmsRequestListValue> phase2IntegrityAlgorithmsRequestListParamCopy = new ArrayList<>(
                phase2IntegrityAlgorithmsRequestListParam);
        return Collections.unmodifiableList(phase2IntegrityAlgorithmsRequestListParamCopy);
    }

    static List<Phase2IntegrityAlgorithmsRequestListValue> copyFromBuilder(
            Collection<? extends Phase2IntegrityAlgorithmsRequestListValue.Builder> phase2IntegrityAlgorithmsRequestListParam) {
        if (phase2IntegrityAlgorithmsRequestListParam == null
                || phase2IntegrityAlgorithmsRequestListParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(phase2IntegrityAlgorithmsRequestListParam.stream()
                .map(Phase2IntegrityAlgorithmsRequestListValue.Builder::build).collect(toList()));
    }
}
