/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the network card support of the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkCardInfo implements SdkPojo, Serializable, ToCopyableBuilder<NetworkCardInfo.Builder, NetworkCardInfo> {
    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex")
            .getter(getter(NetworkCardInfo::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex")
                    .unmarshallLocationName("networkCardIndex").build()).build();

    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkPerformance")
            .getter(getter(NetworkCardInfo::networkPerformance))
            .setter(setter(Builder::networkPerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance")
                    .unmarshallLocationName("networkPerformance").build()).build();

    private static final SdkField<Integer> MAXIMUM_NETWORK_INTERFACES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumNetworkInterfaces")
            .getter(getter(NetworkCardInfo::maximumNetworkInterfaces))
            .setter(setter(Builder::maximumNetworkInterfaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumNetworkInterfaces")
                    .unmarshallLocationName("maximumNetworkInterfaces").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_CARD_INDEX_FIELD,
            NETWORK_PERFORMANCE_FIELD, MAXIMUM_NETWORK_INTERFACES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer networkCardIndex;

    private final String networkPerformance;

    private final Integer maximumNetworkInterfaces;

    private NetworkCardInfo(BuilderImpl builder) {
        this.networkCardIndex = builder.networkCardIndex;
        this.networkPerformance = builder.networkPerformance;
        this.maximumNetworkInterfaces = builder.maximumNetworkInterfaces;
    }

    /**
     * <p>
     * The index of the network card.
     * </p>
     * 
     * @return The index of the network card.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * <p>
     * The network performance of the network card.
     * </p>
     * 
     * @return The network performance of the network card.
     */
    public final String networkPerformance() {
        return networkPerformance;
    }

    /**
     * <p>
     * The maximum number of network interfaces for the network card.
     * </p>
     * 
     * @return The maximum number of network interfaces for the network card.
     */
    public final Integer maximumNetworkInterfaces() {
        return maximumNetworkInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(maximumNetworkInterfaces());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkCardInfo)) {
            return false;
        }
        NetworkCardInfo other = (NetworkCardInfo) obj;
        return Objects.equals(networkCardIndex(), other.networkCardIndex())
                && Objects.equals(networkPerformance(), other.networkPerformance())
                && Objects.equals(maximumNetworkInterfaces(), other.maximumNetworkInterfaces());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkCardInfo").add("NetworkCardIndex", networkCardIndex())
                .add("NetworkPerformance", networkPerformance()).add("MaximumNetworkInterfaces", maximumNetworkInterfaces())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "NetworkPerformance":
            return Optional.ofNullable(clazz.cast(networkPerformance()));
        case "MaximumNetworkInterfaces":
            return Optional.ofNullable(clazz.cast(maximumNetworkInterfaces()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkCardInfo, T> g) {
        return obj -> g.apply((NetworkCardInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkCardInfo> {
        /**
         * <p>
         * The index of the network card.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * The network performance of the network card.
         * </p>
         * 
         * @param networkPerformance
         *        The network performance of the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformance(String networkPerformance);

        /**
         * <p>
         * The maximum number of network interfaces for the network card.
         * </p>
         * 
         * @param maximumNetworkInterfaces
         *        The maximum number of network interfaces for the network card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces);
    }

    static final class BuilderImpl implements Builder {
        private Integer networkCardIndex;

        private String networkPerformance;

        private Integer maximumNetworkInterfaces;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkCardInfo model) {
            networkCardIndex(model.networkCardIndex);
            networkPerformance(model.networkPerformance);
            maximumNetworkInterfaces(model.maximumNetworkInterfaces);
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        public final String getNetworkPerformance() {
            return networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        public final Integer getMaximumNetworkInterfaces() {
            return maximumNetworkInterfaces;
        }

        @Override
        public final Builder maximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
            return this;
        }

        public final void setMaximumNetworkInterfaces(Integer maximumNetworkInterfaces) {
            this.maximumNetworkInterfaces = maximumNetworkInterfaces;
        }

        @Override
        public NetworkCardInfo build() {
            return new NetworkCardInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
