/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instance types offered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceTypeOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceTypeOffering.Builder, InstanceTypeOffering> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(InstanceTypeOffering::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> LOCATION_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocationType")
            .getter(getter(InstanceTypeOffering::locationTypeAsString))
            .setter(setter(Builder::locationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationType")
                    .unmarshallLocationName("locationType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Location")
            .getter(getter(InstanceTypeOffering::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location")
                    .unmarshallLocationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            LOCATION_TYPE_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String locationType;

    private final String location;

    private InstanceTypeOffering(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.locationType = builder.locationType;
        this.location = builder.location;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The location type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type.
     * @see LocationType
     */
    public final LocationType locationType() {
        return LocationType.fromValue(locationType);
    }

    /**
     * <p>
     * The location type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locationType} will
     * return {@link LocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #locationTypeAsString}.
     * </p>
     * 
     * @return The location type.
     * @see LocationType
     */
    public final String locationTypeAsString() {
        return locationType;
    }

    /**
     * <p>
     * The identifier for the location. This depends on the location type. For example, if the location type is
     * <code>region</code>, the location is the Region code (for example, <code>us-east-2</code>.)
     * </p>
     * 
     * @return The identifier for the location. This depends on the location type. For example, if the location type is
     *         <code>region</code>, the location is the Region code (for example, <code>us-east-2</code>.)
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(locationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeOffering)) {
            return false;
        }
        InstanceTypeOffering other = (InstanceTypeOffering) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(locationTypeAsString(), other.locationTypeAsString())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceTypeOffering").add("InstanceType", instanceTypeAsString())
                .add("LocationType", locationTypeAsString()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LocationType":
            return Optional.ofNullable(clazz.cast(locationTypeAsString()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeOffering, T> g) {
        return obj -> g.apply((InstanceTypeOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceTypeOffering> {
        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The location type.
         * </p>
         * 
         * @param locationType
         *        The location type.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(String locationType);

        /**
         * <p>
         * The location type.
         * </p>
         * 
         * @param locationType
         *        The location type.
         * @see LocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocationType
         */
        Builder locationType(LocationType locationType);

        /**
         * <p>
         * The identifier for the location. This depends on the location type. For example, if the location type is
         * <code>region</code>, the location is the Region code (for example, <code>us-east-2</code>.)
         * </p>
         * 
         * @param location
         *        The identifier for the location. This depends on the location type. For example, if the location type
         *        is <code>region</code>, the location is the Region code (for example, <code>us-east-2</code>.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String locationType;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeOffering model) {
            instanceType(model.instanceType);
            locationType(model.locationType);
            location(model.location);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getLocationType() {
            return locationType;
        }

        @Override
        public final Builder locationType(String locationType) {
            this.locationType = locationType;
            return this;
        }

        @Override
        public final Builder locationType(LocationType locationType) {
            this.locationType(locationType == null ? null : locationType.toString());
            return this;
        }

        public final void setLocationType(String locationType) {
            this.locationType = locationType;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public InstanceTypeOffering build() {
            return new InstanceTypeOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
