/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceTypeInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceTypeInfo.Builder, InstanceTypeInfo> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(InstanceTypeInfo::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CurrentGeneration")
            .getter(getter(InstanceTypeInfo::currentGeneration))
            .setter(setter(Builder::currentGeneration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration")
                    .unmarshallLocationName("currentGeneration").build()).build();

    private static final SdkField<Boolean> FREE_TIER_ELIGIBLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FreeTierEligible")
            .getter(getter(InstanceTypeInfo::freeTierEligible))
            .setter(setter(Builder::freeTierEligible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeTierEligible")
                    .unmarshallLocationName("freeTierEligible").build()).build();

    private static final SdkField<List<String>> SUPPORTED_USAGE_CLASSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedUsageClasses")
            .getter(getter(InstanceTypeInfo::supportedUsageClassesAsStrings))
            .setter(setter(Builder::supportedUsageClassesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedUsageClasses")
                    .unmarshallLocationName("supportedUsageClasses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUPPORTED_ROOT_DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedRootDeviceTypes")
            .getter(getter(InstanceTypeInfo::supportedRootDeviceTypesAsStrings))
            .setter(setter(Builder::supportedRootDeviceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedRootDeviceTypes")
                    .unmarshallLocationName("supportedRootDeviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> SUPPORTED_VIRTUALIZATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedVirtualizationTypes")
            .getter(getter(InstanceTypeInfo::supportedVirtualizationTypesAsStrings))
            .setter(setter(Builder::supportedVirtualizationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedVirtualizationTypes")
                    .unmarshallLocationName("supportedVirtualizationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Boolean> BARE_METAL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BareMetal")
            .getter(getter(InstanceTypeInfo::bareMetal))
            .setter(setter(Builder::bareMetal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BareMetal")
                    .unmarshallLocationName("bareMetal").build()).build();

    private static final SdkField<String> HYPERVISOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Hypervisor")
            .getter(getter(InstanceTypeInfo::hypervisorAsString))
            .setter(setter(Builder::hypervisor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor")
                    .unmarshallLocationName("hypervisor").build()).build();

    private static final SdkField<ProcessorInfo> PROCESSOR_INFO_FIELD = SdkField
            .<ProcessorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ProcessorInfo")
            .getter(getter(InstanceTypeInfo::processorInfo))
            .setter(setter(Builder::processorInfo))
            .constructor(ProcessorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorInfo")
                    .unmarshallLocationName("processorInfo").build()).build();

    private static final SdkField<VCpuInfo> V_CPU_INFO_FIELD = SdkField
            .<VCpuInfo> builder(MarshallingType.SDK_POJO)
            .memberName("VCpuInfo")
            .getter(getter(InstanceTypeInfo::vCpuInfo))
            .setter(setter(Builder::vCpuInfo))
            .constructor(VCpuInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpuInfo")
                    .unmarshallLocationName("vCpuInfo").build()).build();

    private static final SdkField<MemoryInfo> MEMORY_INFO_FIELD = SdkField
            .<MemoryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("MemoryInfo")
            .getter(getter(InstanceTypeInfo::memoryInfo))
            .setter(setter(Builder::memoryInfo))
            .constructor(MemoryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo")
                    .unmarshallLocationName("memoryInfo").build()).build();

    private static final SdkField<Boolean> INSTANCE_STORAGE_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InstanceStorageSupported")
            .getter(getter(InstanceTypeInfo::instanceStorageSupported))
            .setter(setter(Builder::instanceStorageSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageSupported")
                    .unmarshallLocationName("instanceStorageSupported").build()).build();

    private static final SdkField<InstanceStorageInfo> INSTANCE_STORAGE_INFO_FIELD = SdkField
            .<InstanceStorageInfo> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceStorageInfo")
            .getter(getter(InstanceTypeInfo::instanceStorageInfo))
            .setter(setter(Builder::instanceStorageInfo))
            .constructor(InstanceStorageInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageInfo")
                    .unmarshallLocationName("instanceStorageInfo").build()).build();

    private static final SdkField<EbsInfo> EBS_INFO_FIELD = SdkField
            .<EbsInfo> builder(MarshallingType.SDK_POJO)
            .memberName("EbsInfo")
            .getter(getter(InstanceTypeInfo::ebsInfo))
            .setter(setter(Builder::ebsInfo))
            .constructor(EbsInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsInfo")
                    .unmarshallLocationName("ebsInfo").build()).build();

    private static final SdkField<NetworkInfo> NETWORK_INFO_FIELD = SdkField
            .<NetworkInfo> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInfo")
            .getter(getter(InstanceTypeInfo::networkInfo))
            .setter(setter(Builder::networkInfo))
            .constructor(NetworkInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInfo")
                    .unmarshallLocationName("networkInfo").build()).build();

    private static final SdkField<GpuInfo> GPU_INFO_FIELD = SdkField
            .<GpuInfo> builder(MarshallingType.SDK_POJO)
            .memberName("GpuInfo")
            .getter(getter(InstanceTypeInfo::gpuInfo))
            .setter(setter(Builder::gpuInfo))
            .constructor(GpuInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GpuInfo")
                    .unmarshallLocationName("gpuInfo").build()).build();

    private static final SdkField<FpgaInfo> FPGA_INFO_FIELD = SdkField
            .<FpgaInfo> builder(MarshallingType.SDK_POJO)
            .memberName("FpgaInfo")
            .getter(getter(InstanceTypeInfo::fpgaInfo))
            .setter(setter(Builder::fpgaInfo))
            .constructor(FpgaInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaInfo")
                    .unmarshallLocationName("fpgaInfo").build()).build();

    private static final SdkField<PlacementGroupInfo> PLACEMENT_GROUP_INFO_FIELD = SdkField
            .<PlacementGroupInfo> builder(MarshallingType.SDK_POJO)
            .memberName("PlacementGroupInfo")
            .getter(getter(InstanceTypeInfo::placementGroupInfo))
            .setter(setter(Builder::placementGroupInfo))
            .constructor(PlacementGroupInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupInfo")
                    .unmarshallLocationName("placementGroupInfo").build()).build();

    private static final SdkField<InferenceAcceleratorInfo> INFERENCE_ACCELERATOR_INFO_FIELD = SdkField
            .<InferenceAcceleratorInfo> builder(MarshallingType.SDK_POJO)
            .memberName("InferenceAcceleratorInfo")
            .getter(getter(InstanceTypeInfo::inferenceAcceleratorInfo))
            .setter(setter(Builder::inferenceAcceleratorInfo))
            .constructor(InferenceAcceleratorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAcceleratorInfo")
                    .unmarshallLocationName("inferenceAcceleratorInfo").build()).build();

    private static final SdkField<Boolean> HIBERNATION_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HibernationSupported")
            .getter(getter(InstanceTypeInfo::hibernationSupported))
            .setter(setter(Builder::hibernationSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationSupported")
                    .unmarshallLocationName("hibernationSupported").build()).build();

    private static final SdkField<Boolean> BURSTABLE_PERFORMANCE_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BurstablePerformanceSupported")
            .getter(getter(InstanceTypeInfo::burstablePerformanceSupported))
            .setter(setter(Builder::burstablePerformanceSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurstablePerformanceSupported")
                    .unmarshallLocationName("burstablePerformanceSupported").build()).build();

    private static final SdkField<Boolean> DEDICATED_HOSTS_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedHostsSupported")
            .getter(getter(InstanceTypeInfo::dedicatedHostsSupported))
            .setter(setter(Builder::dedicatedHostsSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedHostsSupported")
                    .unmarshallLocationName("dedicatedHostsSupported").build()).build();

    private static final SdkField<Boolean> AUTO_RECOVERY_SUPPORTED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoRecoverySupported")
            .getter(getter(InstanceTypeInfo::autoRecoverySupported))
            .setter(setter(Builder::autoRecoverySupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecoverySupported")
                    .unmarshallLocationName("autoRecoverySupported").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            CURRENT_GENERATION_FIELD, FREE_TIER_ELIGIBLE_FIELD, SUPPORTED_USAGE_CLASSES_FIELD, SUPPORTED_ROOT_DEVICE_TYPES_FIELD,
            SUPPORTED_VIRTUALIZATION_TYPES_FIELD, BARE_METAL_FIELD, HYPERVISOR_FIELD, PROCESSOR_INFO_FIELD, V_CPU_INFO_FIELD,
            MEMORY_INFO_FIELD, INSTANCE_STORAGE_SUPPORTED_FIELD, INSTANCE_STORAGE_INFO_FIELD, EBS_INFO_FIELD, NETWORK_INFO_FIELD,
            GPU_INFO_FIELD, FPGA_INFO_FIELD, PLACEMENT_GROUP_INFO_FIELD, INFERENCE_ACCELERATOR_INFO_FIELD,
            HIBERNATION_SUPPORTED_FIELD, BURSTABLE_PERFORMANCE_SUPPORTED_FIELD, DEDICATED_HOSTS_SUPPORTED_FIELD,
            AUTO_RECOVERY_SUPPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Boolean currentGeneration;

    private final Boolean freeTierEligible;

    private final List<String> supportedUsageClasses;

    private final List<String> supportedRootDeviceTypes;

    private final List<String> supportedVirtualizationTypes;

    private final Boolean bareMetal;

    private final String hypervisor;

    private final ProcessorInfo processorInfo;

    private final VCpuInfo vCpuInfo;

    private final MemoryInfo memoryInfo;

    private final Boolean instanceStorageSupported;

    private final InstanceStorageInfo instanceStorageInfo;

    private final EbsInfo ebsInfo;

    private final NetworkInfo networkInfo;

    private final GpuInfo gpuInfo;

    private final FpgaInfo fpgaInfo;

    private final PlacementGroupInfo placementGroupInfo;

    private final InferenceAcceleratorInfo inferenceAcceleratorInfo;

    private final Boolean hibernationSupported;

    private final Boolean burstablePerformanceSupported;

    private final Boolean dedicatedHostsSupported;

    private final Boolean autoRecoverySupported;

    private InstanceTypeInfo(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.currentGeneration = builder.currentGeneration;
        this.freeTierEligible = builder.freeTierEligible;
        this.supportedUsageClasses = builder.supportedUsageClasses;
        this.supportedRootDeviceTypes = builder.supportedRootDeviceTypes;
        this.supportedVirtualizationTypes = builder.supportedVirtualizationTypes;
        this.bareMetal = builder.bareMetal;
        this.hypervisor = builder.hypervisor;
        this.processorInfo = builder.processorInfo;
        this.vCpuInfo = builder.vCpuInfo;
        this.memoryInfo = builder.memoryInfo;
        this.instanceStorageSupported = builder.instanceStorageSupported;
        this.instanceStorageInfo = builder.instanceStorageInfo;
        this.ebsInfo = builder.ebsInfo;
        this.networkInfo = builder.networkInfo;
        this.gpuInfo = builder.gpuInfo;
        this.fpgaInfo = builder.fpgaInfo;
        this.placementGroupInfo = builder.placementGroupInfo;
        this.inferenceAcceleratorInfo = builder.inferenceAcceleratorInfo;
        this.hibernationSupported = builder.hibernationSupported;
        this.burstablePerformanceSupported = builder.burstablePerformanceSupported;
        this.dedicatedHostsSupported = builder.dedicatedHostsSupported;
        this.autoRecoverySupported = builder.autoRecoverySupported;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates whether the instance type is current generation.
     * </p>
     * 
     * @return Indicates whether the instance type is current generation.
     */
    public final Boolean currentGeneration() {
        return currentGeneration;
    }

    /**
     * <p>
     * Indicates whether the instance type is eligible for the free tier.
     * </p>
     * 
     * @return Indicates whether the instance type is eligible for the free tier.
     */
    public final Boolean freeTierEligible() {
        return freeTierEligible;
    }

    /**
     * <p>
     * Indicates whether the instance type is offered for spot or On-Demand.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedUsageClasses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates whether the instance type is offered for spot or On-Demand.
     */
    public final List<UsageClassType> supportedUsageClasses() {
        return UsageClassTypeListCopier.copyStringToEnum(supportedUsageClasses);
    }

    /**
     * Returns true if the SupportedUsageClasses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedUsageClasses() {
        return supportedUsageClasses != null && !(supportedUsageClasses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether the instance type is offered for spot or On-Demand.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedUsageClasses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates whether the instance type is offered for spot or On-Demand.
     */
    public final List<String> supportedUsageClassesAsStrings() {
        return supportedUsageClasses;
    }

    /**
     * <p>
     * The supported root device types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedRootDeviceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported root device types.
     */
    public final List<RootDeviceType> supportedRootDeviceTypes() {
        return RootDeviceTypeListCopier.copyStringToEnum(supportedRootDeviceTypes);
    }

    /**
     * Returns true if the SupportedRootDeviceTypes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSupportedRootDeviceTypes() {
        return supportedRootDeviceTypes != null && !(supportedRootDeviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported root device types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedRootDeviceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported root device types.
     */
    public final List<String> supportedRootDeviceTypesAsStrings() {
        return supportedRootDeviceTypes;
    }

    /**
     * <p>
     * The supported virtualization types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedVirtualizationTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported virtualization types.
     */
    public final List<VirtualizationType> supportedVirtualizationTypes() {
        return VirtualizationTypeListCopier.copyStringToEnum(supportedVirtualizationTypes);
    }

    /**
     * Returns true if the SupportedVirtualizationTypes property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasSupportedVirtualizationTypes() {
        return supportedVirtualizationTypes != null && !(supportedVirtualizationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported virtualization types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSupportedVirtualizationTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The supported virtualization types.
     */
    public final List<String> supportedVirtualizationTypesAsStrings() {
        return supportedVirtualizationTypes;
    }

    /**
     * <p>
     * Indicates whether the instance is a bare metal instance type.
     * </p>
     * 
     * @return Indicates whether the instance is a bare metal instance type.
     */
    public final Boolean bareMetal() {
        return bareMetal;
    }

    /**
     * <p>
     * The hypervisor for the instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link InstanceTypeHypervisor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor for the instance type.
     * @see InstanceTypeHypervisor
     */
    public final InstanceTypeHypervisor hypervisor() {
        return InstanceTypeHypervisor.fromValue(hypervisor);
    }

    /**
     * <p>
     * The hypervisor for the instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hypervisor} will
     * return {@link InstanceTypeHypervisor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hypervisorAsString}.
     * </p>
     * 
     * @return The hypervisor for the instance type.
     * @see InstanceTypeHypervisor
     */
    public final String hypervisorAsString() {
        return hypervisor;
    }

    /**
     * <p>
     * Describes the processor.
     * </p>
     * 
     * @return Describes the processor.
     */
    public final ProcessorInfo processorInfo() {
        return processorInfo;
    }

    /**
     * <p>
     * Describes the vCPU configurations for the instance type.
     * </p>
     * 
     * @return Describes the vCPU configurations for the instance type.
     */
    public final VCpuInfo vCpuInfo() {
        return vCpuInfo;
    }

    /**
     * <p>
     * Describes the memory for the instance type.
     * </p>
     * 
     * @return Describes the memory for the instance type.
     */
    public final MemoryInfo memoryInfo() {
        return memoryInfo;
    }

    /**
     * <p>
     * Indicates whether instance storage is supported.
     * </p>
     * 
     * @return Indicates whether instance storage is supported.
     */
    public final Boolean instanceStorageSupported() {
        return instanceStorageSupported;
    }

    /**
     * <p>
     * Describes the instance storage for the instance type.
     * </p>
     * 
     * @return Describes the instance storage for the instance type.
     */
    public final InstanceStorageInfo instanceStorageInfo() {
        return instanceStorageInfo;
    }

    /**
     * <p>
     * Describes the Amazon EBS settings for the instance type.
     * </p>
     * 
     * @return Describes the Amazon EBS settings for the instance type.
     */
    public final EbsInfo ebsInfo() {
        return ebsInfo;
    }

    /**
     * <p>
     * Describes the network settings for the instance type.
     * </p>
     * 
     * @return Describes the network settings for the instance type.
     */
    public final NetworkInfo networkInfo() {
        return networkInfo;
    }

    /**
     * <p>
     * Describes the GPU accelerator settings for the instance type.
     * </p>
     * 
     * @return Describes the GPU accelerator settings for the instance type.
     */
    public final GpuInfo gpuInfo() {
        return gpuInfo;
    }

    /**
     * <p>
     * Describes the FPGA accelerator settings for the instance type.
     * </p>
     * 
     * @return Describes the FPGA accelerator settings for the instance type.
     */
    public final FpgaInfo fpgaInfo() {
        return fpgaInfo;
    }

    /**
     * <p>
     * Describes the placement group settings for the instance type.
     * </p>
     * 
     * @return Describes the placement group settings for the instance type.
     */
    public final PlacementGroupInfo placementGroupInfo() {
        return placementGroupInfo;
    }

    /**
     * <p>
     * Describes the Inference accelerator settings for the instance type.
     * </p>
     * 
     * @return Describes the Inference accelerator settings for the instance type.
     */
    public final InferenceAcceleratorInfo inferenceAcceleratorInfo() {
        return inferenceAcceleratorInfo;
    }

    /**
     * <p>
     * Indicates whether On-Demand hibernation is supported.
     * </p>
     * 
     * @return Indicates whether On-Demand hibernation is supported.
     */
    public final Boolean hibernationSupported() {
        return hibernationSupported;
    }

    /**
     * <p>
     * Indicates whether the instance type is a burstable performance instance type.
     * </p>
     * 
     * @return Indicates whether the instance type is a burstable performance instance type.
     */
    public final Boolean burstablePerformanceSupported() {
        return burstablePerformanceSupported;
    }

    /**
     * <p>
     * Indicates whether Dedicated Hosts are supported on the instance type.
     * </p>
     * 
     * @return Indicates whether Dedicated Hosts are supported on the instance type.
     */
    public final Boolean dedicatedHostsSupported() {
        return dedicatedHostsSupported;
    }

    /**
     * <p>
     * Indicates whether auto recovery is supported.
     * </p>
     * 
     * @return Indicates whether auto recovery is supported.
     */
    public final Boolean autoRecoverySupported() {
        return autoRecoverySupported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(freeTierEligible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedUsageClasses() ? supportedUsageClassesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedRootDeviceTypes() ? supportedRootDeviceTypesAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasSupportedVirtualizationTypes() ? supportedVirtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bareMetal());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(processorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(vCpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStorageSupported());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStorageInfo());
        hashCode = 31 * hashCode + Objects.hashCode(ebsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(networkInfo());
        hashCode = 31 * hashCode + Objects.hashCode(gpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(fpgaInfo());
        hashCode = 31 * hashCode + Objects.hashCode(placementGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceAcceleratorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationSupported());
        hashCode = 31 * hashCode + Objects.hashCode(burstablePerformanceSupported());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedHostsSupported());
        hashCode = 31 * hashCode + Objects.hashCode(autoRecoverySupported());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeInfo)) {
            return false;
        }
        InstanceTypeInfo other = (InstanceTypeInfo) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(currentGeneration(), other.currentGeneration())
                && Objects.equals(freeTierEligible(), other.freeTierEligible())
                && hasSupportedUsageClasses() == other.hasSupportedUsageClasses()
                && Objects.equals(supportedUsageClassesAsStrings(), other.supportedUsageClassesAsStrings())
                && hasSupportedRootDeviceTypes() == other.hasSupportedRootDeviceTypes()
                && Objects.equals(supportedRootDeviceTypesAsStrings(), other.supportedRootDeviceTypesAsStrings())
                && hasSupportedVirtualizationTypes() == other.hasSupportedVirtualizationTypes()
                && Objects.equals(supportedVirtualizationTypesAsStrings(), other.supportedVirtualizationTypesAsStrings())
                && Objects.equals(bareMetal(), other.bareMetal())
                && Objects.equals(hypervisorAsString(), other.hypervisorAsString())
                && Objects.equals(processorInfo(), other.processorInfo()) && Objects.equals(vCpuInfo(), other.vCpuInfo())
                && Objects.equals(memoryInfo(), other.memoryInfo())
                && Objects.equals(instanceStorageSupported(), other.instanceStorageSupported())
                && Objects.equals(instanceStorageInfo(), other.instanceStorageInfo())
                && Objects.equals(ebsInfo(), other.ebsInfo()) && Objects.equals(networkInfo(), other.networkInfo())
                && Objects.equals(gpuInfo(), other.gpuInfo()) && Objects.equals(fpgaInfo(), other.fpgaInfo())
                && Objects.equals(placementGroupInfo(), other.placementGroupInfo())
                && Objects.equals(inferenceAcceleratorInfo(), other.inferenceAcceleratorInfo())
                && Objects.equals(hibernationSupported(), other.hibernationSupported())
                && Objects.equals(burstablePerformanceSupported(), other.burstablePerformanceSupported())
                && Objects.equals(dedicatedHostsSupported(), other.dedicatedHostsSupported())
                && Objects.equals(autoRecoverySupported(), other.autoRecoverySupported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("InstanceTypeInfo")
                .add("InstanceType", instanceTypeAsString())
                .add("CurrentGeneration", currentGeneration())
                .add("FreeTierEligible", freeTierEligible())
                .add("SupportedUsageClasses", hasSupportedUsageClasses() ? supportedUsageClassesAsStrings() : null)
                .add("SupportedRootDeviceTypes", hasSupportedRootDeviceTypes() ? supportedRootDeviceTypesAsStrings() : null)
                .add("SupportedVirtualizationTypes",
                        hasSupportedVirtualizationTypes() ? supportedVirtualizationTypesAsStrings() : null)
                .add("BareMetal", bareMetal()).add("Hypervisor", hypervisorAsString()).add("ProcessorInfo", processorInfo())
                .add("VCpuInfo", vCpuInfo()).add("MemoryInfo", memoryInfo())
                .add("InstanceStorageSupported", instanceStorageSupported()).add("InstanceStorageInfo", instanceStorageInfo())
                .add("EbsInfo", ebsInfo()).add("NetworkInfo", networkInfo()).add("GpuInfo", gpuInfo())
                .add("FpgaInfo", fpgaInfo()).add("PlacementGroupInfo", placementGroupInfo())
                .add("InferenceAcceleratorInfo", inferenceAcceleratorInfo()).add("HibernationSupported", hibernationSupported())
                .add("BurstablePerformanceSupported", burstablePerformanceSupported())
                .add("DedicatedHostsSupported", dedicatedHostsSupported()).add("AutoRecoverySupported", autoRecoverySupported())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "CurrentGeneration":
            return Optional.ofNullable(clazz.cast(currentGeneration()));
        case "FreeTierEligible":
            return Optional.ofNullable(clazz.cast(freeTierEligible()));
        case "SupportedUsageClasses":
            return Optional.ofNullable(clazz.cast(supportedUsageClassesAsStrings()));
        case "SupportedRootDeviceTypes":
            return Optional.ofNullable(clazz.cast(supportedRootDeviceTypesAsStrings()));
        case "SupportedVirtualizationTypes":
            return Optional.ofNullable(clazz.cast(supportedVirtualizationTypesAsStrings()));
        case "BareMetal":
            return Optional.ofNullable(clazz.cast(bareMetal()));
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisorAsString()));
        case "ProcessorInfo":
            return Optional.ofNullable(clazz.cast(processorInfo()));
        case "VCpuInfo":
            return Optional.ofNullable(clazz.cast(vCpuInfo()));
        case "MemoryInfo":
            return Optional.ofNullable(clazz.cast(memoryInfo()));
        case "InstanceStorageSupported":
            return Optional.ofNullable(clazz.cast(instanceStorageSupported()));
        case "InstanceStorageInfo":
            return Optional.ofNullable(clazz.cast(instanceStorageInfo()));
        case "EbsInfo":
            return Optional.ofNullable(clazz.cast(ebsInfo()));
        case "NetworkInfo":
            return Optional.ofNullable(clazz.cast(networkInfo()));
        case "GpuInfo":
            return Optional.ofNullable(clazz.cast(gpuInfo()));
        case "FpgaInfo":
            return Optional.ofNullable(clazz.cast(fpgaInfo()));
        case "PlacementGroupInfo":
            return Optional.ofNullable(clazz.cast(placementGroupInfo()));
        case "InferenceAcceleratorInfo":
            return Optional.ofNullable(clazz.cast(inferenceAcceleratorInfo()));
        case "HibernationSupported":
            return Optional.ofNullable(clazz.cast(hibernationSupported()));
        case "BurstablePerformanceSupported":
            return Optional.ofNullable(clazz.cast(burstablePerformanceSupported()));
        case "DedicatedHostsSupported":
            return Optional.ofNullable(clazz.cast(dedicatedHostsSupported()));
        case "AutoRecoverySupported":
            return Optional.ofNullable(clazz.cast(autoRecoverySupported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeInfo, T> g) {
        return obj -> g.apply((InstanceTypeInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceTypeInfo> {
        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * Indicates whether the instance type is current generation.
         * </p>
         * 
         * @param currentGeneration
         *        Indicates whether the instance type is current generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentGeneration(Boolean currentGeneration);

        /**
         * <p>
         * Indicates whether the instance type is eligible for the free tier.
         * </p>
         * 
         * @param freeTierEligible
         *        Indicates whether the instance type is eligible for the free tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTierEligible(Boolean freeTierEligible);

        /**
         * <p>
         * Indicates whether the instance type is offered for spot or On-Demand.
         * </p>
         * 
         * @param supportedUsageClasses
         *        Indicates whether the instance type is offered for spot or On-Demand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUsageClassesWithStrings(Collection<String> supportedUsageClasses);

        /**
         * <p>
         * Indicates whether the instance type is offered for spot or On-Demand.
         * </p>
         * 
         * @param supportedUsageClasses
         *        Indicates whether the instance type is offered for spot or On-Demand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUsageClassesWithStrings(String... supportedUsageClasses);

        /**
         * <p>
         * Indicates whether the instance type is offered for spot or On-Demand.
         * </p>
         * 
         * @param supportedUsageClasses
         *        Indicates whether the instance type is offered for spot or On-Demand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUsageClasses(Collection<UsageClassType> supportedUsageClasses);

        /**
         * <p>
         * Indicates whether the instance type is offered for spot or On-Demand.
         * </p>
         * 
         * @param supportedUsageClasses
         *        Indicates whether the instance type is offered for spot or On-Demand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUsageClasses(UsageClassType... supportedUsageClasses);

        /**
         * <p>
         * The supported root device types.
         * </p>
         * 
         * @param supportedRootDeviceTypes
         *        The supported root device types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRootDeviceTypesWithStrings(Collection<String> supportedRootDeviceTypes);

        /**
         * <p>
         * The supported root device types.
         * </p>
         * 
         * @param supportedRootDeviceTypes
         *        The supported root device types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRootDeviceTypesWithStrings(String... supportedRootDeviceTypes);

        /**
         * <p>
         * The supported root device types.
         * </p>
         * 
         * @param supportedRootDeviceTypes
         *        The supported root device types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRootDeviceTypes(Collection<RootDeviceType> supportedRootDeviceTypes);

        /**
         * <p>
         * The supported root device types.
         * </p>
         * 
         * @param supportedRootDeviceTypes
         *        The supported root device types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedRootDeviceTypes(RootDeviceType... supportedRootDeviceTypes);

        /**
         * <p>
         * The supported virtualization types.
         * </p>
         * 
         * @param supportedVirtualizationTypes
         *        The supported virtualization types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedVirtualizationTypesWithStrings(Collection<String> supportedVirtualizationTypes);

        /**
         * <p>
         * The supported virtualization types.
         * </p>
         * 
         * @param supportedVirtualizationTypes
         *        The supported virtualization types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedVirtualizationTypesWithStrings(String... supportedVirtualizationTypes);

        /**
         * <p>
         * The supported virtualization types.
         * </p>
         * 
         * @param supportedVirtualizationTypes
         *        The supported virtualization types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedVirtualizationTypes(Collection<VirtualizationType> supportedVirtualizationTypes);

        /**
         * <p>
         * The supported virtualization types.
         * </p>
         * 
         * @param supportedVirtualizationTypes
         *        The supported virtualization types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedVirtualizationTypes(VirtualizationType... supportedVirtualizationTypes);

        /**
         * <p>
         * Indicates whether the instance is a bare metal instance type.
         * </p>
         * 
         * @param bareMetal
         *        Indicates whether the instance is a bare metal instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bareMetal(Boolean bareMetal);

        /**
         * <p>
         * The hypervisor for the instance type.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor for the instance type.
         * @see InstanceTypeHypervisor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceTypeHypervisor
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The hypervisor for the instance type.
         * </p>
         * 
         * @param hypervisor
         *        The hypervisor for the instance type.
         * @see InstanceTypeHypervisor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceTypeHypervisor
         */
        Builder hypervisor(InstanceTypeHypervisor hypervisor);

        /**
         * <p>
         * Describes the processor.
         * </p>
         * 
         * @param processorInfo
         *        Describes the processor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorInfo(ProcessorInfo processorInfo);

        /**
         * <p>
         * Describes the processor.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessorInfo.Builder} avoiding the need to
         * create one manually via {@link ProcessorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessorInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #processorInfo(ProcessorInfo)}.
         * 
         * @param processorInfo
         *        a consumer that will call methods on {@link ProcessorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorInfo(ProcessorInfo)
         */
        default Builder processorInfo(Consumer<ProcessorInfo.Builder> processorInfo) {
            return processorInfo(ProcessorInfo.builder().applyMutation(processorInfo).build());
        }

        /**
         * <p>
         * Describes the vCPU configurations for the instance type.
         * </p>
         * 
         * @param vCpuInfo
         *        Describes the vCPU configurations for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpuInfo(VCpuInfo vCpuInfo);

        /**
         * <p>
         * Describes the vCPU configurations for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link VCpuInfo.Builder} avoiding the need to create
         * one manually via {@link VCpuInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VCpuInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #vCpuInfo(VCpuInfo)}.
         * 
         * @param vCpuInfo
         *        a consumer that will call methods on {@link VCpuInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vCpuInfo(VCpuInfo)
         */
        default Builder vCpuInfo(Consumer<VCpuInfo.Builder> vCpuInfo) {
            return vCpuInfo(VCpuInfo.builder().applyMutation(vCpuInfo).build());
        }

        /**
         * <p>
         * Describes the memory for the instance type.
         * </p>
         * 
         * @param memoryInfo
         *        Describes the memory for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInfo(MemoryInfo memoryInfo);

        /**
         * <p>
         * Describes the memory for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link MemoryInfo.Builder} avoiding the need to create
         * one manually via {@link MemoryInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemoryInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #memoryInfo(MemoryInfo)}.
         * 
         * @param memoryInfo
         *        a consumer that will call methods on {@link MemoryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryInfo(MemoryInfo)
         */
        default Builder memoryInfo(Consumer<MemoryInfo.Builder> memoryInfo) {
            return memoryInfo(MemoryInfo.builder().applyMutation(memoryInfo).build());
        }

        /**
         * <p>
         * Indicates whether instance storage is supported.
         * </p>
         * 
         * @param instanceStorageSupported
         *        Indicates whether instance storage is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStorageSupported(Boolean instanceStorageSupported);

        /**
         * <p>
         * Describes the instance storage for the instance type.
         * </p>
         * 
         * @param instanceStorageInfo
         *        Describes the instance storage for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStorageInfo(InstanceStorageInfo instanceStorageInfo);

        /**
         * <p>
         * Describes the instance storage for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceStorageInfo.Builder} avoiding the need
         * to create one manually via {@link InstanceStorageInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStorageInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceStorageInfo(InstanceStorageInfo)}.
         * 
         * @param instanceStorageInfo
         *        a consumer that will call methods on {@link InstanceStorageInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStorageInfo(InstanceStorageInfo)
         */
        default Builder instanceStorageInfo(Consumer<InstanceStorageInfo.Builder> instanceStorageInfo) {
            return instanceStorageInfo(InstanceStorageInfo.builder().applyMutation(instanceStorageInfo).build());
        }

        /**
         * <p>
         * Describes the Amazon EBS settings for the instance type.
         * </p>
         * 
         * @param ebsInfo
         *        Describes the Amazon EBS settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsInfo(EbsInfo ebsInfo);

        /**
         * <p>
         * Describes the Amazon EBS settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsInfo.Builder} avoiding the need to create one
         * manually via {@link EbsInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #ebsInfo(EbsInfo)}.
         * 
         * @param ebsInfo
         *        a consumer that will call methods on {@link EbsInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsInfo(EbsInfo)
         */
        default Builder ebsInfo(Consumer<EbsInfo.Builder> ebsInfo) {
            return ebsInfo(EbsInfo.builder().applyMutation(ebsInfo).build());
        }

        /**
         * <p>
         * Describes the network settings for the instance type.
         * </p>
         * 
         * @param networkInfo
         *        Describes the network settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInfo(NetworkInfo networkInfo);

        /**
         * <p>
         * Describes the network settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInfo.Builder} avoiding the need to create
         * one manually via {@link NetworkInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #networkInfo(NetworkInfo)}.
         * 
         * @param networkInfo
         *        a consumer that will call methods on {@link NetworkInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInfo(NetworkInfo)
         */
        default Builder networkInfo(Consumer<NetworkInfo.Builder> networkInfo) {
            return networkInfo(NetworkInfo.builder().applyMutation(networkInfo).build());
        }

        /**
         * <p>
         * Describes the GPU accelerator settings for the instance type.
         * </p>
         * 
         * @param gpuInfo
         *        Describes the GPU accelerator settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gpuInfo(GpuInfo gpuInfo);

        /**
         * <p>
         * Describes the GPU accelerator settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link GpuInfo.Builder} avoiding the need to create one
         * manually via {@link GpuInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link GpuInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #gpuInfo(GpuInfo)}.
         * 
         * @param gpuInfo
         *        a consumer that will call methods on {@link GpuInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gpuInfo(GpuInfo)
         */
        default Builder gpuInfo(Consumer<GpuInfo.Builder> gpuInfo) {
            return gpuInfo(GpuInfo.builder().applyMutation(gpuInfo).build());
        }

        /**
         * <p>
         * Describes the FPGA accelerator settings for the instance type.
         * </p>
         * 
         * @param fpgaInfo
         *        Describes the FPGA accelerator settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaInfo(FpgaInfo fpgaInfo);

        /**
         * <p>
         * Describes the FPGA accelerator settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link FpgaInfo.Builder} avoiding the need to create
         * one manually via {@link FpgaInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link FpgaInfo.Builder#build()} is called immediately and its result is
         * passed to {@link #fpgaInfo(FpgaInfo)}.
         * 
         * @param fpgaInfo
         *        a consumer that will call methods on {@link FpgaInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fpgaInfo(FpgaInfo)
         */
        default Builder fpgaInfo(Consumer<FpgaInfo.Builder> fpgaInfo) {
            return fpgaInfo(FpgaInfo.builder().applyMutation(fpgaInfo).build());
        }

        /**
         * <p>
         * Describes the placement group settings for the instance type.
         * </p>
         * 
         * @param placementGroupInfo
         *        Describes the placement group settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroupInfo(PlacementGroupInfo placementGroupInfo);

        /**
         * <p>
         * Describes the placement group settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link PlacementGroupInfo.Builder} avoiding the need to
         * create one manually via {@link PlacementGroupInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementGroupInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #placementGroupInfo(PlacementGroupInfo)}.
         * 
         * @param placementGroupInfo
         *        a consumer that will call methods on {@link PlacementGroupInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementGroupInfo(PlacementGroupInfo)
         */
        default Builder placementGroupInfo(Consumer<PlacementGroupInfo.Builder> placementGroupInfo) {
            return placementGroupInfo(PlacementGroupInfo.builder().applyMutation(placementGroupInfo).build());
        }

        /**
         * <p>
         * Describes the Inference accelerator settings for the instance type.
         * </p>
         * 
         * @param inferenceAcceleratorInfo
         *        Describes the Inference accelerator settings for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceAcceleratorInfo(InferenceAcceleratorInfo inferenceAcceleratorInfo);

        /**
         * <p>
         * Describes the Inference accelerator settings for the instance type.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceAcceleratorInfo.Builder} avoiding the
         * need to create one manually via {@link InferenceAcceleratorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceAcceleratorInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceAcceleratorInfo(InferenceAcceleratorInfo)}.
         * 
         * @param inferenceAcceleratorInfo
         *        a consumer that will call methods on {@link InferenceAcceleratorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceAcceleratorInfo(InferenceAcceleratorInfo)
         */
        default Builder inferenceAcceleratorInfo(Consumer<InferenceAcceleratorInfo.Builder> inferenceAcceleratorInfo) {
            return inferenceAcceleratorInfo(InferenceAcceleratorInfo.builder().applyMutation(inferenceAcceleratorInfo).build());
        }

        /**
         * <p>
         * Indicates whether On-Demand hibernation is supported.
         * </p>
         * 
         * @param hibernationSupported
         *        Indicates whether On-Demand hibernation is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationSupported(Boolean hibernationSupported);

        /**
         * <p>
         * Indicates whether the instance type is a burstable performance instance type.
         * </p>
         * 
         * @param burstablePerformanceSupported
         *        Indicates whether the instance type is a burstable performance instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burstablePerformanceSupported(Boolean burstablePerformanceSupported);

        /**
         * <p>
         * Indicates whether Dedicated Hosts are supported on the instance type.
         * </p>
         * 
         * @param dedicatedHostsSupported
         *        Indicates whether Dedicated Hosts are supported on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedHostsSupported(Boolean dedicatedHostsSupported);

        /**
         * <p>
         * Indicates whether auto recovery is supported.
         * </p>
         * 
         * @param autoRecoverySupported
         *        Indicates whether auto recovery is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRecoverySupported(Boolean autoRecoverySupported);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Boolean currentGeneration;

        private Boolean freeTierEligible;

        private List<String> supportedUsageClasses = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedRootDeviceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedVirtualizationTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean bareMetal;

        private String hypervisor;

        private ProcessorInfo processorInfo;

        private VCpuInfo vCpuInfo;

        private MemoryInfo memoryInfo;

        private Boolean instanceStorageSupported;

        private InstanceStorageInfo instanceStorageInfo;

        private EbsInfo ebsInfo;

        private NetworkInfo networkInfo;

        private GpuInfo gpuInfo;

        private FpgaInfo fpgaInfo;

        private PlacementGroupInfo placementGroupInfo;

        private InferenceAcceleratorInfo inferenceAcceleratorInfo;

        private Boolean hibernationSupported;

        private Boolean burstablePerformanceSupported;

        private Boolean dedicatedHostsSupported;

        private Boolean autoRecoverySupported;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeInfo model) {
            instanceType(model.instanceType);
            currentGeneration(model.currentGeneration);
            freeTierEligible(model.freeTierEligible);
            supportedUsageClassesWithStrings(model.supportedUsageClasses);
            supportedRootDeviceTypesWithStrings(model.supportedRootDeviceTypes);
            supportedVirtualizationTypesWithStrings(model.supportedVirtualizationTypes);
            bareMetal(model.bareMetal);
            hypervisor(model.hypervisor);
            processorInfo(model.processorInfo);
            vCpuInfo(model.vCpuInfo);
            memoryInfo(model.memoryInfo);
            instanceStorageSupported(model.instanceStorageSupported);
            instanceStorageInfo(model.instanceStorageInfo);
            ebsInfo(model.ebsInfo);
            networkInfo(model.networkInfo);
            gpuInfo(model.gpuInfo);
            fpgaInfo(model.fpgaInfo);
            placementGroupInfo(model.placementGroupInfo);
            inferenceAcceleratorInfo(model.inferenceAcceleratorInfo);
            hibernationSupported(model.hibernationSupported);
            burstablePerformanceSupported(model.burstablePerformanceSupported);
            dedicatedHostsSupported(model.dedicatedHostsSupported);
            autoRecoverySupported(model.autoRecoverySupported);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Boolean getCurrentGeneration() {
            return currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getFreeTierEligible() {
            return freeTierEligible;
        }

        @Override
        public final Builder freeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
            return this;
        }

        public final void setFreeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
        }

        public final Collection<String> getSupportedUsageClasses() {
            if (supportedUsageClasses instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedUsageClasses;
        }

        @Override
        public final Builder supportedUsageClassesWithStrings(Collection<String> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copy(supportedUsageClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUsageClassesWithStrings(String... supportedUsageClasses) {
            supportedUsageClassesWithStrings(Arrays.asList(supportedUsageClasses));
            return this;
        }

        @Override
        public final Builder supportedUsageClasses(Collection<UsageClassType> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copyEnumToString(supportedUsageClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUsageClasses(UsageClassType... supportedUsageClasses) {
            supportedUsageClasses(Arrays.asList(supportedUsageClasses));
            return this;
        }

        public final void setSupportedUsageClasses(Collection<String> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copy(supportedUsageClasses);
        }

        public final Collection<String> getSupportedRootDeviceTypes() {
            if (supportedRootDeviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedRootDeviceTypes;
        }

        @Override
        public final Builder supportedRootDeviceTypesWithStrings(Collection<String> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copy(supportedRootDeviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRootDeviceTypesWithStrings(String... supportedRootDeviceTypes) {
            supportedRootDeviceTypesWithStrings(Arrays.asList(supportedRootDeviceTypes));
            return this;
        }

        @Override
        public final Builder supportedRootDeviceTypes(Collection<RootDeviceType> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copyEnumToString(supportedRootDeviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRootDeviceTypes(RootDeviceType... supportedRootDeviceTypes) {
            supportedRootDeviceTypes(Arrays.asList(supportedRootDeviceTypes));
            return this;
        }

        public final void setSupportedRootDeviceTypes(Collection<String> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copy(supportedRootDeviceTypes);
        }

        public final Collection<String> getSupportedVirtualizationTypes() {
            if (supportedVirtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedVirtualizationTypes;
        }

        @Override
        public final Builder supportedVirtualizationTypesWithStrings(Collection<String> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copy(supportedVirtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVirtualizationTypesWithStrings(String... supportedVirtualizationTypes) {
            supportedVirtualizationTypesWithStrings(Arrays.asList(supportedVirtualizationTypes));
            return this;
        }

        @Override
        public final Builder supportedVirtualizationTypes(Collection<VirtualizationType> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copyEnumToString(supportedVirtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVirtualizationTypes(VirtualizationType... supportedVirtualizationTypes) {
            supportedVirtualizationTypes(Arrays.asList(supportedVirtualizationTypes));
            return this;
        }

        public final void setSupportedVirtualizationTypes(Collection<String> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copy(supportedVirtualizationTypes);
        }

        public final Boolean getBareMetal() {
            return bareMetal;
        }

        @Override
        public final Builder bareMetal(Boolean bareMetal) {
            this.bareMetal = bareMetal;
            return this;
        }

        public final void setBareMetal(Boolean bareMetal) {
            this.bareMetal = bareMetal;
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(InstanceTypeHypervisor hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final ProcessorInfo.Builder getProcessorInfo() {
            return processorInfo != null ? processorInfo.toBuilder() : null;
        }

        @Override
        public final Builder processorInfo(ProcessorInfo processorInfo) {
            this.processorInfo = processorInfo;
            return this;
        }

        public final void setProcessorInfo(ProcessorInfo.BuilderImpl processorInfo) {
            this.processorInfo = processorInfo != null ? processorInfo.build() : null;
        }

        public final VCpuInfo.Builder getVCpuInfo() {
            return vCpuInfo != null ? vCpuInfo.toBuilder() : null;
        }

        @Override
        public final Builder vCpuInfo(VCpuInfo vCpuInfo) {
            this.vCpuInfo = vCpuInfo;
            return this;
        }

        public final void setVCpuInfo(VCpuInfo.BuilderImpl vCpuInfo) {
            this.vCpuInfo = vCpuInfo != null ? vCpuInfo.build() : null;
        }

        public final MemoryInfo.Builder getMemoryInfo() {
            return memoryInfo != null ? memoryInfo.toBuilder() : null;
        }

        @Override
        public final Builder memoryInfo(MemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public final void setMemoryInfo(MemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        public final Boolean getInstanceStorageSupported() {
            return instanceStorageSupported;
        }

        @Override
        public final Builder instanceStorageSupported(Boolean instanceStorageSupported) {
            this.instanceStorageSupported = instanceStorageSupported;
            return this;
        }

        public final void setInstanceStorageSupported(Boolean instanceStorageSupported) {
            this.instanceStorageSupported = instanceStorageSupported;
        }

        public final InstanceStorageInfo.Builder getInstanceStorageInfo() {
            return instanceStorageInfo != null ? instanceStorageInfo.toBuilder() : null;
        }

        @Override
        public final Builder instanceStorageInfo(InstanceStorageInfo instanceStorageInfo) {
            this.instanceStorageInfo = instanceStorageInfo;
            return this;
        }

        public final void setInstanceStorageInfo(InstanceStorageInfo.BuilderImpl instanceStorageInfo) {
            this.instanceStorageInfo = instanceStorageInfo != null ? instanceStorageInfo.build() : null;
        }

        public final EbsInfo.Builder getEbsInfo() {
            return ebsInfo != null ? ebsInfo.toBuilder() : null;
        }

        @Override
        public final Builder ebsInfo(EbsInfo ebsInfo) {
            this.ebsInfo = ebsInfo;
            return this;
        }

        public final void setEbsInfo(EbsInfo.BuilderImpl ebsInfo) {
            this.ebsInfo = ebsInfo != null ? ebsInfo.build() : null;
        }

        public final NetworkInfo.Builder getNetworkInfo() {
            return networkInfo != null ? networkInfo.toBuilder() : null;
        }

        @Override
        public final Builder networkInfo(NetworkInfo networkInfo) {
            this.networkInfo = networkInfo;
            return this;
        }

        public final void setNetworkInfo(NetworkInfo.BuilderImpl networkInfo) {
            this.networkInfo = networkInfo != null ? networkInfo.build() : null;
        }

        public final GpuInfo.Builder getGpuInfo() {
            return gpuInfo != null ? gpuInfo.toBuilder() : null;
        }

        @Override
        public final Builder gpuInfo(GpuInfo gpuInfo) {
            this.gpuInfo = gpuInfo;
            return this;
        }

        public final void setGpuInfo(GpuInfo.BuilderImpl gpuInfo) {
            this.gpuInfo = gpuInfo != null ? gpuInfo.build() : null;
        }

        public final FpgaInfo.Builder getFpgaInfo() {
            return fpgaInfo != null ? fpgaInfo.toBuilder() : null;
        }

        @Override
        public final Builder fpgaInfo(FpgaInfo fpgaInfo) {
            this.fpgaInfo = fpgaInfo;
            return this;
        }

        public final void setFpgaInfo(FpgaInfo.BuilderImpl fpgaInfo) {
            this.fpgaInfo = fpgaInfo != null ? fpgaInfo.build() : null;
        }

        public final PlacementGroupInfo.Builder getPlacementGroupInfo() {
            return placementGroupInfo != null ? placementGroupInfo.toBuilder() : null;
        }

        @Override
        public final Builder placementGroupInfo(PlacementGroupInfo placementGroupInfo) {
            this.placementGroupInfo = placementGroupInfo;
            return this;
        }

        public final void setPlacementGroupInfo(PlacementGroupInfo.BuilderImpl placementGroupInfo) {
            this.placementGroupInfo = placementGroupInfo != null ? placementGroupInfo.build() : null;
        }

        public final InferenceAcceleratorInfo.Builder getInferenceAcceleratorInfo() {
            return inferenceAcceleratorInfo != null ? inferenceAcceleratorInfo.toBuilder() : null;
        }

        @Override
        public final Builder inferenceAcceleratorInfo(InferenceAcceleratorInfo inferenceAcceleratorInfo) {
            this.inferenceAcceleratorInfo = inferenceAcceleratorInfo;
            return this;
        }

        public final void setInferenceAcceleratorInfo(InferenceAcceleratorInfo.BuilderImpl inferenceAcceleratorInfo) {
            this.inferenceAcceleratorInfo = inferenceAcceleratorInfo != null ? inferenceAcceleratorInfo.build() : null;
        }

        public final Boolean getHibernationSupported() {
            return hibernationSupported;
        }

        @Override
        public final Builder hibernationSupported(Boolean hibernationSupported) {
            this.hibernationSupported = hibernationSupported;
            return this;
        }

        public final void setHibernationSupported(Boolean hibernationSupported) {
            this.hibernationSupported = hibernationSupported;
        }

        public final Boolean getBurstablePerformanceSupported() {
            return burstablePerformanceSupported;
        }

        @Override
        public final Builder burstablePerformanceSupported(Boolean burstablePerformanceSupported) {
            this.burstablePerformanceSupported = burstablePerformanceSupported;
            return this;
        }

        public final void setBurstablePerformanceSupported(Boolean burstablePerformanceSupported) {
            this.burstablePerformanceSupported = burstablePerformanceSupported;
        }

        public final Boolean getDedicatedHostsSupported() {
            return dedicatedHostsSupported;
        }

        @Override
        public final Builder dedicatedHostsSupported(Boolean dedicatedHostsSupported) {
            this.dedicatedHostsSupported = dedicatedHostsSupported;
            return this;
        }

        public final void setDedicatedHostsSupported(Boolean dedicatedHostsSupported) {
            this.dedicatedHostsSupported = dedicatedHostsSupported;
        }

        public final Boolean getAutoRecoverySupported() {
            return autoRecoverySupported;
        }

        @Override
        public final Builder autoRecoverySupported(Boolean autoRecoverySupported) {
            this.autoRecoverySupported = autoRecoverySupported;
            return this;
        }

        public final void setAutoRecoverySupported(Boolean autoRecoverySupported) {
            this.autoRecoverySupported = autoRecoverySupported;
        }

        @Override
        public InstanceTypeInfo build() {
            return new InstanceTypeInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
