/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetData implements SdkPojo, Serializable, ToCopyableBuilder<FleetData.Builder, FleetData> {
    private static final SdkField<String> ACTIVITY_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActivityStatus")
            .getter(getter(FleetData::activityStatusAsString))
            .setter(setter(Builder::activityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStatus")
                    .unmarshallLocationName("activityStatus").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(FleetData::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FleetId")
            .getter(getter(FleetData::fleetId))
            .setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId")
                    .unmarshallLocationName("fleetId").build()).build();

    private static final SdkField<String> FLEET_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FleetState")
            .getter(getter(FleetData::fleetStateAsString))
            .setter(setter(Builder::fleetState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetState")
                    .unmarshallLocationName("fleetState").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(FleetData::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("clientToken").build()).build();

    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExcessCapacityTerminationPolicy")
            .getter(getter(FleetData::excessCapacityTerminationPolicyAsString))
            .setter(setter(Builder::excessCapacityTerminationPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy")
                    .unmarshallLocationName("excessCapacityTerminationPolicy").build()).build();

    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("FulfilledCapacity")
            .getter(getter(FleetData::fulfilledCapacity))
            .setter(setter(Builder::fulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity")
                    .unmarshallLocationName("fulfilledCapacity").build()).build();

    private static final SdkField<Double> FULFILLED_ON_DEMAND_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("FulfilledOnDemandCapacity")
            .getter(getter(FleetData::fulfilledOnDemandCapacity))
            .setter(setter(Builder::fulfilledOnDemandCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledOnDemandCapacity")
                    .unmarshallLocationName("fulfilledOnDemandCapacity").build()).build();

    private static final SdkField<List<FleetLaunchTemplateConfig>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField
            .<List<FleetLaunchTemplateConfig>> builder(MarshallingType.LIST)
            .memberName("LaunchTemplateConfigs")
            .getter(getter(FleetData::launchTemplateConfigs))
            .setter(setter(Builder::launchTemplateConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfigs")
                    .unmarshallLocationName("launchTemplateConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<FleetLaunchTemplateConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetLaunchTemplateConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<TargetCapacitySpecification> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField
            .<TargetCapacitySpecification> builder(MarshallingType.SDK_POJO)
            .memberName("TargetCapacitySpecification")
            .getter(getter(FleetData::targetCapacitySpecification))
            .setter(setter(Builder::targetCapacitySpecification))
            .constructor(TargetCapacitySpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification")
                    .unmarshallLocationName("targetCapacitySpecification").build()).build();

    private static final SdkField<Boolean> TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminateInstancesWithExpiration")
            .getter(getter(FleetData::terminateInstancesWithExpiration))
            .setter(setter(Builder::terminateInstancesWithExpiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateInstancesWithExpiration")
                    .unmarshallLocationName("terminateInstancesWithExpiration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(FleetData::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("type").build()).build();

    private static final SdkField<Instant> VALID_FROM_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidFrom")
            .getter(getter(FleetData::validFrom))
            .setter(setter(Builder::validFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFrom")
                    .unmarshallLocationName("validFrom").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil")
            .getter(getter(FleetData::validUntil))
            .setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil")
                    .unmarshallLocationName("validUntil").build()).build();

    private static final SdkField<Boolean> REPLACE_UNHEALTHY_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplaceUnhealthyInstances")
            .getter(getter(FleetData::replaceUnhealthyInstances))
            .setter(setter(Builder::replaceUnhealthyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceUnhealthyInstances")
                    .unmarshallLocationName("replaceUnhealthyInstances").build()).build();

    private static final SdkField<SpotOptions> SPOT_OPTIONS_FIELD = SdkField
            .<SpotOptions> builder(MarshallingType.SDK_POJO)
            .memberName("SpotOptions")
            .getter(getter(FleetData::spotOptions))
            .setter(setter(Builder::spotOptions))
            .constructor(SpotOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotOptions")
                    .unmarshallLocationName("spotOptions").build()).build();

    private static final SdkField<OnDemandOptions> ON_DEMAND_OPTIONS_FIELD = SdkField
            .<OnDemandOptions> builder(MarshallingType.SDK_POJO)
            .memberName("OnDemandOptions")
            .getter(getter(FleetData::onDemandOptions))
            .setter(setter(Builder::onDemandOptions))
            .constructor(OnDemandOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandOptions")
                    .unmarshallLocationName("onDemandOptions").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(FleetData::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DescribeFleetError>> ERRORS_FIELD = SdkField
            .<List<DescribeFleetError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(FleetData::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorSet")
                    .unmarshallLocationName("errorSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DescribeFleetError> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeFleetError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<DescribeFleetsInstances>> INSTANCES_FIELD = SdkField
            .<List<DescribeFleetsInstances>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(FleetData::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetInstanceSet")
                    .unmarshallLocationName("fleetInstanceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<DescribeFleetsInstances> builder(MarshallingType.SDK_POJO)
                                            .constructor(DescribeFleetsInstances::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_STATUS_FIELD,
            CREATE_TIME_FIELD, FLEET_ID_FIELD, FLEET_STATE_FIELD, CLIENT_TOKEN_FIELD, EXCESS_CAPACITY_TERMINATION_POLICY_FIELD,
            FULFILLED_CAPACITY_FIELD, FULFILLED_ON_DEMAND_CAPACITY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD,
            TARGET_CAPACITY_SPECIFICATION_FIELD, TERMINATE_INSTANCES_WITH_EXPIRATION_FIELD, TYPE_FIELD, VALID_FROM_FIELD,
            VALID_UNTIL_FIELD, REPLACE_UNHEALTHY_INSTANCES_FIELD, SPOT_OPTIONS_FIELD, ON_DEMAND_OPTIONS_FIELD, TAGS_FIELD,
            ERRORS_FIELD, INSTANCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activityStatus;

    private final Instant createTime;

    private final String fleetId;

    private final String fleetState;

    private final String clientToken;

    private final String excessCapacityTerminationPolicy;

    private final Double fulfilledCapacity;

    private final Double fulfilledOnDemandCapacity;

    private final List<FleetLaunchTemplateConfig> launchTemplateConfigs;

    private final TargetCapacitySpecification targetCapacitySpecification;

    private final Boolean terminateInstancesWithExpiration;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final Boolean replaceUnhealthyInstances;

    private final SpotOptions spotOptions;

    private final OnDemandOptions onDemandOptions;

    private final List<Tag> tags;

    private final List<DescribeFleetError> errors;

    private final List<DescribeFleetsInstances> instances;

    private FleetData(BuilderImpl builder) {
        this.activityStatus = builder.activityStatus;
        this.createTime = builder.createTime;
        this.fleetId = builder.fleetId;
        this.fleetState = builder.fleetState;
        this.clientToken = builder.clientToken;
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.fulfilledOnDemandCapacity = builder.fulfilledOnDemandCapacity;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.terminateInstancesWithExpiration = builder.terminateInstancesWithExpiration;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.replaceUnhealthyInstances = builder.replaceUnhealthyInstances;
        this.spotOptions = builder.spotOptions;
        this.onDemandOptions = builder.onDemandOptions;
        this.tags = builder.tags;
        this.errors = builder.errors;
        this.instances = builder.instances;
    }

    /**
     * <p>
     * The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests are
     * placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or greater than
     * its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is decreased, the status
     * is <code>pending_termination</code> while instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link FleetActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activityStatusAsString}.
     * </p>
     * 
     * @return The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests
     *         are placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or
     *         greater than its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is
     *         decreased, the status is <code>pending_termination</code> while instances are terminating.
     * @see FleetActivityStatus
     */
    public final FleetActivityStatus activityStatus() {
        return FleetActivityStatus.fromValue(activityStatus);
    }

    /**
     * <p>
     * The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests are
     * placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or greater than
     * its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is decreased, the status
     * is <code>pending_termination</code> while instances are terminating.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activityStatus}
     * will return {@link FleetActivityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #activityStatusAsString}.
     * </p>
     * 
     * @return The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests
     *         are placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or
     *         greater than its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is
     *         decreased, the status is <code>pending_termination</code> while instances are terminating.
     * @see FleetActivityStatus
     */
    public final String activityStatusAsString() {
        return activityStatus;
    }

    /**
     * <p>
     * The creation date and time of the EC2 Fleet.
     * </p>
     * 
     * @return The creation date and time of the EC2 Fleet.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The ID of the EC2 Fleet.
     * </p>
     * 
     * @return The ID of the EC2 Fleet.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetState} will
     * return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStateAsString}.
     * </p>
     * 
     * @return The state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public final FleetStateCode fleetState() {
        return FleetStateCode.fromValue(fleetState);
    }

    /**
     * <p>
     * The state of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetState} will
     * return {@link FleetStateCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetStateAsString}.
     * </p>
     * 
     * @return The state of the EC2 Fleet.
     * @see FleetStateCode
     */
    public final String fleetStateAsString() {
        return fleetState;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * <p>
     * Constraints: Maximum 64 ASCII characters
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.</p>
     *         <p>
     *         Constraints: Maximum 64 ASCII characters
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is decreased
     * below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public final FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(excessCapacityTerminationPolicy);
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is decreased
     * below the current size of the EC2 Fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #excessCapacityTerminationPolicy} will return
     * {@link FleetExcessCapacityTerminationPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excessCapacityTerminationPolicyAsString}.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is
     *         decreased below the current size of the EC2 Fleet.
     * @see FleetExcessCapacityTerminationPolicy
     */
    public final String excessCapacityTerminationPolicyAsString() {
        return excessCapacityTerminationPolicy;
    }

    /**
     * <p>
     * The number of units fulfilled by this request compared to the set target capacity.
     * </p>
     * 
     * @return The number of units fulfilled by this request compared to the set target capacity.
     */
    public final Double fulfilledCapacity() {
        return fulfilledCapacity;
    }

    /**
     * <p>
     * The number of units fulfilled by this request compared to the set target On-Demand capacity.
     * </p>
     * 
     * @return The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    public final Double fulfilledOnDemandCapacity() {
        return fulfilledOnDemandCapacity;
    }

    /**
     * Returns true if the LaunchTemplateConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasLaunchTemplateConfigs() {
        return launchTemplateConfigs != null && !(launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The launch template and overrides.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplateConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The launch template and overrides.
     */
    public final List<FleetLaunchTemplateConfig> launchTemplateConfigs() {
        return launchTemplateConfigs;
    }

    /**
     * <p>
     * The number of units to request. You can choose to set the target capacity in terms of instances or a performance
     * characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If the request type
     * is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
     * </p>
     * 
     * @return The number of units to request. You can choose to set the target capacity in terms of instances or a
     *         performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O.
     *         If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity
     *         later.
     */
    public final TargetCapacitySpecification targetCapacitySpecification() {
        return targetCapacitySpecification;
    }

    /**
     * <p>
     * Indicates whether running instances should be terminated when the EC2 Fleet expires.
     * </p>
     * 
     * @return Indicates whether running instances should be terminated when the EC2 Fleet expires.
     */
    public final Boolean terminateInstancesWithExpiration() {
        return terminateInstancesWithExpiration;
    }

    /**
     * <p>
     * The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or also
     * attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only places the
     * required requests; it does not attempt to replenish instances if capacity is diminished, and it does not submit
     * requests in alternative capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2
     * Fleet places the required requests to meet this target capacity. It also automatically replenishes any
     * interrupted Spot Instances. Default: <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or
     *         also attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only
     *         places the required requests; it does not attempt to replenish instances if capacity is diminished, and
     *         it does not submit requests in alternative capacity pools if capacity is unavailable. To maintain a
     *         certain target capacity, EC2 Fleet places the required requests to meet this target capacity. It also
     *         automatically replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
     * @see FleetType
     */
    public final FleetType type() {
        return FleetType.fromValue(type);
    }

    /**
     * <p>
     * The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or also
     * attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only places the
     * required requests; it does not attempt to replenish instances if capacity is diminished, and it does not submit
     * requests in alternative capacity pools if capacity is unavailable. To maintain a certain target capacity, EC2
     * Fleet places the required requests to meet this target capacity. It also automatically replenishes any
     * interrupted Spot Instances. Default: <code>maintain</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or
     *         also attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only
     *         places the required requests; it does not attempt to replenish instances if capacity is diminished, and
     *         it does not submit requests in alternative capacity pools if capacity is unavailable. To maintain a
     *         certain target capacity, EC2 Fleet places the required requests to meet this target capacity. It also
     *         automatically replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
     * @see FleetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the request
     * immediately.
     * </p>
     * 
     * @return The start date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
     *         request immediately.
     */
    public final Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date and time of the request, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance requests are
     * placed or able to fulfill the request. The default end date is 7 days from the current date.
     * </p>
     * 
     * @return The end date and time of the request, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance requests
     *         are placed or able to fulfill the request. The default end date is 7 days from the current date.
     */
    public final Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type
     * <code>maintain</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2
     * Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type
     *         <code>maintain</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks"
     *         >EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean replaceUnhealthyInstances() {
        return replaceUnhealthyInstances;
    }

    /**
     * <p>
     * The configuration of Spot Instances in an EC2 Fleet.
     * </p>
     * 
     * @return The configuration of Spot Instances in an EC2 Fleet.
     */
    public final SpotOptions spotOptions() {
        return spotOptions;
    }

    /**
     * <p>
     * The allocation strategy of On-Demand Instances in an EC2 Fleet.
     * </p>
     * 
     * @return The allocation strategy of On-Demand Instances in an EC2 Fleet.
     */
    public final OnDemandOptions onDemandOptions() {
        return onDemandOptions;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags for an EC2 Fleet resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags for an EC2 Fleet resource.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the Errors property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set to
     * <code>instant</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasErrors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is
     *         set to <code>instant</code>.
     */
    public final List<DescribeFleetError> errors() {
        return errors;
    }

    /**
     * Returns true if the Instances property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
     * <code>instant</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
     *         <code>instant</code>.
     */
    public final List<DescribeFleetsInstances> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(fulfilledOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(terminateInstancesWithExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(replaceUnhealthyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(spotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetData)) {
            return false;
        }
        FleetData other = (FleetData) obj;
        return Objects.equals(activityStatusAsString(), other.activityStatusAsString())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(fleetStateAsString(), other.fleetStateAsString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString())
                && Objects.equals(fulfilledCapacity(), other.fulfilledCapacity())
                && Objects.equals(fulfilledOnDemandCapacity(), other.fulfilledOnDemandCapacity())
                && hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs()
                && Objects.equals(launchTemplateConfigs(), other.launchTemplateConfigs())
                && Objects.equals(targetCapacitySpecification(), other.targetCapacitySpecification())
                && Objects.equals(terminateInstancesWithExpiration(), other.terminateInstancesWithExpiration())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(validFrom(), other.validFrom())
                && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(replaceUnhealthyInstances(), other.replaceUnhealthyInstances())
                && Objects.equals(spotOptions(), other.spotOptions())
                && Objects.equals(onDemandOptions(), other.onDemandOptions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && hasInstances() == other.hasInstances()
                && Objects.equals(instances(), other.instances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetData").add("ActivityStatus", activityStatusAsString()).add("CreateTime", createTime())
                .add("FleetId", fleetId()).add("FleetState", fleetStateAsString()).add("ClientToken", clientToken())
                .add("ExcessCapacityTerminationPolicy", excessCapacityTerminationPolicyAsString())
                .add("FulfilledCapacity", fulfilledCapacity()).add("FulfilledOnDemandCapacity", fulfilledOnDemandCapacity())
                .add("LaunchTemplateConfigs", hasLaunchTemplateConfigs() ? launchTemplateConfigs() : null)
                .add("TargetCapacitySpecification", targetCapacitySpecification())
                .add("TerminateInstancesWithExpiration", terminateInstancesWithExpiration()).add("Type", typeAsString())
                .add("ValidFrom", validFrom()).add("ValidUntil", validUntil())
                .add("ReplaceUnhealthyInstances", replaceUnhealthyInstances()).add("SpotOptions", spotOptions())
                .add("OnDemandOptions", onDemandOptions()).add("Tags", hasTags() ? tags() : null)
                .add("Errors", hasErrors() ? errors() : null).add("Instances", hasInstances() ? instances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityStatus":
            return Optional.ofNullable(clazz.cast(activityStatusAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "FleetState":
            return Optional.ofNullable(clazz.cast(fleetStateAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ExcessCapacityTerminationPolicy":
            return Optional.ofNullable(clazz.cast(excessCapacityTerminationPolicyAsString()));
        case "FulfilledCapacity":
            return Optional.ofNullable(clazz.cast(fulfilledCapacity()));
        case "FulfilledOnDemandCapacity":
            return Optional.ofNullable(clazz.cast(fulfilledOnDemandCapacity()));
        case "LaunchTemplateConfigs":
            return Optional.ofNullable(clazz.cast(launchTemplateConfigs()));
        case "TargetCapacitySpecification":
            return Optional.ofNullable(clazz.cast(targetCapacitySpecification()));
        case "TerminateInstancesWithExpiration":
            return Optional.ofNullable(clazz.cast(terminateInstancesWithExpiration()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ValidFrom":
            return Optional.ofNullable(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        case "ReplaceUnhealthyInstances":
            return Optional.ofNullable(clazz.cast(replaceUnhealthyInstances()));
        case "SpotOptions":
            return Optional.ofNullable(clazz.cast(spotOptions()));
        case "OnDemandOptions":
            return Optional.ofNullable(clazz.cast(onDemandOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetData, T> g) {
        return obj -> g.apply((FleetData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetData> {
        /**
         * <p>
         * The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests are
         * placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or greater
         * than its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is decreased,
         * the status is <code>pending_termination</code> while instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all
         *        requests are placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is
         *        equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the
         *        EC2 Fleet is decreased, the status is <code>pending_termination</code> while instances are
         *        terminating.
         * @see FleetActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetActivityStatus
         */
        Builder activityStatus(String activityStatus);

        /**
         * <p>
         * The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all requests are
         * placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is equal to or greater
         * than its target capacity, the status is <code>fulfilled</code>. If the size of the EC2 Fleet is decreased,
         * the status is <code>pending_termination</code> while instances are terminating.
         * </p>
         * 
         * @param activityStatus
         *        The progress of the EC2 Fleet. If there is an error, the status is <code>error</code>. After all
         *        requests are placed, the status is <code>pending_fulfillment</code>. If the size of the EC2 Fleet is
         *        equal to or greater than its target capacity, the status is <code>fulfilled</code>. If the size of the
         *        EC2 Fleet is decreased, the status is <code>pending_termination</code> while instances are
         *        terminating.
         * @see FleetActivityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetActivityStatus
         */
        Builder activityStatus(FleetActivityStatus activityStatus);

        /**
         * <p>
         * The creation date and time of the EC2 Fleet.
         * </p>
         * 
         * @param createTime
         *        The creation date and time of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The ID of the EC2 Fleet.
         * </p>
         * 
         * @param fleetId
         *        The ID of the EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The state of the EC2 Fleet.
         * </p>
         * 
         * @param fleetState
         *        The state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder fleetState(String fleetState);

        /**
         * <p>
         * The state of the EC2 Fleet.
         * </p>
         * 
         * @param fleetState
         *        The state of the EC2 Fleet.
         * @see FleetStateCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetStateCode
         */
        Builder fleetState(FleetStateCode fleetState);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * <p>
         * Constraints: Maximum 64 ASCII characters
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.</p>
         *        <p>
         *        Constraints: Maximum 64 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is decreased
         * below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is
         *        decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy);

        /**
         * <p>
         * Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is decreased
         * below the current size of the EC2 Fleet.
         * </p>
         * 
         * @param excessCapacityTerminationPolicy
         *        Indicates whether running instances should be terminated if the target capacity of the EC2 Fleet is
         *        decreased below the current size of the EC2 Fleet.
         * @see FleetExcessCapacityTerminationPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetExcessCapacityTerminationPolicy
         */
        Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy);

        /**
         * <p>
         * The number of units fulfilled by this request compared to the set target capacity.
         * </p>
         * 
         * @param fulfilledCapacity
         *        The number of units fulfilled by this request compared to the set target capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledCapacity(Double fulfilledCapacity);

        /**
         * <p>
         * The number of units fulfilled by this request compared to the set target On-Demand capacity.
         * </p>
         * 
         * @param fulfilledOnDemandCapacity
         *        The number of units fulfilled by this request compared to the set target On-Demand capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * 
         * @param launchTemplateConfigs
         *        The launch template and overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateConfigs(FleetLaunchTemplateConfig... launchTemplateConfigs);

        /**
         * <p>
         * The launch template and overrides.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetLaunchTemplateConfig>.Builder}
         * avoiding the need to create one manually via {@link List<FleetLaunchTemplateConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetLaunchTemplateConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplateConfigs(List<FleetLaunchTemplateConfig>)}.
         * 
         * @param launchTemplateConfigs
         *        a consumer that will call methods on {@link List<FleetLaunchTemplateConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateConfigs(List<FleetLaunchTemplateConfig>)
         */
        Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder>... launchTemplateConfigs);

        /**
         * <p>
         * The number of units to request. You can choose to set the target capacity in terms of instances or a
         * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If
         * the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
         * </p>
         * 
         * @param targetCapacitySpecification
         *        The number of units to request. You can choose to set the target capacity in terms of instances or a
         *        performance characteristic that is important to your application workload, such as vCPUs, memory, or
         *        I/O. If the request type is <code>maintain</code>, you can specify a target capacity of 0 and add
         *        capacity later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification);

        /**
         * <p>
         * The number of units to request. You can choose to set the target capacity in terms of instances or a
         * performance characteristic that is important to your application workload, such as vCPUs, memory, or I/O. If
         * the request type is <code>maintain</code>, you can specify a target capacity of 0 and add capacity later.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetCapacitySpecification.Builder} avoiding
         * the need to create one manually via {@link TargetCapacitySpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetCapacitySpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #targetCapacitySpecification(TargetCapacitySpecification)}.
         * 
         * @param targetCapacitySpecification
         *        a consumer that will call methods on {@link TargetCapacitySpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetCapacitySpecification(TargetCapacitySpecification)
         */
        default Builder targetCapacitySpecification(Consumer<TargetCapacitySpecification.Builder> targetCapacitySpecification) {
            return targetCapacitySpecification(TargetCapacitySpecification.builder().applyMutation(targetCapacitySpecification)
                    .build());
        }

        /**
         * <p>
         * Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * </p>
         * 
         * @param terminateInstancesWithExpiration
         *        Indicates whether running instances should be terminated when the EC2 Fleet expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration);

        /**
         * <p>
         * The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or also
         * attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only places the
         * required requests; it does not attempt to replenish instances if capacity is diminished, and it does not
         * submit requests in alternative capacity pools if capacity is unavailable. To maintain a certain target
         * capacity, EC2 Fleet places the required requests to meet this target capacity. It also automatically
         * replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity,
         *        or also attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only
         *        places the required requests; it does not attempt to replenish instances if capacity is diminished,
         *        and it does not submit requests in alternative capacity pools if capacity is unavailable. To maintain
         *        a certain target capacity, EC2 Fleet places the required requests to meet this target capacity. It
         *        also automatically replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity, or also
         * attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only places the
         * required requests; it does not attempt to replenish instances if capacity is diminished, and it does not
         * submit requests in alternative capacity pools if capacity is unavailable. To maintain a certain target
         * capacity, EC2 Fleet places the required requests to meet this target capacity. It also automatically
         * replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
         * </p>
         * 
         * @param type
         *        The type of request. Indicates whether the EC2 Fleet only <code>requests</code> the target capacity,
         *        or also attempts to <code>maintain</code> it. If you request a certain target capacity, EC2 Fleet only
         *        places the required requests; it does not attempt to replenish instances if capacity is diminished,
         *        and it does not submit requests in alternative capacity pools if capacity is unavailable. To maintain
         *        a certain target capacity, EC2 Fleet places the required requests to meet this target capacity. It
         *        also automatically replenishes any interrupted Spot Instances. Default: <code>maintain</code>.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder type(FleetType type);

        /**
         * <p>
         * The start date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling the
         * request immediately.
         * </p>
         * 
         * @param validFrom
         *        The start date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). The default is to start fulfilling
         *        the request immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date and time of the request, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance requests are
         * placed or able to fulfill the request. The default end date is 7 days from the current date.
         * </p>
         * 
         * @param validUntil
         *        The end date and time of the request, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z). At this point, no new instance
         *        requests are placed or able to fulfill the request. The default end date is 7 days from the current
         *        date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type
         * <code>maintain</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks">EC2
         * Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param replaceUnhealthyInstances
         *        Indicates whether EC2 Fleet should replace unhealthy Spot Instances. Supported only for fleets of type
         *        <code>maintain</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks"
         *        >EC2 Fleet health checks</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances);

        /**
         * <p>
         * The configuration of Spot Instances in an EC2 Fleet.
         * </p>
         * 
         * @param spotOptions
         *        The configuration of Spot Instances in an EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotOptions(SpotOptions spotOptions);

        /**
         * <p>
         * The configuration of Spot Instances in an EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotOptions.Builder} avoiding the need to create
         * one manually via {@link SpotOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #spotOptions(SpotOptions)}.
         * 
         * @param spotOptions
         *        a consumer that will call methods on {@link SpotOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotOptions(SpotOptions)
         */
        default Builder spotOptions(Consumer<SpotOptions.Builder> spotOptions) {
            return spotOptions(SpotOptions.builder().applyMutation(spotOptions).build());
        }

        /**
         * <p>
         * The allocation strategy of On-Demand Instances in an EC2 Fleet.
         * </p>
         * 
         * @param onDemandOptions
         *        The allocation strategy of On-Demand Instances in an EC2 Fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandOptions(OnDemandOptions onDemandOptions);

        /**
         * <p>
         * The allocation strategy of On-Demand Instances in an EC2 Fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link OnDemandOptions.Builder} avoiding the need to
         * create one manually via {@link OnDemandOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnDemandOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #onDemandOptions(OnDemandOptions)}.
         * 
         * @param onDemandOptions
         *        a consumer that will call methods on {@link OnDemandOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandOptions(OnDemandOptions)
         */
        default Builder onDemandOptions(Consumer<OnDemandOptions.Builder> onDemandOptions) {
            return onDemandOptions(OnDemandOptions.builder().applyMutation(onDemandOptions).build());
        }

        /**
         * <p>
         * The tags for an EC2 Fleet resource.
         * </p>
         * 
         * @param tags
         *        The tags for an EC2 Fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags for an EC2 Fleet resource.
         * </p>
         * 
         * @param tags
         *        The tags for an EC2 Fleet resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags for an EC2 Fleet resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set
         * to <code>instant</code>.
         * </p>
         * 
         * @param errors
         *        Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b>
         *        is set to <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<DescribeFleetError> errors);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set
         * to <code>instant</code>.
         * </p>
         * 
         * @param errors
         *        Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b>
         *        is set to <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(DescribeFleetError... errors);

        /**
         * <p>
         * Information about the instances that could not be launched by the fleet. Valid only when <b>Type</b> is set
         * to <code>instant</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DescribeFleetError>.Builder} avoiding the
         * need to create one manually via {@link List<DescribeFleetError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DescribeFleetError>.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<DescribeFleetError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<DescribeFleetError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<DescribeFleetError>)
         */
        Builder errors(Consumer<DescribeFleetError.Builder>... errors);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
         * <code>instant</code>.
         * </p>
         * 
         * @param instances
         *        Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
         *        <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<DescribeFleetsInstances> instances);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
         * <code>instant</code>.
         * </p>
         * 
         * @param instances
         *        Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
         *        <code>instant</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(DescribeFleetsInstances... instances);

        /**
         * <p>
         * Information about the instances that were launched by the fleet. Valid only when <b>Type</b> is set to
         * <code>instant</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DescribeFleetsInstances>.Builder} avoiding
         * the need to create one manually via {@link List<DescribeFleetsInstances>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DescribeFleetsInstances>.Builder#build()} is called
         * immediately and its result is passed to {@link #instances(List<DescribeFleetsInstances>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<DescribeFleetsInstances>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<DescribeFleetsInstances>)
         */
        Builder instances(Consumer<DescribeFleetsInstances.Builder>... instances);
    }

    static final class BuilderImpl implements Builder {
        private String activityStatus;

        private Instant createTime;

        private String fleetId;

        private String fleetState;

        private String clientToken;

        private String excessCapacityTerminationPolicy;

        private Double fulfilledCapacity;

        private Double fulfilledOnDemandCapacity;

        private List<FleetLaunchTemplateConfig> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();

        private TargetCapacitySpecification targetCapacitySpecification;

        private Boolean terminateInstancesWithExpiration;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private Boolean replaceUnhealthyInstances;

        private SpotOptions spotOptions;

        private OnDemandOptions onDemandOptions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<DescribeFleetError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<DescribeFleetsInstances> instances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetData model) {
            activityStatus(model.activityStatus);
            createTime(model.createTime);
            fleetId(model.fleetId);
            fleetState(model.fleetState);
            clientToken(model.clientToken);
            excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            fulfilledCapacity(model.fulfilledCapacity);
            fulfilledOnDemandCapacity(model.fulfilledOnDemandCapacity);
            launchTemplateConfigs(model.launchTemplateConfigs);
            targetCapacitySpecification(model.targetCapacitySpecification);
            terminateInstancesWithExpiration(model.terminateInstancesWithExpiration);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            replaceUnhealthyInstances(model.replaceUnhealthyInstances);
            spotOptions(model.spotOptions);
            onDemandOptions(model.onDemandOptions);
            tags(model.tags);
            errors(model.errors);
            instances(model.instances);
        }

        public final String getActivityStatus() {
            return activityStatus;
        }

        @Override
        public final Builder activityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
            return this;
        }

        @Override
        public final Builder activityStatus(FleetActivityStatus activityStatus) {
            this.activityStatus(activityStatus == null ? null : activityStatus.toString());
            return this;
        }

        public final void setActivityStatus(String activityStatus) {
            this.activityStatus = activityStatus;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getFleetState() {
            return fleetState;
        }

        @Override
        public final Builder fleetState(String fleetState) {
            this.fleetState = fleetState;
            return this;
        }

        @Override
        public final Builder fleetState(FleetStateCode fleetState) {
            this.fleetState(fleetState == null ? null : fleetState.toString());
            return this;
        }

        public final void setFleetState(String fleetState) {
            this.fleetState = fleetState;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getExcessCapacityTerminationPolicy() {
            return excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy
                    .toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final Double getFulfilledCapacity() {
            return fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        public final Double getFulfilledOnDemandCapacity() {
            return fulfilledOnDemandCapacity;
        }

        @Override
        public final Builder fulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
            return this;
        }

        public final void setFulfilledOnDemandCapacity(Double fulfilledOnDemandCapacity) {
            this.fulfilledOnDemandCapacity = fulfilledOnDemandCapacity;
        }

        public final Collection<FleetLaunchTemplateConfig.Builder> getLaunchTemplateConfigs() {
            if (launchTemplateConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return launchTemplateConfigs != null ? launchTemplateConfigs.stream().map(FleetLaunchTemplateConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfig> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfig... launchTemplateConfigs) {
            launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfig.Builder>... launchTemplateConfigs) {
            launchTemplateConfigs(Stream.of(launchTemplateConfigs)
                    .map(c -> FleetLaunchTemplateConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfig.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final TargetCapacitySpecification.Builder getTargetCapacitySpecification() {
            return targetCapacitySpecification != null ? targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecification targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecification.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final Boolean getTerminateInstancesWithExpiration() {
            return terminateInstancesWithExpiration;
        }

        @Override
        public final Builder terminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
            return this;
        }

        public final void setTerminateInstancesWithExpiration(Boolean terminateInstancesWithExpiration) {
            this.terminateInstancesWithExpiration = terminateInstancesWithExpiration;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FleetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final Boolean getReplaceUnhealthyInstances() {
            return replaceUnhealthyInstances;
        }

        @Override
        public final Builder replaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
            return this;
        }

        public final void setReplaceUnhealthyInstances(Boolean replaceUnhealthyInstances) {
            this.replaceUnhealthyInstances = replaceUnhealthyInstances;
        }

        public final SpotOptions.Builder getSpotOptions() {
            return spotOptions != null ? spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(SpotOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(SpotOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        public final OnDemandOptions.Builder getOnDemandOptions() {
            return onDemandOptions != null ? onDemandOptions.toBuilder() : null;
        }

        @Override
        public final Builder onDemandOptions(OnDemandOptions onDemandOptions) {
            this.onDemandOptions = onDemandOptions;
            return this;
        }

        public final void setOnDemandOptions(OnDemandOptions.BuilderImpl onDemandOptions) {
            this.onDemandOptions = onDemandOptions != null ? onDemandOptions.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<DescribeFleetError.Builder> getErrors() {
            if (errors instanceof SdkAutoConstructList) {
                return null;
            }
            return errors != null ? errors.stream().map(DescribeFleetError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<DescribeFleetError> errors) {
            this.errors = DescribeFleetsErrorSetCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(DescribeFleetError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<DescribeFleetError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> DescribeFleetError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<DescribeFleetError.BuilderImpl> errors) {
            this.errors = DescribeFleetsErrorSetCopier.copyFromBuilder(errors);
        }

        public final Collection<DescribeFleetsInstances.Builder> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances != null ? instances.stream().map(DescribeFleetsInstances::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instances(Collection<DescribeFleetsInstances> instances) {
            this.instances = DescribeFleetsInstancesSetCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(DescribeFleetsInstances... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<DescribeFleetsInstances.Builder>... instances) {
            instances(Stream.of(instances).map(c -> DescribeFleetsInstances.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<DescribeFleetsInstances.BuilderImpl> instances) {
            this.instances = DescribeFleetsInstancesSetCopier.copyFromBuilder(instances);
        }

        @Override
        public FleetData build() {
            return new FleetData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
