/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCarrierGatewaysResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeCarrierGatewaysResponse.Builder, DescribeCarrierGatewaysResponse> {
    private static final SdkField<List<CarrierGateway>> CARRIER_GATEWAYS_FIELD = SdkField
            .<List<CarrierGateway>> builder(MarshallingType.LIST)
            .memberName("CarrierGateways")
            .getter(getter(DescribeCarrierGatewaysResponse::carrierGateways))
            .setter(setter(Builder::carrierGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewaySet")
                    .unmarshallLocationName("carrierGatewaySet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CarrierGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(CarrierGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCarrierGatewaysResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_GATEWAYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<CarrierGateway> carrierGateways;

    private final String nextToken;

    private DescribeCarrierGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.carrierGateways = builder.carrierGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CarrierGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCarrierGateways() {
        return carrierGateways != null && !(carrierGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the carrier gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCarrierGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the carrier gateway.
     */
    public final List<CarrierGateway> carrierGateways() {
        return carrierGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCarrierGateways() ? carrierGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCarrierGatewaysResponse)) {
            return false;
        }
        DescribeCarrierGatewaysResponse other = (DescribeCarrierGatewaysResponse) obj;
        return hasCarrierGateways() == other.hasCarrierGateways() && Objects.equals(carrierGateways(), other.carrierGateways())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCarrierGatewaysResponse")
                .add("CarrierGateways", hasCarrierGateways() ? carrierGateways() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CarrierGateways":
            return Optional.ofNullable(clazz.cast(carrierGateways()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCarrierGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeCarrierGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCarrierGatewaysResponse> {
        /**
         * <p>
         * Information about the carrier gateway.
         * </p>
         * 
         * @param carrierGateways
         *        Information about the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGateways(Collection<CarrierGateway> carrierGateways);

        /**
         * <p>
         * Information about the carrier gateway.
         * </p>
         * 
         * @param carrierGateways
         *        Information about the carrier gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierGateways(CarrierGateway... carrierGateways);

        /**
         * <p>
         * Information about the carrier gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CarrierGateway>.Builder} avoiding the need
         * to create one manually via {@link List<CarrierGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CarrierGateway>.Builder#build()} is called immediately and
         * its result is passed to {@link #carrierGateways(List<CarrierGateway>)}.
         * 
         * @param carrierGateways
         *        a consumer that will call methods on {@link List<CarrierGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #carrierGateways(List<CarrierGateway>)
         */
        Builder carrierGateways(Consumer<CarrierGateway.Builder>... carrierGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<CarrierGateway> carrierGateways = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCarrierGatewaysResponse model) {
            super(model);
            carrierGateways(model.carrierGateways);
            nextToken(model.nextToken);
        }

        public final Collection<CarrierGateway.Builder> getCarrierGateways() {
            if (carrierGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return carrierGateways != null ? carrierGateways.stream().map(CarrierGateway::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder carrierGateways(Collection<CarrierGateway> carrierGateways) {
            this.carrierGateways = CarrierGatewaySetCopier.copy(carrierGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carrierGateways(CarrierGateway... carrierGateways) {
            carrierGateways(Arrays.asList(carrierGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carrierGateways(Consumer<CarrierGateway.Builder>... carrierGateways) {
            carrierGateways(Stream.of(carrierGateways).map(c -> CarrierGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCarrierGateways(Collection<CarrierGateway.BuilderImpl> carrierGateways) {
            this.carrierGateways = CarrierGatewaySetCopier.copyFromBuilder(carrierGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeCarrierGatewaysResponse build() {
            return new DescribeCarrierGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
