/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyFpgaImageRequest extends Ec2Request implements
        ToCopyableBuilder<CopyFpgaImageRequest.Builder, CopyFpgaImageRequest> {
    private static final SdkField<String> SOURCE_FPGA_IMAGE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceFpgaImageId")
            .getter(getter(CopyFpgaImageRequest::sourceFpgaImageId))
            .setter(setter(Builder::sourceFpgaImageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFpgaImageId")
                    .unmarshallLocationName("SourceFpgaImageId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(CopyFpgaImageRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CopyFpgaImageRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion")
            .getter(getter(CopyFpgaImageRequest::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion")
                    .unmarshallLocationName("SourceRegion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CopyFpgaImageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FPGA_IMAGE_ID_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, SOURCE_REGION_FIELD, CLIENT_TOKEN_FIELD));

    private final String sourceFpgaImageId;

    private final String description;

    private final String name;

    private final String sourceRegion;

    private final String clientToken;

    private CopyFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFpgaImageId = builder.sourceFpgaImageId;
        this.description = builder.description;
        this.name = builder.name;
        this.sourceRegion = builder.sourceRegion;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the source AFI.
     * </p>
     * 
     * @return The ID of the source AFI.
     */
    public final String sourceFpgaImageId() {
        return sourceFpgaImageId;
    }

    /**
     * <p>
     * The description for the new AFI.
     * </p>
     * 
     * @return The description for the new AFI.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name for the new AFI. The default is the name of the source AFI.
     * </p>
     * 
     * @return The name for the new AFI. The default is the name of the source AFI.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Region that contains the source AFI.
     * </p>
     * 
     * @return The Region that contains the source AFI.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceFpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFpgaImageRequest)) {
            return false;
        }
        CopyFpgaImageRequest other = (CopyFpgaImageRequest) obj;
        return Objects.equals(sourceFpgaImageId(), other.sourceFpgaImageId())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyFpgaImageRequest").add("SourceFpgaImageId", sourceFpgaImageId())
                .add("Description", description()).add("Name", name()).add("SourceRegion", sourceRegion())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceFpgaImageId":
            return Optional.ofNullable(clazz.cast(sourceFpgaImageId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyFpgaImageRequest, T> g) {
        return obj -> g.apply((CopyFpgaImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CopyFpgaImageRequest> {
        /**
         * <p>
         * The ID of the source AFI.
         * </p>
         * 
         * @param sourceFpgaImageId
         *        The ID of the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFpgaImageId(String sourceFpgaImageId);

        /**
         * <p>
         * The description for the new AFI.
         * </p>
         * 
         * @param description
         *        The description for the new AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the new AFI. The default is the name of the source AFI.
         * </p>
         * 
         * @param name
         *        The name for the new AFI. The default is the name of the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Region that contains the source AFI.
         * </p>
         * 
         * @param sourceRegion
         *        The Region that contains the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String sourceFpgaImageId;

        private String description;

        private String name;

        private String sourceRegion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFpgaImageRequest model) {
            super(model);
            sourceFpgaImageId(model.sourceFpgaImageId);
            description(model.description);
            name(model.name);
            sourceRegion(model.sourceRegion);
            clientToken(model.clientToken);
        }

        public final String getSourceFpgaImageId() {
            return sourceFpgaImageId;
        }

        @Override
        public final Builder sourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
            return this;
        }

        public final void setSourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyFpgaImageRequest build() {
            return new CopyFpgaImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
