/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateAddressRequest extends Ec2Request implements
        ToCopyableBuilder<AssociateAddressRequest.Builder, AssociateAddressRequest> {
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(AssociateAddressRequest::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("AllocationId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(AssociateAddressRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("InstanceId").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(AssociateAddressRequest::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("PublicIp").build()).build();

    private static final SdkField<Boolean> ALLOW_REASSOCIATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowReassociation")
            .getter(getter(AssociateAddressRequest::allowReassociation))
            .setter(setter(Builder::allowReassociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowReassociation")
                    .unmarshallLocationName("allowReassociation").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AssociateAddressRequest::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(AssociateAddressRequest::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATION_ID_FIELD,
            INSTANCE_ID_FIELD, PUBLIC_IP_FIELD, ALLOW_REASSOCIATION_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD));

    private final String allocationId;

    private final String instanceId;

    private final String publicIp;

    private final Boolean allowReassociation;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private AssociateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allowReassociation = builder.allowReassociation;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * [EC2-VPC] The allocation ID. This is required for EC2-VPC.
     * </p>
     * 
     * @return [EC2-VPC] The allocation ID. This is required for EC2-VPC.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can
     * specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify an
     * instance ID and the instance must be in the running state.
     * </p>
     * 
     * @return The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you
     *         can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must
     *         specify an instance ID and the instance must be in the running state.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.
     * </p>
     * 
     * @return [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already
     * associated with an instance or network interface to be reassociated with the specified instance or network
     * interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic,
     * therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated
     * with another resource.
     * </p>
     * 
     * @return [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is
     *         already associated with an instance or network interface to be reassociated with the specified instance
     *         or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation
     *         is automatic, therefore you can specify false to ensure the operation fails if the Elastic IP address is
     *         already associated with another resource.
     */
    public final Boolean allowReassociation() {
        return allowReassociation;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must specify
     * a network interface ID.
     * </p>
     * <p>
     * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must
     *         specify a network interface ID.</p>
     *         <p>
     *         For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private IP
     * address is specified, the Elastic IP address is associated with the primary private IP address.
     * </p>
     * 
     * @return [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no
     *         private IP address is specified, the Elastic IP address is associated with the primary private IP
     *         address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allowReassociation());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAddressRequest)) {
            return false;
        }
        AssociateAddressRequest other = (AssociateAddressRequest) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(allowReassociation(), other.allowReassociation())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateAddressRequest").add("AllocationId", allocationId()).add("InstanceId", instanceId())
                .add("PublicIp", publicIp()).add("AllowReassociation", allowReassociation())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "AllowReassociation":
            return Optional.ofNullable(clazz.cast(allowReassociation()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateAddressRequest, T> g) {
        return obj -> g.apply((AssociateAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, AssociateAddressRequest> {
        /**
         * <p>
         * [EC2-VPC] The allocation ID. This is required for EC2-VPC.
         * </p>
         * 
         * @param allocationId
         *        [EC2-VPC] The allocation ID. This is required for EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC, you can
         * specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you must specify
         * an instance ID and the instance must be in the running state.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance. The instance must have exactly one attached network interface. For EC2-VPC,
         *        you can specify either the instance ID or the network interface ID, but not both. For EC2-Classic, you
         *        must specify an instance ID and the instance must be in the running state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.
         * </p>
         * 
         * @param publicIp
         *        [EC2-Classic] The Elastic IP address to associate with the instance. This is required for EC2-Classic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is already
         * associated with an instance or network interface to be reassociated with the specified instance or network
         * interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account, reassociation is automatic,
         * therefore you can specify false to ensure the operation fails if the Elastic IP address is already associated
         * with another resource.
         * </p>
         * 
         * @param allowReassociation
         *        [EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow an Elastic IP address that is
         *        already associated with an instance or network interface to be reassociated with the specified
         *        instance or network interface. Otherwise, the operation fails. In a VPC in an EC2-VPC-only account,
         *        reassociation is automatic, therefore you can specify false to ensure the operation fails if the
         *        Elastic IP address is already associated with another resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassociation(Boolean allowReassociation);

        /**
         * <p>
         * [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you must
         * specify a network interface ID.
         * </p>
         * <p>
         * For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         * </p>
         * 
         * @param networkInterfaceId
         *        [EC2-VPC] The ID of the network interface. If the instance has more than one network interface, you
         *        must specify a network interface ID.</p>
         *        <p>
         *        For EC2-VPC, you can specify either the instance ID or the network interface ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no private
         * IP address is specified, the Elastic IP address is associated with the primary private IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If no
         *        private IP address is specified, the Elastic IP address is associated with the primary private IP
         *        address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String allocationId;

        private String instanceId;

        private String publicIp;

        private Boolean allowReassociation;

        private String networkInterfaceId;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAddressRequest model) {
            super(model);
            allocationId(model.allocationId);
            instanceId(model.instanceId);
            publicIp(model.publicIp);
            allowReassociation(model.allowReassociation);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Boolean getAllowReassociation() {
            return allowReassociation;
        }

        @Override
        public final Builder allowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
            return this;
        }

        public final void setAllowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAddressRequest build() {
            return new AssociateAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
