/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a header. Reflects any changes made by a component as traffic passes through. The fields of an inbound
 * header are null except for the first component of a path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisPacketHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisPacketHeader.Builder, AnalysisPacketHeader> {
    private static final SdkField<List<String>> DESTINATION_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DestinationAddresses")
            .getter(getter(AnalysisPacketHeader::destinationAddresses))
            .setter(setter(Builder::destinationAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationAddressSet")
                    .unmarshallLocationName("destinationAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PortRange>> DESTINATION_PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("DestinationPortRanges")
            .getter(getter(AnalysisPacketHeader::destinationPortRanges))
            .setter(setter(Builder::destinationPortRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPortRangeSet")
                    .unmarshallLocationName("destinationPortRangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(AnalysisPacketHeader::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<List<String>> SOURCE_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceAddresses")
            .getter(getter(AnalysisPacketHeader::sourceAddresses))
            .setter(setter(Builder::sourceAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAddressSet")
                    .unmarshallLocationName("sourceAddressSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<PortRange>> SOURCE_PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("SourcePortRanges")
            .getter(getter(AnalysisPacketHeader::sourcePortRanges))
            .setter(setter(Builder::sourcePortRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePortRangeSet")
                    .unmarshallLocationName("sourcePortRangeSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ADDRESSES_FIELD,
            DESTINATION_PORT_RANGES_FIELD, PROTOCOL_FIELD, SOURCE_ADDRESSES_FIELD, SOURCE_PORT_RANGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> destinationAddresses;

    private final List<PortRange> destinationPortRanges;

    private final String protocol;

    private final List<String> sourceAddresses;

    private final List<PortRange> sourcePortRanges;

    private AnalysisPacketHeader(BuilderImpl builder) {
        this.destinationAddresses = builder.destinationAddresses;
        this.destinationPortRanges = builder.destinationPortRanges;
        this.protocol = builder.protocol;
        this.sourceAddresses = builder.sourceAddresses;
        this.sourcePortRanges = builder.sourcePortRanges;
    }

    /**
     * Returns true if the DestinationAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationAddresses() {
        return destinationAddresses != null && !(destinationAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination addresses.
     */
    public final List<String> destinationAddresses() {
        return destinationAddresses;
    }

    /**
     * Returns true if the DestinationPortRanges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDestinationPortRanges() {
        return destinationPortRanges != null && !(destinationPortRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The destination port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDestinationPortRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The destination port ranges.
     */
    public final List<PortRange> destinationPortRanges() {
        return destinationPortRanges;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * 
     * @return The protocol.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * Returns true if the SourceAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSourceAddresses() {
        return sourceAddresses != null && !(sourceAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourceAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source addresses.
     */
    public final List<String> sourceAddresses() {
        return sourceAddresses;
    }

    /**
     * Returns true if the SourcePortRanges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSourcePortRanges() {
        return sourcePortRanges != null && !(sourcePortRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source port ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSourcePortRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The source port ranges.
     */
    public final List<PortRange> sourcePortRanges() {
        return sourcePortRanges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationAddresses() ? destinationAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPortRanges() ? destinationPortRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAddresses() ? sourceAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourcePortRanges() ? sourcePortRanges() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisPacketHeader)) {
            return false;
        }
        AnalysisPacketHeader other = (AnalysisPacketHeader) obj;
        return hasDestinationAddresses() == other.hasDestinationAddresses()
                && Objects.equals(destinationAddresses(), other.destinationAddresses())
                && hasDestinationPortRanges() == other.hasDestinationPortRanges()
                && Objects.equals(destinationPortRanges(), other.destinationPortRanges())
                && Objects.equals(protocol(), other.protocol()) && hasSourceAddresses() == other.hasSourceAddresses()
                && Objects.equals(sourceAddresses(), other.sourceAddresses())
                && hasSourcePortRanges() == other.hasSourcePortRanges()
                && Objects.equals(sourcePortRanges(), other.sourcePortRanges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisPacketHeader")
                .add("DestinationAddresses", hasDestinationAddresses() ? destinationAddresses() : null)
                .add("DestinationPortRanges", hasDestinationPortRanges() ? destinationPortRanges() : null)
                .add("Protocol", protocol()).add("SourceAddresses", hasSourceAddresses() ? sourceAddresses() : null)
                .add("SourcePortRanges", hasSourcePortRanges() ? sourcePortRanges() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationAddresses":
            return Optional.ofNullable(clazz.cast(destinationAddresses()));
        case "DestinationPortRanges":
            return Optional.ofNullable(clazz.cast(destinationPortRanges()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "SourceAddresses":
            return Optional.ofNullable(clazz.cast(sourceAddresses()));
        case "SourcePortRanges":
            return Optional.ofNullable(clazz.cast(sourcePortRanges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisPacketHeader, T> g) {
        return obj -> g.apply((AnalysisPacketHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisPacketHeader> {
        /**
         * <p>
         * The destination addresses.
         * </p>
         * 
         * @param destinationAddresses
         *        The destination addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(Collection<String> destinationAddresses);

        /**
         * <p>
         * The destination addresses.
         * </p>
         * 
         * @param destinationAddresses
         *        The destination addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationAddresses(String... destinationAddresses);

        /**
         * <p>
         * The destination port ranges.
         * </p>
         * 
         * @param destinationPortRanges
         *        The destination port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRanges(Collection<PortRange> destinationPortRanges);

        /**
         * <p>
         * The destination port ranges.
         * </p>
         * 
         * @param destinationPortRanges
         *        The destination port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPortRanges(PortRange... destinationPortRanges);

        /**
         * <p>
         * The destination port ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationPortRanges(List<PortRange>)}.
         * 
         * @param destinationPortRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationPortRanges(List<PortRange>)
         */
        Builder destinationPortRanges(Consumer<PortRange.Builder>... destinationPortRanges);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The source addresses.
         * </p>
         * 
         * @param sourceAddresses
         *        The source addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddresses(Collection<String> sourceAddresses);

        /**
         * <p>
         * The source addresses.
         * </p>
         * 
         * @param sourceAddresses
         *        The source addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAddresses(String... sourceAddresses);

        /**
         * <p>
         * The source port ranges.
         * </p>
         * 
         * @param sourcePortRanges
         *        The source port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRanges(Collection<PortRange> sourcePortRanges);

        /**
         * <p>
         * The source port ranges.
         * </p>
         * 
         * @param sourcePortRanges
         *        The source port ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePortRanges(PortRange... sourcePortRanges);

        /**
         * <p>
         * The source port ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #sourcePortRanges(List<PortRange>)}.
         * 
         * @param sourcePortRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourcePortRanges(List<PortRange>)
         */
        Builder sourcePortRanges(Consumer<PortRange.Builder>... sourcePortRanges);
    }

    static final class BuilderImpl implements Builder {
        private List<String> destinationAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<PortRange> destinationPortRanges = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private List<String> sourceAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<PortRange> sourcePortRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisPacketHeader model) {
            destinationAddresses(model.destinationAddresses);
            destinationPortRanges(model.destinationPortRanges);
            protocol(model.protocol);
            sourceAddresses(model.sourceAddresses);
            sourcePortRanges(model.sourcePortRanges);
        }

        public final Collection<String> getDestinationAddresses() {
            if (destinationAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationAddresses;
        }

        @Override
        public final Builder destinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = IpAddressListCopier.copy(destinationAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationAddresses(String... destinationAddresses) {
            destinationAddresses(Arrays.asList(destinationAddresses));
            return this;
        }

        public final void setDestinationAddresses(Collection<String> destinationAddresses) {
            this.destinationAddresses = IpAddressListCopier.copy(destinationAddresses);
        }

        public final Collection<PortRange.Builder> getDestinationPortRanges() {
            if (destinationPortRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPortRanges != null ? destinationPortRanges.stream().map(PortRange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder destinationPortRanges(Collection<PortRange> destinationPortRanges) {
            this.destinationPortRanges = PortRangeListCopier.copy(destinationPortRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortRanges(PortRange... destinationPortRanges) {
            destinationPortRanges(Arrays.asList(destinationPortRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPortRanges(Consumer<PortRange.Builder>... destinationPortRanges) {
            destinationPortRanges(Stream.of(destinationPortRanges).map(c -> PortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDestinationPortRanges(Collection<PortRange.BuilderImpl> destinationPortRanges) {
            this.destinationPortRanges = PortRangeListCopier.copyFromBuilder(destinationPortRanges);
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Collection<String> getSourceAddresses() {
            if (sourceAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceAddresses;
        }

        @Override
        public final Builder sourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = IpAddressListCopier.copy(sourceAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAddresses(String... sourceAddresses) {
            sourceAddresses(Arrays.asList(sourceAddresses));
            return this;
        }

        public final void setSourceAddresses(Collection<String> sourceAddresses) {
            this.sourceAddresses = IpAddressListCopier.copy(sourceAddresses);
        }

        public final Collection<PortRange.Builder> getSourcePortRanges() {
            if (sourcePortRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return sourcePortRanges != null ? sourcePortRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sourcePortRanges(Collection<PortRange> sourcePortRanges) {
            this.sourcePortRanges = PortRangeListCopier.copy(sourcePortRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePortRanges(PortRange... sourcePortRanges) {
            sourcePortRanges(Arrays.asList(sourcePortRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourcePortRanges(Consumer<PortRange.Builder>... sourcePortRanges) {
            sourcePortRanges(Stream.of(sourcePortRanges).map(c -> PortRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSourcePortRanges(Collection<PortRange.BuilderImpl> sourcePortRanges) {
            this.sourcePortRanges = PortRangeListCopier.copyFromBuilder(sourcePortRanges);
        }

        @Override
        public AnalysisPacketHeader build() {
            return new AnalysisPacketHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
