/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a load balancer target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisLoadBalancerTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisLoadBalancerTarget.Builder, AnalysisLoadBalancerTarget> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Address")
            .getter(getter(AnalysisLoadBalancerTarget::address))
            .setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address")
                    .unmarshallLocationName("address").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(AnalysisLoadBalancerTarget::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<AnalysisComponent> INSTANCE_FIELD = SdkField
            .<AnalysisComponent> builder(MarshallingType.SDK_POJO)
            .memberName("Instance")
            .getter(getter(AnalysisLoadBalancerTarget::instance))
            .setter(setter(Builder::instance))
            .constructor(AnalysisComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance")
                    .unmarshallLocationName("instance").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Port")
            .getter(getter(AnalysisLoadBalancerTarget::port))
            .setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port")
                    .unmarshallLocationName("port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            AVAILABILITY_ZONE_FIELD, INSTANCE_FIELD, PORT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final String availabilityZone;

    private final AnalysisComponent instance;

    private final Integer port;

    private AnalysisLoadBalancerTarget(BuilderImpl builder) {
        this.address = builder.address;
        this.availabilityZone = builder.availabilityZone;
        this.instance = builder.instance;
        this.port = builder.port;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Information about the instance.
     * </p>
     * 
     * @return Information about the instance.
     */
    public final AnalysisComponent instance() {
        return instance;
    }

    /**
     * <p>
     * The port on which the target is listening.
     * </p>
     * 
     * @return The port on which the target is listening.
     */
    public final Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisLoadBalancerTarget)) {
            return false;
        }
        AnalysisLoadBalancerTarget other = (AnalysisLoadBalancerTarget) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instance(), other.instance()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisLoadBalancerTarget").add("Address", address())
                .add("AvailabilityZone", availabilityZone()).add("Instance", instance()).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisLoadBalancerTarget, T> g) {
        return obj -> g.apply((AnalysisLoadBalancerTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisLoadBalancerTarget> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param address
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Information about the instance.
         * </p>
         * 
         * @param instance
         *        Information about the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(AnalysisComponent instance);

        /**
         * <p>
         * Information about the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link AnalysisComponent.Builder} avoiding the need to
         * create one manually via {@link AnalysisComponent#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnalysisComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #instance(AnalysisComponent)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link AnalysisComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(AnalysisComponent)
         */
        default Builder instance(Consumer<AnalysisComponent.Builder> instance) {
            return instance(AnalysisComponent.builder().applyMutation(instance).build());
        }

        /**
         * <p>
         * The port on which the target is listening.
         * </p>
         * 
         * @param port
         *        The port on which the target is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private String availabilityZone;

        private AnalysisComponent instance;

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisLoadBalancerTarget model) {
            address(model.address);
            availabilityZone(model.availabilityZone);
            instance(model.instance);
            port(model.port);
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AnalysisComponent.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        @Override
        public final Builder instance(AnalysisComponent instance) {
            this.instance = instance;
            return this;
        }

        public final void setInstance(AnalysisComponent.BuilderImpl instance) {
            this.instance = instance != null ? instance.build() : null;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public AnalysisLoadBalancerTarget build() {
            return new AnalysisLoadBalancerTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
