/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic IP address, or a carrier IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceId")
            .getter(getter(Address::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId")
                    .unmarshallLocationName("instanceId").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIp")
            .getter(getter(Address::publicIp))
            .setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp")
                    .unmarshallLocationName("publicIp").build()).build();

    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AllocationId")
            .getter(getter(Address::allocationId))
            .setter(setter(Builder::allocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId")
                    .unmarshallLocationName("allocationId").build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationId")
            .getter(getter(Address::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId")
                    .unmarshallLocationName("associationId").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Domain")
            .getter(getter(Address::domainAsString))
            .setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain")
                    .unmarshallLocationName("domain").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(Address::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId")
                    .unmarshallLocationName("networkInterfaceId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceOwnerId")
            .getter(getter(Address::networkInterfaceOwnerId))
            .setter(setter(Builder::networkInterfaceOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOwnerId")
                    .unmarshallLocationName("networkInterfaceOwnerId").build()).build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress")
            .getter(getter(Address::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress")
                    .unmarshallLocationName("privateIpAddress").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Address::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicIpv4Pool")
            .getter(getter(Address::publicIpv4Pool))
            .setter(setter(Builder::publicIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool")
                    .unmarshallLocationName("publicIpv4Pool").build()).build();

    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkBorderGroup")
            .getter(getter(Address::networkBorderGroup))
            .setter(setter(Builder::networkBorderGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup")
                    .unmarshallLocationName("networkBorderGroup").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIp")
            .getter(getter(Address::customerOwnedIp))
            .setter(setter(Builder::customerOwnedIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp")
                    .unmarshallLocationName("customerOwnedIp").build()).build();

    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CustomerOwnedIpv4Pool")
            .getter(getter(Address::customerOwnedIpv4Pool))
            .setter(setter(Builder::customerOwnedIpv4Pool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool")
                    .unmarshallLocationName("customerOwnedIpv4Pool").build()).build();

    private static final SdkField<String> CARRIER_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CarrierIp")
            .getter(getter(Address::carrierIp))
            .setter(setter(Builder::carrierIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp")
                    .unmarshallLocationName("carrierIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, ASSOCIATION_ID_FIELD, DOMAIN_FIELD, NETWORK_INTERFACE_ID_FIELD,
            NETWORK_INTERFACE_OWNER_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, TAGS_FIELD, PUBLIC_IPV4_POOL_FIELD,
            NETWORK_BORDER_GROUP_FIELD, CUSTOMER_OWNED_IP_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, CARRIER_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String publicIp;

    private final String allocationId;

    private final String associationId;

    private final String domain;

    private final String networkInterfaceId;

    private final String networkInterfaceOwnerId;

    private final String privateIpAddress;

    private final List<Tag> tags;

    private final String publicIpv4Pool;

    private final String networkBorderGroup;

    private final String customerOwnedIp;

    private final String customerOwnedIpv4Pool;

    private final String carrierIp;

    private Address(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
        this.tags = builder.tags;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.carrierIp = builder.carrierIp;
    }

    /**
     * <p>
     * The ID of the instance that the address is associated with (if any).
     * </p>
     * 
     * @return The ID of the instance that the address is associated with (if any).
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The ID representing the allocation of the address for use with EC2-VPC.
     * </p>
     * 
     * @return The ID representing the allocation of the address for use with EC2-VPC.
     */
    public final String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID representing the association of the address with an instance in a VPC.
     * </p>
     * 
     * @return The ID representing the association of the address with an instance in a VPC.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public final DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public final String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the network interface.
     * </p>
     * 
     * @return The ID of the AWS account that owns the network interface.
     */
    public final String networkInterfaceOwnerId() {
        return networkInterfaceOwnerId;
    }

    /**
     * <p>
     * The private IP address associated with the Elastic IP address.
     * </p>
     * 
     * @return The private IP address associated with the Elastic IP address.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags assigned to the Elastic IP address.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags assigned to the Elastic IP address.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of an address pool.
     * </p>
     * 
     * @return The ID of an address pool.
     */
    public final String publicIpv4Pool() {
        return publicIpv4Pool;
    }

    /**
     * <p>
     * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises IP
     * addresses.
     * </p>
     * 
     * @return The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS
     *         advertises IP addresses.
     */
    public final String networkBorderGroup() {
        return networkBorderGroup;
    }

    /**
     * <p>
     * The customer-owned IP address.
     * </p>
     * 
     * @return The customer-owned IP address.
     */
    public final String customerOwnedIp() {
        return customerOwnedIp;
    }

    /**
     * <p>
     * The ID of the customer-owned address pool.
     * </p>
     * 
     * @return The ID of the customer-owned address pool.
     */
    public final String customerOwnedIpv4Pool() {
        return customerOwnedIpv4Pool;
    }

    /**
     * <p>
     * The carrier IP address associated. This option is only available for network interfaces which reside in a subnet
     * in a Wavelength Zone (for example an EC2 instance).
     * </p>
     * 
     * @return The carrier IP address associated. This option is only available for network interfaces which reside in a
     *         subnet in a Wavelength Zone (for example an EC2 instance).
     */
    public final String carrierIp() {
        return carrierIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(carrierIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(allocationId(), other.allocationId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(domainAsString(), other.domainAsString())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(networkInterfaceOwnerId(), other.networkInterfaceOwnerId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(publicIpv4Pool(), other.publicIpv4Pool())
                && Objects.equals(networkBorderGroup(), other.networkBorderGroup())
                && Objects.equals(customerOwnedIp(), other.customerOwnedIp())
                && Objects.equals(customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool())
                && Objects.equals(carrierIp(), other.carrierIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("InstanceId", instanceId()).add("PublicIp", publicIp())
                .add("AllocationId", allocationId()).add("AssociationId", associationId()).add("Domain", domainAsString())
                .add("NetworkInterfaceId", networkInterfaceId()).add("NetworkInterfaceOwnerId", networkInterfaceOwnerId())
                .add("PrivateIpAddress", privateIpAddress()).add("Tags", hasTags() ? tags() : null)
                .add("PublicIpv4Pool", publicIpv4Pool()).add("NetworkBorderGroup", networkBorderGroup())
                .add("CustomerOwnedIp", customerOwnedIp()).add("CustomerOwnedIpv4Pool", customerOwnedIpv4Pool())
                .add("CarrierIp", carrierIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "AllocationId":
            return Optional.ofNullable(clazz.cast(allocationId()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domainAsString()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "NetworkInterfaceOwnerId":
            return Optional.ofNullable(clazz.cast(networkInterfaceOwnerId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "PublicIpv4Pool":
            return Optional.ofNullable(clazz.cast(publicIpv4Pool()));
        case "NetworkBorderGroup":
            return Optional.ofNullable(clazz.cast(networkBorderGroup()));
        case "CustomerOwnedIp":
            return Optional.ofNullable(clazz.cast(customerOwnedIp()));
        case "CustomerOwnedIpv4Pool":
            return Optional.ofNullable(clazz.cast(customerOwnedIpv4Pool()));
        case "CarrierIp":
            return Optional.ofNullable(clazz.cast(carrierIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The ID of the instance that the address is associated with (if any).
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that the address is associated with (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The ID representing the allocation of the address for use with EC2-VPC.
         * </p>
         * 
         * @param allocationId
         *        The ID representing the allocation of the address for use with EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID representing the association of the address with an instance in a VPC.
         * </p>
         * 
         * @param associationId
         *        The ID representing the association of the address with an instance in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the AWS account that owns the network interface.
         * </p>
         * 
         * @param networkInterfaceOwnerId
         *        The ID of the AWS account that owns the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceOwnerId(String networkInterfaceOwnerId);

        /**
         * <p>
         * The private IP address associated with the Elastic IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address associated with the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * Any tags assigned to the Elastic IP address.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the Elastic IP address.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the Elastic IP address.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of an address pool.
         * </p>
         * 
         * @param publicIpv4Pool
         *        The ID of an address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIpv4Pool(String publicIpv4Pool);

        /**
         * <p>
         * The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS advertises
         * IP addresses.
         * </p>
         * 
         * @param networkBorderGroup
         *        The name of the unique set of Availability Zones, Local Zones, or Wavelength Zones from which AWS
         *        advertises IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkBorderGroup(String networkBorderGroup);

        /**
         * <p>
         * The customer-owned IP address.
         * </p>
         * 
         * @param customerOwnedIp
         *        The customer-owned IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIp(String customerOwnedIp);

        /**
         * <p>
         * The ID of the customer-owned address pool.
         * </p>
         * 
         * @param customerOwnedIpv4Pool
         *        The ID of the customer-owned address pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool);

        /**
         * <p>
         * The carrier IP address associated. This option is only available for network interfaces which reside in a
         * subnet in a Wavelength Zone (for example an EC2 instance).
         * </p>
         * 
         * @param carrierIp
         *        The carrier IP address associated. This option is only available for network interfaces which reside
         *        in a subnet in a Wavelength Zone (for example an EC2 instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carrierIp(String carrierIp);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String publicIp;

        private String allocationId;

        private String associationId;

        private String domain;

        private String networkInterfaceId;

        private String networkInterfaceOwnerId;

        private String privateIpAddress;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String publicIpv4Pool;

        private String networkBorderGroup;

        private String customerOwnedIp;

        private String customerOwnedIpv4Pool;

        private String carrierIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            instanceId(model.instanceId);
            publicIp(model.publicIp);
            allocationId(model.allocationId);
            associationId(model.associationId);
            domain(model.domain);
            networkInterfaceId(model.networkInterfaceId);
            networkInterfaceOwnerId(model.networkInterfaceOwnerId);
            privateIpAddress(model.privateIpAddress);
            tags(model.tags);
            publicIpv4Pool(model.publicIpv4Pool);
            networkBorderGroup(model.networkBorderGroup);
            customerOwnedIp(model.customerOwnedIp);
            customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            carrierIp(model.carrierIp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getNetworkInterfaceOwnerId() {
            return networkInterfaceOwnerId;
        }

        @Override
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getPublicIpv4Pool() {
            return publicIpv4Pool;
        }

        @Override
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        public final String getNetworkBorderGroup() {
            return networkBorderGroup;
        }

        @Override
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        public final String getCustomerOwnedIp() {
            return customerOwnedIp;
        }

        @Override
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        public final String getCarrierIp() {
            return carrierIp;
        }

        @Override
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
