/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo;
import software.amazon.awssdk.services.ec2.model.FpgaDeviceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FpgaInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FpgaInfo> {
    private static final SdkField<List<FpgaDeviceInfo>> FPGAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Fpgas").getter(FpgaInfo.getter(FpgaInfo::fpgas)).setter(FpgaInfo.setter(Builder::fpgas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fpgas").unmarshallLocationName("fpgas").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FpgaDeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_FPGA_MEMORY_IN_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalFpgaMemoryInMiB").getter(FpgaInfo.getter(FpgaInfo::totalFpgaMemoryInMiB)).setter(FpgaInfo.setter(Builder::totalFpgaMemoryInMiB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFpgaMemoryInMiB").unmarshallLocationName("totalFpgaMemoryInMiB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FPGAS_FIELD, TOTAL_FPGA_MEMORY_IN_MIB_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FpgaDeviceInfo> fpgas;
    private final Integer totalFpgaMemoryInMiB;

    private FpgaInfo(BuilderImpl builder) {
        this.fpgas = builder.fpgas;
        this.totalFpgaMemoryInMiB = builder.totalFpgaMemoryInMiB;
    }

    public final boolean hasFpgas() {
        return this.fpgas != null && !(this.fpgas instanceof SdkAutoConstructList);
    }

    public final List<FpgaDeviceInfo> fpgas() {
        return this.fpgas;
    }

    public final Integer totalFpgaMemoryInMiB() {
        return this.totalFpgaMemoryInMiB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFpgas() ? this.fpgas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFpgaMemoryInMiB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaInfo)) {
            return false;
        }
        FpgaInfo other = (FpgaInfo)obj;
        return this.hasFpgas() == other.hasFpgas() && Objects.equals(this.fpgas(), other.fpgas()) && Objects.equals(this.totalFpgaMemoryInMiB(), other.totalFpgaMemoryInMiB());
    }

    public final String toString() {
        return ToString.builder((String)"FpgaInfo").add("Fpgas", this.hasFpgas() ? this.fpgas() : null).add("TotalFpgaMemoryInMiB", (Object)this.totalFpgaMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fpgas": {
                return Optional.ofNullable(clazz.cast(this.fpgas()));
            }
            case "TotalFpgaMemoryInMiB": {
                return Optional.ofNullable(clazz.cast(this.totalFpgaMemoryInMiB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FpgaInfo, T> g) {
        return obj -> g.apply((FpgaInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FpgaDeviceInfo> fpgas = DefaultSdkAutoConstructList.getInstance();
        private Integer totalFpgaMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaInfo model) {
            this.fpgas(model.fpgas);
            this.totalFpgaMemoryInMiB(model.totalFpgaMemoryInMiB);
        }

        public final Collection<FpgaDeviceInfo.Builder> getFpgas() {
            if (this.fpgas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.fpgas != null ? (Collection)this.fpgas.stream().map(FpgaDeviceInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fpgas(Collection<FpgaDeviceInfo> fpgas) {
            this.fpgas = FpgaDeviceInfoListCopier.copy(fpgas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgas(FpgaDeviceInfo ... fpgas) {
            this.fpgas(Arrays.asList(fpgas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgas(Consumer<FpgaDeviceInfo.Builder> ... fpgas) {
            this.fpgas(Stream.of(fpgas).map(c -> (FpgaDeviceInfo)((FpgaDeviceInfo.Builder)FpgaDeviceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFpgas(Collection<FpgaDeviceInfo.BuilderImpl> fpgas) {
            this.fpgas = FpgaDeviceInfoListCopier.copyFromBuilder(fpgas);
        }

        public final Integer getTotalFpgaMemoryInMiB() {
            return this.totalFpgaMemoryInMiB;
        }

        @Override
        public final Builder totalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
            this.totalFpgaMemoryInMiB = totalFpgaMemoryInMiB;
            return this;
        }

        public final void setTotalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
            this.totalFpgaMemoryInMiB = totalFpgaMemoryInMiB;
        }

        public FpgaInfo build() {
            return new FpgaInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FpgaInfo> {
        public Builder fpgas(Collection<FpgaDeviceInfo> var1);

        public Builder fpgas(FpgaDeviceInfo ... var1);

        public Builder fpgas(Consumer<FpgaDeviceInfo.Builder> ... var1);

        public Builder totalFpgaMemoryInMiB(Integer var1);
    }
}

