/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientVpnRoute;
import software.amazon.awssdk.services.ec2.model.ClientVpnRouteSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientVpnRoutesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeClientVpnRoutesResponse> {
    private static final SdkField<List<ClientVpnRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(DescribeClientVpnRoutesResponse.getter(DescribeClientVpnRoutesResponse::routes)).setter(DescribeClientVpnRoutesResponse.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").unmarshallLocationName("routes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpnRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientVpnRoutesResponse.getter(DescribeClientVpnRoutesResponse::nextToken)).setter(DescribeClientVpnRoutesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClientVpnRoute> routes;
    private final String nextToken;

    private DescribeClientVpnRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.routes = builder.routes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<ClientVpnRoute> routes() {
        return this.routes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnRoutesResponse)) {
            return false;
        }
        DescribeClientVpnRoutesResponse other = (DescribeClientVpnRoutesResponse)((Object)obj);
        return this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientVpnRoutesResponse").add("Routes", this.hasRoutes() ? this.routes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnRoutesResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnRoutesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ClientVpnRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnRoutesResponse model) {
            super(model);
            this.routes(model.routes);
            this.nextToken(model.nextToken);
        }

        public final Collection<ClientVpnRoute.Builder> getRoutes() {
            if (this.routes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.routes != null ? (Collection)this.routes.stream().map(ClientVpnRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<ClientVpnRoute> routes) {
            this.routes = ClientVpnRouteSetCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(ClientVpnRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<ClientVpnRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (ClientVpnRoute)((ClientVpnRoute.Builder)ClientVpnRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<ClientVpnRoute.BuilderImpl> routes) {
            this.routes = ClientVpnRouteSetCopier.copyFromBuilder(routes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClientVpnRoutesResponse build() {
            return new DescribeClientVpnRoutesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientVpnRoutesResponse> {
        public Builder routes(Collection<ClientVpnRoute> var1);

        public Builder routes(ClientVpnRoute ... var1);

        public Builder routes(Consumer<ClientVpnRoute.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

