/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectivityType;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddress;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NatGatewayState;
import software.amazon.awssdk.services.ec2.model.ProvisionedBandwidth;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NatGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NatGateway> {
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(NatGateway.getter(NatGateway::createTime)).setter(NatGateway.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTime").getter(NatGateway.getter(NatGateway::deleteTime)).setter(NatGateway.setter(Builder::deleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").unmarshallLocationName("deleteTime").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(NatGateway.getter(NatGateway::failureCode)).setter(NatGateway.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").unmarshallLocationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(NatGateway.getter(NatGateway::failureMessage)).setter(NatGateway.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").unmarshallLocationName("failureMessage").build()}).build();
    private static final SdkField<List<NatGatewayAddress>> NAT_GATEWAY_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NatGatewayAddresses").getter(NatGateway.getter(NatGateway::natGatewayAddresses)).setter(NatGateway.setter(Builder::natGatewayAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayAddressSet").unmarshallLocationName("natGatewayAddressSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NatGatewayAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NAT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NatGatewayId").getter(NatGateway.getter(NatGateway::natGatewayId)).setter(NatGateway.setter(Builder::natGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("natGatewayId").build()}).build();
    private static final SdkField<ProvisionedBandwidth> PROVISIONED_BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedBandwidth").getter(NatGateway.getter(NatGateway::provisionedBandwidth)).setter(NatGateway.setter(Builder::provisionedBandwidth)).constructor(ProvisionedBandwidth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedBandwidth").unmarshallLocationName("provisionedBandwidth").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(NatGateway.getter(NatGateway::stateAsString)).setter(NatGateway.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(NatGateway.getter(NatGateway::subnetId)).setter(NatGateway.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(NatGateway.getter(NatGateway::vpcId)).setter(NatGateway.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(NatGateway.getter(NatGateway::tags)).setter(NatGateway.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTIVITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectivityType").getter(NatGateway.getter(NatGateway::connectivityTypeAsString)).setter(NatGateway.setter(Builder::connectivityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectivityType").unmarshallLocationName("connectivityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_TIME_FIELD, DELETE_TIME_FIELD, FAILURE_CODE_FIELD, FAILURE_MESSAGE_FIELD, NAT_GATEWAY_ADDRESSES_FIELD, NAT_GATEWAY_ID_FIELD, PROVISIONED_BANDWIDTH_FIELD, STATE_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, TAGS_FIELD, CONNECTIVITY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createTime;
    private final Instant deleteTime;
    private final String failureCode;
    private final String failureMessage;
    private final List<NatGatewayAddress> natGatewayAddresses;
    private final String natGatewayId;
    private final ProvisionedBandwidth provisionedBandwidth;
    private final String state;
    private final String subnetId;
    private final String vpcId;
    private final List<Tag> tags;
    private final String connectivityType;

    private NatGateway(BuilderImpl builder) {
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.natGatewayAddresses = builder.natGatewayAddresses;
        this.natGatewayId = builder.natGatewayId;
        this.provisionedBandwidth = builder.provisionedBandwidth;
        this.state = builder.state;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.tags = builder.tags;
        this.connectivityType = builder.connectivityType;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant deleteTime() {
        return this.deleteTime;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasNatGatewayAddresses() {
        return this.natGatewayAddresses != null && !(this.natGatewayAddresses instanceof SdkAutoConstructList);
    }

    public final List<NatGatewayAddress> natGatewayAddresses() {
        return this.natGatewayAddresses;
    }

    public final String natGatewayId() {
        return this.natGatewayId;
    }

    public final ProvisionedBandwidth provisionedBandwidth() {
        return this.provisionedBandwidth;
    }

    public final NatGatewayState state() {
        return NatGatewayState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ConnectivityType connectivityType() {
        return ConnectivityType.fromValue(this.connectivityType);
    }

    public final String connectivityTypeAsString() {
        return this.connectivityType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNatGatewayAddresses() ? this.natGatewayAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectivityTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGateway)) {
            return false;
        }
        NatGateway other = (NatGateway)obj;
        return Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deleteTime(), other.deleteTime()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasNatGatewayAddresses() == other.hasNatGatewayAddresses() && Objects.equals(this.natGatewayAddresses(), other.natGatewayAddresses()) && Objects.equals(this.natGatewayId(), other.natGatewayId()) && Objects.equals(this.provisionedBandwidth(), other.provisionedBandwidth()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.connectivityTypeAsString(), other.connectivityTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NatGateway").add("CreateTime", (Object)this.createTime()).add("DeleteTime", (Object)this.deleteTime()).add("FailureCode", (Object)this.failureCode()).add("FailureMessage", (Object)this.failureMessage()).add("NatGatewayAddresses", this.hasNatGatewayAddresses() ? this.natGatewayAddresses() : null).add("NatGatewayId", (Object)this.natGatewayId()).add("ProvisionedBandwidth", (Object)this.provisionedBandwidth()).add("State", (Object)this.stateAsString()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("Tags", this.hasTags() ? this.tags() : null).add("ConnectivityType", (Object)this.connectivityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeleteTime": {
                return Optional.ofNullable(clazz.cast(this.deleteTime()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "NatGatewayAddresses": {
                return Optional.ofNullable(clazz.cast(this.natGatewayAddresses()));
            }
            case "NatGatewayId": {
                return Optional.ofNullable(clazz.cast(this.natGatewayId()));
            }
            case "ProvisionedBandwidth": {
                return Optional.ofNullable(clazz.cast(this.provisionedBandwidth()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConnectivityType": {
                return Optional.ofNullable(clazz.cast(this.connectivityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NatGateway, T> g) {
        return obj -> g.apply((NatGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createTime;
        private Instant deleteTime;
        private String failureCode;
        private String failureMessage;
        private List<NatGatewayAddress> natGatewayAddresses = DefaultSdkAutoConstructList.getInstance();
        private String natGatewayId;
        private ProvisionedBandwidth provisionedBandwidth;
        private String state;
        private String subnetId;
        private String vpcId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String connectivityType;

        private BuilderImpl() {
        }

        private BuilderImpl(NatGateway model) {
            this.createTime(model.createTime);
            this.deleteTime(model.deleteTime);
            this.failureCode(model.failureCode);
            this.failureMessage(model.failureMessage);
            this.natGatewayAddresses(model.natGatewayAddresses);
            this.natGatewayId(model.natGatewayId);
            this.provisionedBandwidth(model.provisionedBandwidth);
            this.state(model.state);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.tags(model.tags);
            this.connectivityType(model.connectivityType);
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final List<NatGatewayAddress.Builder> getNatGatewayAddresses() {
            List<NatGatewayAddress.Builder> result = NatGatewayAddressListCopier.copyToBuilder(this.natGatewayAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder natGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copy(natGatewayAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(NatGatewayAddress ... natGatewayAddresses) {
            this.natGatewayAddresses(Arrays.asList(natGatewayAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... natGatewayAddresses) {
            this.natGatewayAddresses(Stream.of(natGatewayAddresses).map(c -> (NatGatewayAddress)((NatGatewayAddress.Builder)NatGatewayAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNatGatewayAddresses(Collection<NatGatewayAddress.BuilderImpl> natGatewayAddresses) {
            this.natGatewayAddresses = NatGatewayAddressListCopier.copyFromBuilder(natGatewayAddresses);
        }

        public final String getNatGatewayId() {
            return this.natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final ProvisionedBandwidth.Builder getProvisionedBandwidth() {
            return this.provisionedBandwidth != null ? this.provisionedBandwidth.toBuilder() : null;
        }

        @Override
        public final Builder provisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth;
            return this;
        }

        public final void setProvisionedBandwidth(ProvisionedBandwidth.BuilderImpl provisionedBandwidth) {
            this.provisionedBandwidth = provisionedBandwidth != null ? provisionedBandwidth.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NatGatewayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getConnectivityType() {
            return this.connectivityType;
        }

        @Override
        public final Builder connectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
            return this;
        }

        @Override
        public final Builder connectivityType(ConnectivityType connectivityType) {
            this.connectivityType(connectivityType == null ? null : connectivityType.toString());
            return this;
        }

        public final void setConnectivityType(String connectivityType) {
            this.connectivityType = connectivityType;
        }

        public NatGateway build() {
            return new NatGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NatGateway> {
        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder failureCode(String var1);

        public Builder failureMessage(String var1);

        public Builder natGatewayAddresses(Collection<NatGatewayAddress> var1);

        public Builder natGatewayAddresses(NatGatewayAddress ... var1);

        public Builder natGatewayAddresses(Consumer<NatGatewayAddress.Builder> ... var1);

        public Builder natGatewayId(String var1);

        public Builder provisionedBandwidth(ProvisionedBandwidth var1);

        default public Builder provisionedBandwidth(Consumer<ProvisionedBandwidth.Builder> provisionedBandwidth) {
            return this.provisionedBandwidth((ProvisionedBandwidth)((ProvisionedBandwidth.Builder)ProvisionedBandwidth.builder().applyMutation(provisionedBandwidth)).build());
        }

        public Builder state(String var1);

        public Builder state(NatGatewayState var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder connectivityType(String var1);

        public Builder connectivityType(ConnectivityType var1);
    }
}

