/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetExcessCapacityTerminationPolicy;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigListRequestCopier;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateConfigRequest;
import software.amazon.awssdk.services.ec2.model.TargetCapacitySpecificationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyFleetRequest> {
    private static final SdkField<String> EXCESS_CAPACITY_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExcessCapacityTerminationPolicy").getter(ModifyFleetRequest.getter(ModifyFleetRequest::excessCapacityTerminationPolicyAsString)).setter(ModifyFleetRequest.setter(Builder::excessCapacityTerminationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcessCapacityTerminationPolicy").unmarshallLocationName("ExcessCapacityTerminationPolicy").build()}).build();
    private static final SdkField<List<FleetLaunchTemplateConfigRequest>> LAUNCH_TEMPLATE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchTemplateConfigs").getter(ModifyFleetRequest.getter(ModifyFleetRequest::launchTemplateConfigs)).setter(ModifyFleetRequest.setter(Builder::launchTemplateConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateConfig").unmarshallLocationName("LaunchTemplateConfig").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetLaunchTemplateConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(ModifyFleetRequest.getter(ModifyFleetRequest::fleetId)).setter(ModifyFleetRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").unmarshallLocationName("FleetId").build()}).build();
    private static final SdkField<TargetCapacitySpecificationRequest> TARGET_CAPACITY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetCapacitySpecification").getter(ModifyFleetRequest.getter(ModifyFleetRequest::targetCapacitySpecification)).setter(ModifyFleetRequest.setter(Builder::targetCapacitySpecification)).constructor(TargetCapacitySpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCapacitySpecification").unmarshallLocationName("TargetCapacitySpecification").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(ModifyFleetRequest.getter(ModifyFleetRequest::context)).setter(ModifyFleetRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").unmarshallLocationName("Context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCESS_CAPACITY_TERMINATION_POLICY_FIELD, LAUNCH_TEMPLATE_CONFIGS_FIELD, FLEET_ID_FIELD, TARGET_CAPACITY_SPECIFICATION_FIELD, CONTEXT_FIELD));
    private final String excessCapacityTerminationPolicy;
    private final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs;
    private final String fleetId;
    private final TargetCapacitySpecificationRequest targetCapacitySpecification;
    private final String context;

    private ModifyFleetRequest(BuilderImpl builder) {
        super(builder);
        this.excessCapacityTerminationPolicy = builder.excessCapacityTerminationPolicy;
        this.launchTemplateConfigs = builder.launchTemplateConfigs;
        this.fleetId = builder.fleetId;
        this.targetCapacitySpecification = builder.targetCapacitySpecification;
        this.context = builder.context;
    }

    public final FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy() {
        return FleetExcessCapacityTerminationPolicy.fromValue(this.excessCapacityTerminationPolicy);
    }

    public final String excessCapacityTerminationPolicyAsString() {
        return this.excessCapacityTerminationPolicy;
    }

    public final boolean hasLaunchTemplateConfigs() {
        return this.launchTemplateConfigs != null && !(this.launchTemplateConfigs instanceof SdkAutoConstructList);
    }

    public final List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs() {
        return this.launchTemplateConfigs;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final TargetCapacitySpecificationRequest targetCapacitySpecification() {
        return this.targetCapacitySpecification;
    }

    public final String context() {
        return this.context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.excessCapacityTerminationPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCapacitySpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyFleetRequest)) {
            return false;
        }
        ModifyFleetRequest other = (ModifyFleetRequest)((Object)obj);
        return Objects.equals(this.excessCapacityTerminationPolicyAsString(), other.excessCapacityTerminationPolicyAsString()) && this.hasLaunchTemplateConfigs() == other.hasLaunchTemplateConfigs() && Objects.equals(this.launchTemplateConfigs(), other.launchTemplateConfigs()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.targetCapacitySpecification(), other.targetCapacitySpecification()) && Objects.equals(this.context(), other.context());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyFleetRequest").add("ExcessCapacityTerminationPolicy", (Object)this.excessCapacityTerminationPolicyAsString()).add("LaunchTemplateConfigs", this.hasLaunchTemplateConfigs() ? this.launchTemplateConfigs() : null).add("FleetId", (Object)this.fleetId()).add("TargetCapacitySpecification", (Object)this.targetCapacitySpecification()).add("Context", (Object)this.context()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExcessCapacityTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.excessCapacityTerminationPolicyAsString()));
            }
            case "LaunchTemplateConfigs": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateConfigs()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "TargetCapacitySpecification": {
                return Optional.ofNullable(clazz.cast(this.targetCapacitySpecification()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyFleetRequest, T> g) {
        return obj -> g.apply((ModifyFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String excessCapacityTerminationPolicy;
        private List<FleetLaunchTemplateConfigRequest> launchTemplateConfigs = DefaultSdkAutoConstructList.getInstance();
        private String fleetId;
        private TargetCapacitySpecificationRequest targetCapacitySpecification;
        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyFleetRequest model) {
            super(model);
            this.excessCapacityTerminationPolicy(model.excessCapacityTerminationPolicy);
            this.launchTemplateConfigs(model.launchTemplateConfigs);
            this.fleetId(model.fleetId);
            this.targetCapacitySpecification(model.targetCapacitySpecification);
            this.context(model.context);
        }

        public final String getExcessCapacityTerminationPolicy() {
            return this.excessCapacityTerminationPolicy;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
            return this;
        }

        @Override
        public final Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy(excessCapacityTerminationPolicy == null ? null : excessCapacityTerminationPolicy.toString());
            return this;
        }

        public final void setExcessCapacityTerminationPolicy(String excessCapacityTerminationPolicy) {
            this.excessCapacityTerminationPolicy = excessCapacityTerminationPolicy;
        }

        public final List<FleetLaunchTemplateConfigRequest.Builder> getLaunchTemplateConfigs() {
            List<FleetLaunchTemplateConfigRequest.Builder> result = FleetLaunchTemplateConfigListRequestCopier.copyToBuilder(this.launchTemplateConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copy(launchTemplateConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Arrays.asList(launchTemplateConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder> ... launchTemplateConfigs) {
            this.launchTemplateConfigs(Stream.of(launchTemplateConfigs).map(c -> (FleetLaunchTemplateConfigRequest)((FleetLaunchTemplateConfigRequest.Builder)FleetLaunchTemplateConfigRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest.BuilderImpl> launchTemplateConfigs) {
            this.launchTemplateConfigs = FleetLaunchTemplateConfigListRequestCopier.copyFromBuilder(launchTemplateConfigs);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final TargetCapacitySpecificationRequest.Builder getTargetCapacitySpecification() {
            return this.targetCapacitySpecification != null ? this.targetCapacitySpecification.toBuilder() : null;
        }

        @Override
        public final Builder targetCapacitySpecification(TargetCapacitySpecificationRequest targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification;
            return this;
        }

        public final void setTargetCapacitySpecification(TargetCapacitySpecificationRequest.BuilderImpl targetCapacitySpecification) {
            this.targetCapacitySpecification = targetCapacitySpecification != null ? targetCapacitySpecification.build() : null;
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyFleetRequest build() {
            return new ModifyFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyFleetRequest> {
        public Builder excessCapacityTerminationPolicy(String var1);

        public Builder excessCapacityTerminationPolicy(FleetExcessCapacityTerminationPolicy var1);

        public Builder launchTemplateConfigs(Collection<FleetLaunchTemplateConfigRequest> var1);

        public Builder launchTemplateConfigs(FleetLaunchTemplateConfigRequest ... var1);

        public Builder launchTemplateConfigs(Consumer<FleetLaunchTemplateConfigRequest.Builder> ... var1);

        public Builder fleetId(String var1);

        public Builder targetCapacitySpecification(TargetCapacitySpecificationRequest var1);

        default public Builder targetCapacitySpecification(Consumer<TargetCapacitySpecificationRequest.Builder> targetCapacitySpecification) {
            return this.targetCapacitySpecification((TargetCapacitySpecificationRequest)((TargetCapacitySpecificationRequest.Builder)TargetCapacitySpecificationRequest.builder().applyMutation(targetCapacitySpecification)).build());
        }

        public Builder context(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

