/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSubnetsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSubnetsResponse> {
    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(DescribeSubnetsResponse.getter(DescribeSubnetsResponse::subnets)).setter(DescribeSubnetsResponse.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetSet").unmarshallLocationName("subnetSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeSubnetsResponse.getter(DescribeSubnetsResponse::nextToken)).setter(DescribeSubnetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNETS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Subnet> subnets;
    private final String nextToken;

    private DescribeSubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.subnets = builder.subnets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<Subnet> subnets() {
        return this.subnets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsResponse)) {
            return false;
        }
        DescribeSubnetsResponse other = (DescribeSubnetsResponse)((Object)obj);
        return this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSubnetsResponse").add("Subnets", this.hasSubnets() ? this.subnets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSubnetsResponse, T> g) {
        return obj -> g.apply((DescribeSubnetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsResponse model) {
            super(model);
            this.subnets(model.subnets);
            this.nextToken(model.nextToken);
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSubnetsResponse build() {
            return new DescribeSubnetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSubnetsResponse> {
        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

