/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroupSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStaleSecurityGroupsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStaleSecurityGroupsResponse.getter(DescribeStaleSecurityGroupsResponse::nextToken)).setter(DescribeStaleSecurityGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<StaleSecurityGroup>> STALE_SECURITY_GROUP_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaleSecurityGroupSet").getter(DescribeStaleSecurityGroupsResponse.getter(DescribeStaleSecurityGroupsResponse::staleSecurityGroupSet)).setter(DescribeStaleSecurityGroupsResponse.setter(Builder::staleSecurityGroupSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaleSecurityGroupSet").unmarshallLocationName("staleSecurityGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StaleSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STALE_SECURITY_GROUP_SET_FIELD));
    private final String nextToken;
    private final List<StaleSecurityGroup> staleSecurityGroupSet;

    private DescribeStaleSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.staleSecurityGroupSet = builder.staleSecurityGroupSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStaleSecurityGroupSet() {
        return this.staleSecurityGroupSet != null && !(this.staleSecurityGroupSet instanceof SdkAutoConstructList);
    }

    public final List<StaleSecurityGroup> staleSecurityGroupSet() {
        return this.staleSecurityGroupSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaleSecurityGroupSet() ? this.staleSecurityGroupSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStaleSecurityGroupsResponse)) {
            return false;
        }
        DescribeStaleSecurityGroupsResponse other = (DescribeStaleSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStaleSecurityGroupSet() == other.hasStaleSecurityGroupSet() && Objects.equals(this.staleSecurityGroupSet(), other.staleSecurityGroupSet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStaleSecurityGroupsResponse").add("NextToken", (Object)this.nextToken()).add("StaleSecurityGroupSet", this.hasStaleSecurityGroupSet() ? this.staleSecurityGroupSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StaleSecurityGroupSet": {
                return Optional.ofNullable(clazz.cast(this.staleSecurityGroupSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStaleSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeStaleSecurityGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<StaleSecurityGroup> staleSecurityGroupSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStaleSecurityGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.staleSecurityGroupSet(model.staleSecurityGroupSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StaleSecurityGroup.Builder> getStaleSecurityGroupSet() {
            if (this.staleSecurityGroupSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.staleSecurityGroupSet != null ? (Collection)this.staleSecurityGroupSet.stream().map(StaleSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(StaleSecurityGroup ... staleSecurityGroupSet) {
            this.staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder> ... staleSecurityGroupSet) {
            this.staleSecurityGroupSet(Stream.of(staleSecurityGroupSet).map(c -> (StaleSecurityGroup)((StaleSecurityGroup.Builder)StaleSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStaleSecurityGroupSet(Collection<StaleSecurityGroup.BuilderImpl> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copyFromBuilder(staleSecurityGroupSet);
        }

        @Override
        public DescribeStaleSecurityGroupsResponse build() {
            return new DescribeStaleSecurityGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> var1);

        public Builder staleSecurityGroupSet(StaleSecurityGroup ... var1);

        public Builder staleSecurityGroupSet(Consumer<StaleSecurityGroup.Builder> ... var1);
    }
}

