/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AttributeBooleanValue;
import software.amazon.awssdk.services.ec2.model.AttributeValue;
import software.amazon.awssdk.services.ec2.model.BlobAttributeValue;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceAttributeName;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
    private static final SdkField<AttributeBooleanValue> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDestCheck").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::sourceDestCheck)).setter(ModifyInstanceAttributeRequest.setter(Builder::sourceDestCheck)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("SourceDestCheck").build()}).build();
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::attributeAsString)).setter(ModifyInstanceAttributeRequest.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").unmarshallLocationName("attribute").build()}).build();
    private static final SdkField<List<InstanceBlockDeviceMappingSpecification>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::blockDeviceMappings)).setter(ModifyInstanceAttributeRequest.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("blockDeviceMapping").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceBlockDeviceMappingSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<AttributeBooleanValue> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisableApiTermination").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::disableApiTermination)).setter(ModifyInstanceAttributeRequest.setter(Builder::disableApiTermination)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("disableApiTermination").build()}).build();
    private static final SdkField<AttributeBooleanValue> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsOptimized").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::ebsOptimized)).setter(ModifyInstanceAttributeRequest.setter(Builder::ebsOptimized)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<AttributeBooleanValue> ENA_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnaSupport").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::enaSupport)).setter(ModifyInstanceAttributeRequest.setter(Builder::enaSupport)).constructor(AttributeBooleanValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnaSupport").unmarshallLocationName("enaSupport").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::groups)).setter(ModifyInstanceAttributeRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("GroupId").build(), ListTrait.builder().memberLocationName("groupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::instanceId)).setter(ModifyInstanceAttributeRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<AttributeValue> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceInitiatedShutdownBehavior").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::instanceInitiatedShutdownBehavior)).setter(ModifyInstanceAttributeRequest.setter(Builder::instanceInitiatedShutdownBehavior)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("instanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<AttributeValue> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceType").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::instanceType)).setter(ModifyInstanceAttributeRequest.setter(Builder::instanceType)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<AttributeValue> KERNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Kernel").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::kernel)).setter(ModifyInstanceAttributeRequest.setter(Builder::kernel)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Kernel").unmarshallLocationName("kernel").build()}).build();
    private static final SdkField<AttributeValue> RAMDISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ramdisk").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::ramdisk)).setter(ModifyInstanceAttributeRequest.setter(Builder::ramdisk)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ramdisk").unmarshallLocationName("ramdisk").build()}).build();
    private static final SdkField<AttributeValue> SRIOV_NET_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SriovNetSupport").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::sriovNetSupport)).setter(ModifyInstanceAttributeRequest.setter(Builder::sriovNetSupport)).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SriovNetSupport").unmarshallLocationName("sriovNetSupport").build()}).build();
    private static final SdkField<BlobAttributeValue> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserData").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::userData)).setter(ModifyInstanceAttributeRequest.setter(Builder::userData)).constructor(BlobAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(ModifyInstanceAttributeRequest.getter(ModifyInstanceAttributeRequest::value)).setter(ModifyInstanceAttributeRequest.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").unmarshallLocationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DEST_CHECK_FIELD, ATTRIBUTE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, DISABLE_API_TERMINATION_FIELD, EBS_OPTIMIZED_FIELD, ENA_SUPPORT_FIELD, GROUPS_FIELD, INSTANCE_ID_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, INSTANCE_TYPE_FIELD, KERNEL_FIELD, RAMDISK_FIELD, SRIOV_NET_SUPPORT_FIELD, USER_DATA_FIELD, VALUE_FIELD));
    private final AttributeBooleanValue sourceDestCheck;
    private final String attribute;
    private final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private final AttributeBooleanValue disableApiTermination;
    private final AttributeBooleanValue ebsOptimized;
    private final AttributeBooleanValue enaSupport;
    private final List<String> groups;
    private final String instanceId;
    private final AttributeValue instanceInitiatedShutdownBehavior;
    private final AttributeValue instanceType;
    private final AttributeValue kernel;
    private final AttributeValue ramdisk;
    private final AttributeValue sriovNetSupport;
    private final BlobAttributeValue userData;
    private final String value;

    private ModifyInstanceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDestCheck = builder.sourceDestCheck;
        this.attribute = builder.attribute;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernel = builder.kernel;
        this.ramdisk = builder.ramdisk;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.value = builder.value;
    }

    public AttributeBooleanValue sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public InstanceAttributeName attribute() {
        return InstanceAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public AttributeBooleanValue disableApiTermination() {
        return this.disableApiTermination;
    }

    public AttributeBooleanValue ebsOptimized() {
        return this.ebsOptimized;
    }

    public AttributeBooleanValue enaSupport() {
        return this.enaSupport;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<String> groups() {
        return this.groups;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public AttributeValue instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public AttributeValue instanceType() {
        return this.instanceType;
    }

    public AttributeValue kernel() {
        return this.kernel;
    }

    public AttributeValue ramdisk() {
        return this.ramdisk;
    }

    public AttributeValue sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public BlobAttributeValue userData() {
        return this.userData;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest)((Object)obj);
        return Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernel(), other.kernel()) && Objects.equals(this.ramdisk(), other.ramdisk()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstanceAttributeRequest").add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Attribute", (Object)this.attributeAsString()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EnaSupport", (Object)this.enaSupport()).add("Groups", this.groups()).add("InstanceId", (Object)this.instanceId()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehavior()).add("InstanceType", (Object)this.instanceType()).add("Kernel", (Object)this.kernel()).add("Ramdisk", (Object)this.ramdisk()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("UserData", (Object)this.userData()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehavior()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Kernel": {
                return Optional.ofNullable(clazz.cast(this.kernel()));
            }
            case "Ramdisk": {
                return Optional.ofNullable(clazz.cast(this.ramdisk()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyInstanceAttributeRequest, T> g) {
        return obj -> g.apply((ModifyInstanceAttributeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private AttributeBooleanValue sourceDestCheck;
        private String attribute;
        private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private AttributeBooleanValue disableApiTermination;
        private AttributeBooleanValue ebsOptimized;
        private AttributeBooleanValue enaSupport;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private AttributeValue instanceInitiatedShutdownBehavior;
        private AttributeValue instanceType;
        private AttributeValue kernel;
        private AttributeValue ramdisk;
        private AttributeValue sriovNetSupport;
        private BlobAttributeValue userData;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceAttributeRequest model) {
            super(model);
            this.sourceDestCheck(model.sourceDestCheck);
            this.attribute(model.attribute);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.disableApiTermination(model.disableApiTermination);
            this.ebsOptimized(model.ebsOptimized);
            this.enaSupport(model.enaSupport);
            this.groups(model.groups);
            this.instanceId(model.instanceId);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.instanceType(model.instanceType);
            this.kernel(model.kernel);
            this.ramdisk(model.ramdisk);
            this.sriovNetSupport(model.sriovNetSupport);
            this.userData(model.userData);
            this.value(model.value);
        }

        public final AttributeBooleanValue.Builder getSourceDestCheck() {
            return this.sourceDestCheck != null ? this.sourceDestCheck.toBuilder() : null;
        }

        @Override
        public final Builder sourceDestCheck(AttributeBooleanValue sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(AttributeBooleanValue.BuilderImpl sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck != null ? sourceDestCheck.build() : null;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final Collection<InstanceBlockDeviceMappingSpecification.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(InstanceBlockDeviceMappingSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMappingSpecification)((InstanceBlockDeviceMappingSpecification.Builder)InstanceBlockDeviceMappingSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final AttributeBooleanValue.Builder getDisableApiTermination() {
            return this.disableApiTermination != null ? this.disableApiTermination.toBuilder() : null;
        }

        @Override
        public final Builder disableApiTermination(AttributeBooleanValue disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(AttributeBooleanValue.BuilderImpl disableApiTermination) {
            this.disableApiTermination = disableApiTermination != null ? disableApiTermination.build() : null;
        }

        public final AttributeBooleanValue.Builder getEbsOptimized() {
            return this.ebsOptimized != null ? this.ebsOptimized.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptimized(AttributeBooleanValue ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(AttributeBooleanValue.BuilderImpl ebsOptimized) {
            this.ebsOptimized = ebsOptimized != null ? ebsOptimized.build() : null;
        }

        public final AttributeBooleanValue.Builder getEnaSupport() {
            return this.enaSupport != null ? this.enaSupport.toBuilder() : null;
        }

        @Override
        public final Builder enaSupport(AttributeBooleanValue enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(AttributeBooleanValue.BuilderImpl enaSupport) {
            this.enaSupport = enaSupport != null ? enaSupport.build() : null;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final AttributeValue.Builder getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.toBuilder() : null;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(AttributeValue instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(AttributeValue.BuilderImpl instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior != null ? instanceInitiatedShutdownBehavior.build() : null;
        }

        public final AttributeValue.Builder getInstanceType() {
            return this.instanceType != null ? this.instanceType.toBuilder() : null;
        }

        @Override
        public final Builder instanceType(AttributeValue instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(AttributeValue.BuilderImpl instanceType) {
            this.instanceType = instanceType != null ? instanceType.build() : null;
        }

        public final AttributeValue.Builder getKernel() {
            return this.kernel != null ? this.kernel.toBuilder() : null;
        }

        @Override
        public final Builder kernel(AttributeValue kernel) {
            this.kernel = kernel;
            return this;
        }

        public final void setKernel(AttributeValue.BuilderImpl kernel) {
            this.kernel = kernel != null ? kernel.build() : null;
        }

        public final AttributeValue.Builder getRamdisk() {
            return this.ramdisk != null ? this.ramdisk.toBuilder() : null;
        }

        @Override
        public final Builder ramdisk(AttributeValue ramdisk) {
            this.ramdisk = ramdisk;
            return this;
        }

        public final void setRamdisk(AttributeValue.BuilderImpl ramdisk) {
            this.ramdisk = ramdisk != null ? ramdisk.build() : null;
        }

        public final AttributeValue.Builder getSriovNetSupport() {
            return this.sriovNetSupport != null ? this.sriovNetSupport.toBuilder() : null;
        }

        @Override
        public final Builder sriovNetSupport(AttributeValue sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(AttributeValue.BuilderImpl sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport != null ? sriovNetSupport.build() : null;
        }

        public final BlobAttributeValue.Builder getUserData() {
            return this.userData != null ? this.userData.toBuilder() : null;
        }

        @Override
        public final Builder userData(BlobAttributeValue userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(BlobAttributeValue.BuilderImpl userData) {
            this.userData = userData != null ? userData.build() : null;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceAttributeRequest build() {
            return new ModifyInstanceAttributeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
        public Builder sourceDestCheck(AttributeBooleanValue var1);

        default public Builder sourceDestCheck(Consumer<AttributeBooleanValue.Builder> sourceDestCheck) {
            return this.sourceDestCheck((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(sourceDestCheck)).build());
        }

        public Builder attribute(String var1);

        public Builder attribute(InstanceAttributeName var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder> ... var1);

        public Builder disableApiTermination(AttributeBooleanValue var1);

        default public Builder disableApiTermination(Consumer<AttributeBooleanValue.Builder> disableApiTermination) {
            return this.disableApiTermination((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(disableApiTermination)).build());
        }

        public Builder ebsOptimized(AttributeBooleanValue var1);

        default public Builder ebsOptimized(Consumer<AttributeBooleanValue.Builder> ebsOptimized) {
            return this.ebsOptimized((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(ebsOptimized)).build());
        }

        public Builder enaSupport(AttributeBooleanValue var1);

        default public Builder enaSupport(Consumer<AttributeBooleanValue.Builder> enaSupport) {
            return this.enaSupport((AttributeBooleanValue)((AttributeBooleanValue.Builder)AttributeBooleanValue.builder().applyMutation(enaSupport)).build());
        }

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(AttributeValue var1);

        default public Builder instanceInitiatedShutdownBehavior(Consumer<AttributeValue.Builder> instanceInitiatedShutdownBehavior) {
            return this.instanceInitiatedShutdownBehavior((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(instanceInitiatedShutdownBehavior)).build());
        }

        public Builder instanceType(AttributeValue var1);

        default public Builder instanceType(Consumer<AttributeValue.Builder> instanceType) {
            return this.instanceType((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(instanceType)).build());
        }

        public Builder kernel(AttributeValue var1);

        default public Builder kernel(Consumer<AttributeValue.Builder> kernel) {
            return this.kernel((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(kernel)).build());
        }

        public Builder ramdisk(AttributeValue var1);

        default public Builder ramdisk(Consumer<AttributeValue.Builder> ramdisk) {
            return this.ramdisk((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(ramdisk)).build());
        }

        public Builder sriovNetSupport(AttributeValue var1);

        default public Builder sriovNetSupport(Consumer<AttributeValue.Builder> sriovNetSupport) {
            return this.sriovNetSupport((AttributeValue)((AttributeValue.Builder)AttributeValue.builder().applyMutation(sriovNetSupport)).build());
        }

        public Builder userData(BlobAttributeValue var1);

        default public Builder userData(Consumer<BlobAttributeValue.Builder> userData) {
            return this.userData((BlobAttributeValue)((BlobAttributeValue.Builder)BlobAttributeValue.builder().applyMutation(userData)).build());
        }

        public Builder value(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

