/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DhcpOptions;
import software.amazon.awssdk.services.ec2.model.DhcpOptionsListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDhcpOptionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
    private static final SdkField<List<DhcpOptions>> DHCP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DhcpOptions").getter(DescribeDhcpOptionsResponse.getter(DescribeDhcpOptionsResponse::dhcpOptions)).setter(DescribeDhcpOptionsResponse.setter(Builder::dhcpOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsSet").unmarshallLocationName("dhcpOptionsSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DhcpOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDhcpOptionsResponse.getter(DescribeDhcpOptionsResponse::nextToken)).setter(DescribeDhcpOptionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_OPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DhcpOptions> dhcpOptions;
    private final String nextToken;

    private DescribeDhcpOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.dhcpOptions = builder.dhcpOptions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDhcpOptions() {
        return this.dhcpOptions != null && !(this.dhcpOptions instanceof SdkAutoConstructList);
    }

    public List<DhcpOptions> dhcpOptions() {
        return this.dhcpOptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDhcpOptionsResponse)) {
            return false;
        }
        DescribeDhcpOptionsResponse other = (DescribeDhcpOptionsResponse)((Object)obj);
        return Objects.equals(this.dhcpOptions(), other.dhcpOptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDhcpOptionsResponse").add("DhcpOptions", this.dhcpOptions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpOptions": {
                return Optional.ofNullable(clazz.cast(this.dhcpOptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDhcpOptionsResponse, T> g) {
        return obj -> g.apply((DescribeDhcpOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DhcpOptions> dhcpOptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDhcpOptionsResponse model) {
            super(model);
            this.dhcpOptions(model.dhcpOptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<DhcpOptions.Builder> getDhcpOptions() {
            return this.dhcpOptions != null ? (Collection)this.dhcpOptions.stream().map(DhcpOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpOptions(Collection<DhcpOptions> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copy(dhcpOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(DhcpOptions ... dhcpOptions) {
            this.dhcpOptions(Arrays.asList(dhcpOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpOptions(Consumer<DhcpOptions.Builder> ... dhcpOptions) {
            this.dhcpOptions(Stream.of(dhcpOptions).map(c -> (DhcpOptions)((DhcpOptions.Builder)DhcpOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpOptions(Collection<DhcpOptions.BuilderImpl> dhcpOptions) {
            this.dhcpOptions = DhcpOptionsListCopier.copyFromBuilder(dhcpOptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDhcpOptionsResponse build() {
            return new DescribeDhcpOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDhcpOptionsResponse> {
        public Builder dhcpOptions(Collection<DhcpOptions> var1);

        public Builder dhcpOptions(DhcpOptions ... var1);

        public Builder dhcpOptions(Consumer<DhcpOptions.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

