/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddPrefixListEntriesCopier;
import software.amazon.awssdk.services.ec2.model.AddPrefixListEntry;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateManagedPrefixListRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateManagedPrefixListRequest> {
    private static final SdkField<String> PREFIX_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrefixListName").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::prefixListName)).setter(CreateManagedPrefixListRequest.setter(Builder::prefixListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListName").unmarshallLocationName("PrefixListName").build()}).build();
    private static final SdkField<List<AddPrefixListEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::entries)).setter(CreateManagedPrefixListRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry").unmarshallLocationName("Entry").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddPrefixListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxEntries").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::maxEntries)).setter(CreateManagedPrefixListRequest.setter(Builder::maxEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEntries").unmarshallLocationName("MaxEntries").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::tagSpecifications)).setter(CreateManagedPrefixListRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> ADDRESS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressFamily").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::addressFamily)).setter(CreateManagedPrefixListRequest.setter(Builder::addressFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressFamily").unmarshallLocationName("AddressFamily").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateManagedPrefixListRequest.getter(CreateManagedPrefixListRequest::clientToken)).setter(CreateManagedPrefixListRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_LIST_NAME_FIELD, ENTRIES_FIELD, MAX_ENTRIES_FIELD, TAG_SPECIFICATIONS_FIELD, ADDRESS_FAMILY_FIELD, CLIENT_TOKEN_FIELD));
    private final String prefixListName;
    private final List<AddPrefixListEntry> entries;
    private final Integer maxEntries;
    private final List<TagSpecification> tagSpecifications;
    private final String addressFamily;
    private final String clientToken;

    private CreateManagedPrefixListRequest(BuilderImpl builder) {
        super(builder);
        this.prefixListName = builder.prefixListName;
        this.entries = builder.entries;
        this.maxEntries = builder.maxEntries;
        this.tagSpecifications = builder.tagSpecifications;
        this.addressFamily = builder.addressFamily;
        this.clientToken = builder.clientToken;
    }

    public String prefixListName() {
        return this.prefixListName;
    }

    public boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public List<AddPrefixListEntry> entries() {
        return this.entries;
    }

    public Integer maxEntries() {
        return this.maxEntries;
    }

    public boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public String addressFamily() {
        return this.addressFamily;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateManagedPrefixListRequest)) {
            return false;
        }
        CreateManagedPrefixListRequest other = (CreateManagedPrefixListRequest)((Object)obj);
        return Objects.equals(this.prefixListName(), other.prefixListName()) && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.maxEntries(), other.maxEntries()) && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.addressFamily(), other.addressFamily()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateManagedPrefixListRequest").add("PrefixListName", (Object)this.prefixListName()).add("Entries", this.entries()).add("MaxEntries", (Object)this.maxEntries()).add("TagSpecifications", this.tagSpecifications()).add("AddressFamily", (Object)this.addressFamily()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrefixListName": {
                return Optional.ofNullable(clazz.cast(this.prefixListName()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "MaxEntries": {
                return Optional.ofNullable(clazz.cast(this.maxEntries()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "AddressFamily": {
                return Optional.ofNullable(clazz.cast(this.addressFamily()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateManagedPrefixListRequest, T> g) {
        return obj -> g.apply((CreateManagedPrefixListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String prefixListName;
        private List<AddPrefixListEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private Integer maxEntries;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String addressFamily;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateManagedPrefixListRequest model) {
            super(model);
            this.prefixListName(model.prefixListName);
            this.entries(model.entries);
            this.maxEntries(model.maxEntries);
            this.tagSpecifications(model.tagSpecifications);
            this.addressFamily(model.addressFamily);
            this.clientToken(model.clientToken);
        }

        public final String getPrefixListName() {
            return this.prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        public final Collection<AddPrefixListEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(AddPrefixListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<AddPrefixListEntry> entries) {
            this.entries = AddPrefixListEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(AddPrefixListEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<AddPrefixListEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (AddPrefixListEntry)((AddPrefixListEntry.Builder)AddPrefixListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<AddPrefixListEntry.BuilderImpl> entries) {
            this.entries = AddPrefixListEntriesCopier.copyFromBuilder(entries);
        }

        public final Integer getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public final Builder maxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public final void setMaxEntries(Integer maxEntries) {
            this.maxEntries = maxEntries;
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return this.tagSpecifications != null ? (Collection)this.tagSpecifications.stream().map(TagSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        public final String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final Builder addressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        public final void setAddressFamily(String addressFamily) {
            this.addressFamily = addressFamily;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateManagedPrefixListRequest build() {
            return new CreateManagedPrefixListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateManagedPrefixListRequest> {
        public Builder prefixListName(String var1);

        public Builder entries(Collection<AddPrefixListEntry> var1);

        public Builder entries(AddPrefixListEntry ... var1);

        public Builder entries(Consumer<AddPrefixListEntry.Builder> ... var1);

        public Builder maxEntries(Integer var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder addressFamily(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

