/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlobAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlobAttributeValue> {
    private static final SdkField<SdkBytes> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Value").getter(BlobAttributeValue.getter(BlobAttributeValue::value)).setter(BlobAttributeValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").unmarshallLocationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes value;

    private BlobAttributeValue(BuilderImpl builder) {
        this.value = builder.value;
    }

    public final SdkBytes value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlobAttributeValue)) {
            return false;
        }
        BlobAttributeValue other = (BlobAttributeValue)obj;
        return Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"BlobAttributeValue").add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlobAttributeValue, T> g) {
        return obj -> g.apply((BlobAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes value;

        private BuilderImpl() {
        }

        private BuilderImpl(BlobAttributeValue model) {
            this.value(model.value);
        }

        public final ByteBuffer getValue() {
            return this.value == null ? null : this.value.asByteBuffer();
        }

        @Override
        public final Builder value(SdkBytes value) {
            this.value = StandardMemberCopier.copy((SdkBytes)value);
            return this;
        }

        public final void setValue(ByteBuffer value) {
            this.value(value == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)value));
        }

        public BlobAttributeValue build() {
            return new BlobAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlobAttributeValue> {
        public Builder value(SdkBytes var1);
    }
}

