/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestSpotInstancesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RequestSpotInstancesResponse> {
    private static final SdkField<List<SpotInstanceRequest>> SPOT_INSTANCE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpotInstanceRequests").getter(RequestSpotInstancesResponse.getter(RequestSpotInstancesResponse::spotInstanceRequests)).setter(RequestSpotInstancesResponse.setter(Builder::spotInstanceRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceRequestSet").unmarshallLocationName("spotInstanceRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpotInstanceRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_INSTANCE_REQUESTS_FIELD));
    private final List<SpotInstanceRequest> spotInstanceRequests;

    private RequestSpotInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.spotInstanceRequests = builder.spotInstanceRequests;
    }

    public boolean hasSpotInstanceRequests() {
        return this.spotInstanceRequests != null && !(this.spotInstanceRequests instanceof SdkAutoConstructList);
    }

    public List<SpotInstanceRequest> spotInstanceRequests() {
        return this.spotInstanceRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.spotInstanceRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesResponse)) {
            return false;
        }
        RequestSpotInstancesResponse other = (RequestSpotInstancesResponse)((Object)obj);
        return Objects.equals(this.spotInstanceRequests(), other.spotInstanceRequests());
    }

    public String toString() {
        return ToString.builder((String)"RequestSpotInstancesResponse").add("SpotInstanceRequests", this.spotInstanceRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SpotInstanceRequests": {
                return Optional.ofNullable(clazz.cast(this.spotInstanceRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestSpotInstancesResponse, T> g) {
        return obj -> g.apply((RequestSpotInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SpotInstanceRequest> spotInstanceRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesResponse model) {
            super(model);
            this.spotInstanceRequests(model.spotInstanceRequests);
        }

        public final Collection<SpotInstanceRequest.Builder> getSpotInstanceRequests() {
            return this.spotInstanceRequests != null ? (Collection)this.spotInstanceRequests.stream().map(SpotInstanceRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotInstanceRequests(Collection<SpotInstanceRequest> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copy(spotInstanceRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(SpotInstanceRequest ... spotInstanceRequests) {
            this.spotInstanceRequests(Arrays.asList(spotInstanceRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... spotInstanceRequests) {
            this.spotInstanceRequests(Stream.of(spotInstanceRequests).map(c -> (SpotInstanceRequest)((SpotInstanceRequest.Builder)SpotInstanceRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpotInstanceRequests(Collection<SpotInstanceRequest.BuilderImpl> spotInstanceRequests) {
            this.spotInstanceRequests = SpotInstanceRequestListCopier.copyFromBuilder(spotInstanceRequests);
        }

        @Override
        public RequestSpotInstancesResponse build() {
            return new RequestSpotInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestSpotInstancesResponse> {
        public Builder spotInstanceRequests(Collection<SpotInstanceRequest> var1);

        public Builder spotInstanceRequests(SpotInstanceRequest ... var1);

        public Builder spotInstanceRequests(Consumer<SpotInstanceRequest.Builder> ... var1);
    }
}

