/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceTypesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceTypesResponse> {
    private static final SdkField<List<InstanceTypeInfo>> INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceTypes").getter(DescribeInstanceTypesResponse.getter(DescribeInstanceTypesResponse::instanceTypes)).setter(DescribeInstanceTypesResponse.setter(Builder::instanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeSet").unmarshallLocationName("instanceTypeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceTypeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeInstanceTypesResponse.getter(DescribeInstanceTypesResponse::nextToken)).setter(DescribeInstanceTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private final List<InstanceTypeInfo> instanceTypes;
    private final String nextToken;

    private DescribeInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.nextToken = builder.nextToken;
    }

    public boolean hasInstanceTypes() {
        return this.instanceTypes != null && !(this.instanceTypes instanceof SdkAutoConstructList);
    }

    public List<InstanceTypeInfo> instanceTypes() {
        return this.instanceTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceTypesResponse)) {
            return false;
        }
        DescribeInstanceTypesResponse other = (DescribeInstanceTypesResponse)((Object)obj);
        return Objects.equals(this.instanceTypes(), other.instanceTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceTypesResponse").add("InstanceTypes", this.instanceTypes()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceTypes()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceTypesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceTypeInfo> instanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceTypesResponse model) {
            super(model);
            this.instanceTypes(model.instanceTypes);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceTypeInfo.Builder> getInstanceTypes() {
            return this.instanceTypes != null ? (Collection)this.instanceTypes.stream().map(InstanceTypeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceTypeInfo> instanceTypes) {
            this.instanceTypes = InstanceTypeInfoListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceTypeInfo ... instanceTypes) {
            this.instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(Consumer<InstanceTypeInfo.Builder> ... instanceTypes) {
            this.instanceTypes(Stream.of(instanceTypes).map(c -> (InstanceTypeInfo)((InstanceTypeInfo.Builder)InstanceTypeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceTypes(Collection<InstanceTypeInfo.BuilderImpl> instanceTypes) {
            this.instanceTypes = InstanceTypeInfoListCopier.copyFromBuilder(instanceTypes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceTypesResponse build() {
            return new DescribeInstanceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceTypesResponse> {
        public Builder instanceTypes(Collection<InstanceTypeInfo> var1);

        public Builder instanceTypes(InstanceTypeInfo ... var1);

        public Builder instanceTypes(Consumer<InstanceTypeInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

