/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus;
import software.amazon.awssdk.services.ec2.model.TerminateConnectionStatusSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TerminateClientVpnConnectionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, TerminateClientVpnConnectionsResponse> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(TerminateClientVpnConnectionsResponse.getter(TerminateClientVpnConnectionsResponse::clientVpnEndpointId)).setter(TerminateClientVpnConnectionsResponse.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").unmarshallLocationName("clientVpnEndpointId").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(TerminateClientVpnConnectionsResponse.getter(TerminateClientVpnConnectionsResponse::username)).setter(TerminateClientVpnConnectionsResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").unmarshallLocationName("username").build()}).build();
    private static final SdkField<List<TerminateConnectionStatus>> CONNECTION_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectionStatuses").getter(TerminateClientVpnConnectionsResponse.getter(TerminateClientVpnConnectionsResponse::connectionStatuses)).setter(TerminateClientVpnConnectionsResponse.setter(Builder::connectionStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatuses").unmarshallLocationName("connectionStatuses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TerminateConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, USERNAME_FIELD, CONNECTION_STATUSES_FIELD));
    private final String clientVpnEndpointId;
    private final String username;
    private final List<TerminateConnectionStatus> connectionStatuses;

    private TerminateClientVpnConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.username = builder.username;
        this.connectionStatuses = builder.connectionStatuses;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasConnectionStatuses() {
        return this.connectionStatuses != null && !(this.connectionStatuses instanceof SdkAutoConstructList);
    }

    public final List<TerminateConnectionStatus> connectionStatuses() {
        return this.connectionStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionStatuses() ? this.connectionStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateClientVpnConnectionsResponse)) {
            return false;
        }
        TerminateClientVpnConnectionsResponse other = (TerminateClientVpnConnectionsResponse)((Object)obj);
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.username(), other.username()) && this.hasConnectionStatuses() == other.hasConnectionStatuses() && Objects.equals(this.connectionStatuses(), other.connectionStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"TerminateClientVpnConnectionsResponse").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Username", (Object)this.username()).add("ConnectionStatuses", this.hasConnectionStatuses() ? this.connectionStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ConnectionStatuses": {
                return Optional.ofNullable(clazz.cast(this.connectionStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminateClientVpnConnectionsResponse, T> g) {
        return obj -> g.apply((TerminateClientVpnConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String username;
        private List<TerminateConnectionStatus> connectionStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateClientVpnConnectionsResponse model) {
            super(model);
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.username(model.username);
            this.connectionStatuses(model.connectionStatuses);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<TerminateConnectionStatus.Builder> getConnectionStatuses() {
            if (this.connectionStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectionStatuses != null ? (Collection)this.connectionStatuses.stream().map(TerminateConnectionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectionStatuses(Collection<TerminateConnectionStatus> connectionStatuses) {
            this.connectionStatuses = TerminateConnectionStatusSetCopier.copy(connectionStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionStatuses(TerminateConnectionStatus ... connectionStatuses) {
            this.connectionStatuses(Arrays.asList(connectionStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionStatuses(Consumer<TerminateConnectionStatus.Builder> ... connectionStatuses) {
            this.connectionStatuses(Stream.of(connectionStatuses).map(c -> (TerminateConnectionStatus)((TerminateConnectionStatus.Builder)TerminateConnectionStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionStatuses(Collection<TerminateConnectionStatus.BuilderImpl> connectionStatuses) {
            this.connectionStatuses = TerminateConnectionStatusSetCopier.copyFromBuilder(connectionStatuses);
        }

        @Override
        public TerminateClientVpnConnectionsResponse build() {
            return new TerminateClientVpnConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TerminateClientVpnConnectionsResponse> {
        public Builder clientVpnEndpointId(String var1);

        public Builder username(String var1);

        public Builder connectionStatuses(Collection<TerminateConnectionStatus> var1);

        public Builder connectionStatuses(TerminateConnectionStatus ... var1);

        public Builder connectionStatuses(Consumer<TerminateConnectionStatus.Builder> ... var1);
    }
}

