/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostProperties> {
    private static final SdkField<Integer> CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Cores").getter(HostProperties.getter(HostProperties::cores)).setter(HostProperties.setter(Builder::cores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cores").unmarshallLocationName("cores").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(HostProperties.getter(HostProperties::instanceType)).setter(HostProperties.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFamily").getter(HostProperties.getter(HostProperties::instanceFamily)).setter(HostProperties.setter(Builder::instanceFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").unmarshallLocationName("instanceFamily").build()}).build();
    private static final SdkField<Integer> SOCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Sockets").getter(HostProperties.getter(HostProperties::sockets)).setter(HostProperties.setter(Builder::sockets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sockets").unmarshallLocationName("sockets").build()}).build();
    private static final SdkField<Integer> TOTAL_V_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalVCpus").getter(HostProperties.getter(HostProperties::totalVCpus)).setter(HostProperties.setter(Builder::totalVCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalVCpus").unmarshallLocationName("totalVCpus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORES_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_FAMILY_FIELD, SOCKETS_FIELD, TOTAL_V_CPUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer cores;
    private final String instanceType;
    private final String instanceFamily;
    private final Integer sockets;
    private final Integer totalVCpus;

    private HostProperties(BuilderImpl builder) {
        this.cores = builder.cores;
        this.instanceType = builder.instanceType;
        this.instanceFamily = builder.instanceFamily;
        this.sockets = builder.sockets;
        this.totalVCpus = builder.totalVCpus;
    }

    public Integer cores() {
        return this.cores;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String instanceFamily() {
        return this.instanceFamily;
    }

    public Integer sockets() {
        return this.sockets;
    }

    public Integer totalVCpus() {
        return this.totalVCpus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cores());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.sockets());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalVCpus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostProperties)) {
            return false;
        }
        HostProperties other = (HostProperties)obj;
        return Objects.equals(this.cores(), other.cores()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceFamily(), other.instanceFamily()) && Objects.equals(this.sockets(), other.sockets()) && Objects.equals(this.totalVCpus(), other.totalVCpus());
    }

    public String toString() {
        return ToString.builder((String)"HostProperties").add("Cores", (Object)this.cores()).add("InstanceType", (Object)this.instanceType()).add("InstanceFamily", (Object)this.instanceFamily()).add("Sockets", (Object)this.sockets()).add("TotalVCpus", (Object)this.totalVCpus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cores": {
                return Optional.ofNullable(clazz.cast(this.cores()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "InstanceFamily": {
                return Optional.ofNullable(clazz.cast(this.instanceFamily()));
            }
            case "Sockets": {
                return Optional.ofNullable(clazz.cast(this.sockets()));
            }
            case "TotalVCpus": {
                return Optional.ofNullable(clazz.cast(this.totalVCpus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostProperties, T> g) {
        return obj -> g.apply((HostProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer cores;
        private String instanceType;
        private String instanceFamily;
        private Integer sockets;
        private Integer totalVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(HostProperties model) {
            this.cores(model.cores);
            this.instanceType(model.instanceType);
            this.instanceFamily(model.instanceFamily);
            this.sockets(model.sockets);
            this.totalVCpus(model.totalVCpus);
        }

        public final Integer getCores() {
            return this.cores;
        }

        @Override
        public final Builder cores(Integer cores) {
            this.cores = cores;
            return this;
        }

        public final void setCores(Integer cores) {
            this.cores = cores;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getInstanceFamily() {
            return this.instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final Integer getSockets() {
            return this.sockets;
        }

        @Override
        public final Builder sockets(Integer sockets) {
            this.sockets = sockets;
            return this;
        }

        public final void setSockets(Integer sockets) {
            this.sockets = sockets;
        }

        public final Integer getTotalVCpus() {
            return this.totalVCpus;
        }

        @Override
        public final Builder totalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
            return this;
        }

        public final void setTotalVCpus(Integer totalVCpus) {
            this.totalVCpus = totalVCpus;
        }

        public HostProperties build() {
            return new HostProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostProperties> {
        public Builder cores(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceFamily(String var1);

        public Builder sockets(Integer var1);

        public Builder totalVCpus(Integer var1);
    }
}

