/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEgressOnlyInternetGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
    private static final SdkField<List<EgressOnlyInternetGateway>> EGRESS_ONLY_INTERNET_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressOnlyInternetGateways").getter(DescribeEgressOnlyInternetGatewaysResponse.getter(DescribeEgressOnlyInternetGatewaysResponse::egressOnlyInternetGateways)).setter(DescribeEgressOnlyInternetGatewaysResponse.setter(Builder::egressOnlyInternetGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGatewaySet").unmarshallLocationName("egressOnlyInternetGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EgressOnlyInternetGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEgressOnlyInternetGatewaysResponse.getter(DescribeEgressOnlyInternetGatewaysResponse::nextToken)).setter(DescribeEgressOnlyInternetGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_ONLY_INTERNET_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<EgressOnlyInternetGateway> egressOnlyInternetGateways;
    private final String nextToken;

    private DescribeEgressOnlyInternetGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGateways = builder.egressOnlyInternetGateways;
        this.nextToken = builder.nextToken;
    }

    public boolean hasEgressOnlyInternetGateways() {
        return this.egressOnlyInternetGateways != null && !(this.egressOnlyInternetGateways instanceof SdkAutoConstructList);
    }

    public List<EgressOnlyInternetGateway> egressOnlyInternetGateways() {
        return this.egressOnlyInternetGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEgressOnlyInternetGateways() ? this.egressOnlyInternetGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEgressOnlyInternetGatewaysResponse)) {
            return false;
        }
        DescribeEgressOnlyInternetGatewaysResponse other = (DescribeEgressOnlyInternetGatewaysResponse)((Object)obj);
        return this.hasEgressOnlyInternetGateways() == other.hasEgressOnlyInternetGateways() && Objects.equals(this.egressOnlyInternetGateways(), other.egressOnlyInternetGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEgressOnlyInternetGatewaysResponse").add("EgressOnlyInternetGateways", this.hasEgressOnlyInternetGateways() ? this.egressOnlyInternetGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressOnlyInternetGateways": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEgressOnlyInternetGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeEgressOnlyInternetGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<EgressOnlyInternetGateway> egressOnlyInternetGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEgressOnlyInternetGatewaysResponse model) {
            super(model);
            this.egressOnlyInternetGateways(model.egressOnlyInternetGateways);
            this.nextToken(model.nextToken);
        }

        public final Collection<EgressOnlyInternetGateway.Builder> getEgressOnlyInternetGateways() {
            if (this.egressOnlyInternetGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return this.egressOnlyInternetGateways != null ? (Collection)this.egressOnlyInternetGateways.stream().map(EgressOnlyInternetGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copy(egressOnlyInternetGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(EgressOnlyInternetGateway ... egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways(Arrays.asList(egressOnlyInternetGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder> ... egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways(Stream.of(egressOnlyInternetGateways).map(c -> (EgressOnlyInternetGateway)((EgressOnlyInternetGateway.Builder)EgressOnlyInternetGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressOnlyInternetGateways(Collection<EgressOnlyInternetGateway.BuilderImpl> egressOnlyInternetGateways) {
            this.egressOnlyInternetGateways = EgressOnlyInternetGatewayListCopier.copyFromBuilder(egressOnlyInternetGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeEgressOnlyInternetGatewaysResponse build() {
            return new DescribeEgressOnlyInternetGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEgressOnlyInternetGatewaysResponse> {
        public Builder egressOnlyInternetGateways(Collection<EgressOnlyInternetGateway> var1);

        public Builder egressOnlyInternetGateways(EgressOnlyInternetGateway ... var1);

        public Builder egressOnlyInternetGateways(Consumer<EgressOnlyInternetGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

