/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyFpgaImageRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CopyFpgaImageRequest> {
    private static final SdkField<String> SOURCE_FPGA_IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFpgaImageId").getter(CopyFpgaImageRequest.getter(CopyFpgaImageRequest::sourceFpgaImageId)).setter(CopyFpgaImageRequest.setter(Builder::sourceFpgaImageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFpgaImageId").unmarshallLocationName("SourceFpgaImageId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CopyFpgaImageRequest.getter(CopyFpgaImageRequest::description)).setter(CopyFpgaImageRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CopyFpgaImageRequest.getter(CopyFpgaImageRequest::name)).setter(CopyFpgaImageRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(CopyFpgaImageRequest.getter(CopyFpgaImageRequest::sourceRegion)).setter(CopyFpgaImageRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").unmarshallLocationName("SourceRegion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CopyFpgaImageRequest.getter(CopyFpgaImageRequest::clientToken)).setter(CopyFpgaImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FPGA_IMAGE_ID_FIELD, DESCRIPTION_FIELD, NAME_FIELD, SOURCE_REGION_FIELD, CLIENT_TOKEN_FIELD));
    private final String sourceFpgaImageId;
    private final String description;
    private final String name;
    private final String sourceRegion;
    private final String clientToken;

    private CopyFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFpgaImageId = builder.sourceFpgaImageId;
        this.description = builder.description;
        this.name = builder.name;
        this.sourceRegion = builder.sourceRegion;
        this.clientToken = builder.clientToken;
    }

    public String sourceFpgaImageId() {
        return this.sourceFpgaImageId;
    }

    public String description() {
        return this.description;
    }

    public String name() {
        return this.name;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFpgaImageRequest)) {
            return false;
        }
        CopyFpgaImageRequest other = (CopyFpgaImageRequest)((Object)obj);
        return Objects.equals(this.sourceFpgaImageId(), other.sourceFpgaImageId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"CopyFpgaImageRequest").add("SourceFpgaImageId", (Object)this.sourceFpgaImageId()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("SourceRegion", (Object)this.sourceRegion()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceFpgaImageId": {
                return Optional.ofNullable(clazz.cast(this.sourceFpgaImageId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyFpgaImageRequest, T> g) {
        return obj -> g.apply((CopyFpgaImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String sourceFpgaImageId;
        private String description;
        private String name;
        private String sourceRegion;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFpgaImageRequest model) {
            super(model);
            this.sourceFpgaImageId(model.sourceFpgaImageId);
            this.description(model.description);
            this.name(model.name);
            this.sourceRegion(model.sourceRegion);
            this.clientToken(model.clientToken);
        }

        public final String getSourceFpgaImageId() {
            return this.sourceFpgaImageId;
        }

        @Override
        public final Builder sourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
            return this;
        }

        public final void setSourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyFpgaImageRequest build() {
            return new CopyFpgaImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyFpgaImageRequest> {
        public Builder sourceFpgaImageId(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder sourceRegion(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

