/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessItem;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSpotFleetRequestsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
    private static final SdkField<List<CancelSpotFleetRequestsSuccessItem>> SUCCESSFUL_FLEET_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulFleetRequests").getter(CancelSpotFleetRequestsResponse.getter(CancelSpotFleetRequestsResponse::successfulFleetRequests)).setter(CancelSpotFleetRequestsResponse.setter(Builder::successfulFleetRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulFleetRequestSet").unmarshallLocationName("successfulFleetRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancelSpotFleetRequestsSuccessItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<CancelSpotFleetRequestsErrorItem>> UNSUCCESSFUL_FLEET_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnsuccessfulFleetRequests").getter(CancelSpotFleetRequestsResponse.getter(CancelSpotFleetRequestsResponse::unsuccessfulFleetRequests)).setter(CancelSpotFleetRequestsResponse.setter(Builder::unsuccessfulFleetRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsuccessfulFleetRequestSet").unmarshallLocationName("unsuccessfulFleetRequestSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancelSpotFleetRequestsErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FLEET_REQUESTS_FIELD, UNSUCCESSFUL_FLEET_REQUESTS_FIELD));
    private final List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests;
    private final List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests;

    private CancelSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulFleetRequests = builder.successfulFleetRequests;
        this.unsuccessfulFleetRequests = builder.unsuccessfulFleetRequests;
    }

    public boolean hasSuccessfulFleetRequests() {
        return this.successfulFleetRequests != null && !(this.successfulFleetRequests instanceof SdkAutoConstructList);
    }

    public List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests() {
        return this.successfulFleetRequests;
    }

    public boolean hasUnsuccessfulFleetRequests() {
        return this.unsuccessfulFleetRequests != null && !(this.unsuccessfulFleetRequests instanceof SdkAutoConstructList);
    }

    public List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests() {
        return this.unsuccessfulFleetRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulFleetRequests() ? this.successfulFleetRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnsuccessfulFleetRequests() ? this.unsuccessfulFleetRequests() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsResponse)) {
            return false;
        }
        CancelSpotFleetRequestsResponse other = (CancelSpotFleetRequestsResponse)((Object)obj);
        return this.hasSuccessfulFleetRequests() == other.hasSuccessfulFleetRequests() && Objects.equals(this.successfulFleetRequests(), other.successfulFleetRequests()) && this.hasUnsuccessfulFleetRequests() == other.hasUnsuccessfulFleetRequests() && Objects.equals(this.unsuccessfulFleetRequests(), other.unsuccessfulFleetRequests());
    }

    public String toString() {
        return ToString.builder((String)"CancelSpotFleetRequestsResponse").add("SuccessfulFleetRequests", this.hasSuccessfulFleetRequests() ? this.successfulFleetRequests() : null).add("UnsuccessfulFleetRequests", this.hasUnsuccessfulFleetRequests() ? this.unsuccessfulFleetRequests() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulFleetRequests": {
                return Optional.ofNullable(clazz.cast(this.successfulFleetRequests()));
            }
            case "UnsuccessfulFleetRequests": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfulFleetRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSpotFleetRequestsResponse, T> g) {
        return obj -> g.apply((CancelSpotFleetRequestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests = DefaultSdkAutoConstructList.getInstance();
        private List<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsResponse model) {
            super(model);
            this.successfulFleetRequests(model.successfulFleetRequests);
            this.unsuccessfulFleetRequests(model.unsuccessfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsSuccessItem.Builder> getSuccessfulFleetRequests() {
            if (this.successfulFleetRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulFleetRequests != null ? (Collection)this.successfulFleetRequests.stream().map(CancelSpotFleetRequestsSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copy(successfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... successfulFleetRequests) {
            this.successfulFleetRequests(Arrays.asList(successfulFleetRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulFleetRequests(Consumer<CancelSpotFleetRequestsSuccessItem.Builder> ... successfulFleetRequests) {
            this.successfulFleetRequests(Stream.of(successfulFleetRequests).map(c -> (CancelSpotFleetRequestsSuccessItem)((CancelSpotFleetRequestsSuccessItem.Builder)CancelSpotFleetRequestsSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem.BuilderImpl> successfulFleetRequests) {
            this.successfulFleetRequests = CancelSpotFleetRequestsSuccessSetCopier.copyFromBuilder(successfulFleetRequests);
        }

        public final Collection<CancelSpotFleetRequestsErrorItem.Builder> getUnsuccessfulFleetRequests() {
            if (this.unsuccessfulFleetRequests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.unsuccessfulFleetRequests != null ? (Collection)this.unsuccessfulFleetRequests.stream().map(CancelSpotFleetRequestsErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copy(unsuccessfulFleetRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests(Arrays.asList(unsuccessfulFleetRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfulFleetRequests(Consumer<CancelSpotFleetRequestsErrorItem.Builder> ... unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests(Stream.of(unsuccessfulFleetRequests).map(c -> (CancelSpotFleetRequestsErrorItem)((CancelSpotFleetRequestsErrorItem.Builder)CancelSpotFleetRequestsErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem.BuilderImpl> unsuccessfulFleetRequests) {
            this.unsuccessfulFleetRequests = CancelSpotFleetRequestsErrorSetCopier.copyFromBuilder(unsuccessfulFleetRequests);
        }

        @Override
        public CancelSpotFleetRequestsResponse build() {
            return new CancelSpotFleetRequestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelSpotFleetRequestsResponse> {
        public Builder successfulFleetRequests(Collection<CancelSpotFleetRequestsSuccessItem> var1);

        public Builder successfulFleetRequests(CancelSpotFleetRequestsSuccessItem ... var1);

        public Builder successfulFleetRequests(Consumer<CancelSpotFleetRequestsSuccessItem.Builder> ... var1);

        public Builder unsuccessfulFleetRequests(Collection<CancelSpotFleetRequestsErrorItem> var1);

        public Builder unsuccessfulFleetRequests(CancelSpotFleetRequestsErrorItem ... var1);

        public Builder unsuccessfulFleetRequests(Consumer<CancelSpotFleetRequestsErrorItem.Builder> ... var1);
    }
}

