/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachment;
import software.amazon.awssdk.services.ec2.model.TransitGatewayVpcAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayVpcAttachmentsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayVpcAttachmentsResponse> {
    private static final SdkField<List<TransitGatewayVpcAttachment>> TRANSIT_GATEWAY_VPC_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayVpcAttachments").getter(DescribeTransitGatewayVpcAttachmentsResponse.getter(DescribeTransitGatewayVpcAttachmentsResponse::transitGatewayVpcAttachments)).setter(DescribeTransitGatewayVpcAttachmentsResponse.setter(Builder::transitGatewayVpcAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayVpcAttachments").unmarshallLocationName("transitGatewayVpcAttachments").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayVpcAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayVpcAttachmentsResponse.getter(DescribeTransitGatewayVpcAttachmentsResponse::nextToken)).setter(DescribeTransitGatewayVpcAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_VPC_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments;
    private final String nextToken;

    private DescribeTransitGatewayVpcAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayVpcAttachments = builder.transitGatewayVpcAttachments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTransitGatewayVpcAttachments() {
        return this.transitGatewayVpcAttachments != null && !(this.transitGatewayVpcAttachments instanceof SdkAutoConstructList);
    }

    public List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments() {
        return this.transitGatewayVpcAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayVpcAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayVpcAttachmentsResponse)) {
            return false;
        }
        DescribeTransitGatewayVpcAttachmentsResponse other = (DescribeTransitGatewayVpcAttachmentsResponse)((Object)obj);
        return Objects.equals(this.transitGatewayVpcAttachments(), other.transitGatewayVpcAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTransitGatewayVpcAttachmentsResponse").add("TransitGatewayVpcAttachments", this.transitGatewayVpcAttachments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayVpcAttachments": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayVpcAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayVpcAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayVpcAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayVpcAttachment> transitGatewayVpcAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayVpcAttachmentsResponse model) {
            super(model);
            this.transitGatewayVpcAttachments(model.transitGatewayVpcAttachments);
            this.nextToken(model.nextToken);
        }

        public final Collection<TransitGatewayVpcAttachment.Builder> getTransitGatewayVpcAttachments() {
            return this.transitGatewayVpcAttachments != null ? (Collection)this.transitGatewayVpcAttachments.stream().map(TransitGatewayVpcAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transitGatewayVpcAttachments(Collection<TransitGatewayVpcAttachment> transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments = TransitGatewayVpcAttachmentListCopier.copy(transitGatewayVpcAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayVpcAttachments(TransitGatewayVpcAttachment ... transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments(Arrays.asList(transitGatewayVpcAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayVpcAttachments(Consumer<TransitGatewayVpcAttachment.Builder> ... transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments(Stream.of(transitGatewayVpcAttachments).map(c -> (TransitGatewayVpcAttachment)((TransitGatewayVpcAttachment.Builder)TransitGatewayVpcAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransitGatewayVpcAttachments(Collection<TransitGatewayVpcAttachment.BuilderImpl> transitGatewayVpcAttachments) {
            this.transitGatewayVpcAttachments = TransitGatewayVpcAttachmentListCopier.copyFromBuilder(transitGatewayVpcAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTransitGatewayVpcAttachmentsResponse build() {
            return new DescribeTransitGatewayVpcAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayVpcAttachmentsResponse> {
        public Builder transitGatewayVpcAttachments(Collection<TransitGatewayVpcAttachment> var1);

        public Builder transitGatewayVpcAttachments(TransitGatewayVpcAttachment ... var1);

        public Builder transitGatewayVpcAttachments(Consumer<TransitGatewayVpcAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

